/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.emotes.fabric.network;

import io.github.kosmx.emotes.PlatformTools;
import io.github.kosmx.emotes.arch.mixin.ServerCommonPacketListenerAccessor;
import io.github.kosmx.emotes.arch.network.CommonServerNetworkHandler;
import io.github.kosmx.emotes.arch.network.ConfigTask;
import io.github.kosmx.emotes.arch.network.EmotesMixinConnection;
import io.github.kosmx.emotes.arch.network.NetworkPlatformTools;
import io.github.kosmx.emotes.arch.network.client.ClientNetwork;
import io.github.kosmx.emotes.common.network.EmotePacket;
import io.github.kosmx.emotes.common.network.EmoteStreamHelper;
import io.github.kosmx.emotes.common.network.PacketTask;
import io.github.kosmx.emotes.common.network.objects.NetData;
import io.github.kosmx.emotes.executor.EmoteInstance;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.logging.Level;
import net.fabricmc.fabric.api.networking.v1.ServerConfigurationConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerConfigurationNetworking;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_8605;
import net.minecraft.class_8610;

public final class ServerNetworkStuff {
    public static void init() {
        ServerConfigurationConnectionEvents.CONFIGURE.register((handler, server) -> {
            if (ServerConfigurationNetworking.canSend((class_8610)handler, (class_2960)NetworkPlatformTools.EMOTE_CHANNEL_ID) && ServerConfigurationNetworking.canSend((class_8610)handler, (class_2960)NetworkPlatformTools.STREAM_CHANNEL_ID)) {
                handler.addTask((class_8605)new ConfigTask());
            } else {
                EmoteInstance.instance.getLogger().log(Level.FINE, "Client doesn't support emotes, ignoring");
            }
        });
        ServerConfigurationNetworking.registerGlobalReceiver((class_2960)NetworkPlatformTools.EMOTE_CHANNEL_ID, (server, handler, buf, responseSender) -> {
            try {
                NetData message = new EmotePacket.Builder().build().read(ByteBuffer.wrap(PlatformTools.unwrap(buf)));
                if (message == null || message.purpose != PacketTask.CONFIG) {
                    throw new IOException("Wrong packet type for config task");
                }
                ((EmotesMixinConnection)((ServerCommonPacketListenerAccessor)handler).getConnection()).emotecraft$setVersions(message.versions);
                CommonServerNetworkHandler.instance.getServerEmotes(message.versions).forEach(buffer -> new EmoteStreamHelper(){

                    @Override
                    protected int getMaxPacketSize() {
                        return 32751;
                    }

                    @Override
                    protected void sendPlayPacket(ByteBuffer buffer) {
                        responseSender.sendPacket(ClientNetwork.playPacket(buffer));
                    }

                    @Override
                    protected void sendStreamChunk(ByteBuffer buffer) {
                        responseSender.sendPacket(ClientNetwork.streamPacket(buffer));
                    }
                });
                handler.completeTask(ConfigTask.TYPE);
            }
            catch (IOException e) {
                EmoteInstance.instance.getLogger().log(Level.WARNING, e.getMessage(), e);
                handler.method_52396((class_2561)class_2561.method_43470((String)("emotecraft: " + e.getMessage())));
            }
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)NetworkPlatformTools.EMOTE_CHANNEL_ID, (server, player, handler, buf, responseSender) -> CommonServerNetworkHandler.instance.receiveMessage(player, handler, buf));
        ServerPlayNetworking.registerGlobalReceiver((class_2960)NetworkPlatformTools.STREAM_CHANNEL_ID, (server, player, handler, buf, responseSender) -> CommonServerNetworkHandler.instance.receiveStreamMessage(player, handler, buf));
        ServerPlayNetworking.registerGlobalReceiver((class_2960)NetworkPlatformTools.GEYSER_CHANNEL_ID, (server, player, handler, buf, responseSender) -> CommonServerNetworkHandler.instance.receiveGeyserMessage(player, buf));
    }
}

