/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.emotes.server.serializer;

import dev.kosmx.playerAnim.core.data.AnimationFormat;
import dev.kosmx.playerAnim.core.data.KeyframeAnimation;
import dev.kosmx.playerAnim.core.data.opennbs.NBSFileUtils;
import dev.kosmx.playerAnim.core.util.MathHelper;
import dev.kosmx.playerAnim.core.util.UUIDMap;
import io.github.kosmx.emotes.executor.EmoteInstance;
import io.github.kosmx.emotes.server.serializer.UniversalEmoteSerializer;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;

public class EmoteSerializer {
    public static void serializeEmotes(UUIDMap<KeyframeAnimation> emotes, File externalEmotes) {
        if (!externalEmotes.isDirectory() && !externalEmotes.mkdir()) {
            return;
        }
        for (File file : Objects.requireNonNull(externalEmotes.listFiles((dir, name) -> name.endsWith(".json")))) {
            emotes.addAll(EmoteSerializer.serializeExternalEmote(file));
        }
        for (File file : Objects.requireNonNull(externalEmotes.listFiles((dir, name) -> name.endsWith("." + AnimationFormat.BINARY.getExtension())))) {
            emotes.addAll(EmoteSerializer.serializeExternalEmote(file));
        }
        if (EmoteInstance.config.enableQuark.get().booleanValue()) {
            EmoteInstance.instance.getLogger().log(Level.INFO, "Quark importer is active", true);
            for (File file : Objects.requireNonNull(externalEmotes.listFiles((dir, name) -> name.endsWith(".emote")))) {
                emotes.addAll(EmoteSerializer.serializeExternalEmote(file));
            }
        }
    }

    private static List<KeyframeAnimation> serializeExternalEmote(File file) {
        LinkedList<KeyframeAnimation> emotes;
        block11: {
            File externalEmotes = EmoteInstance.instance.getExternalEmoteDir();
            emotes = new LinkedList();
            try {
                File song;
                InputStream reader = Files.newInputStream(file.toPath(), new OpenOption[0]);
                emotes = UniversalEmoteSerializer.readData(reader, file.getName());
                reader.close();
                Path icon = externalEmotes.toPath().resolve(file.getName().substring(0, file.getName().length() - 5) + ".png");
                if (icon.toFile().isFile()) {
                    InputStream iconStream = Files.newInputStream(icon, new OpenOption[0]);
                    emotes.forEach(emote -> {
                        try {
                            emote.extraData.put("iconData", MathHelper.readFromIStream((InputStream)iconStream));
                            iconStream.close();
                        }
                        catch (IOException e) {
                            EmoteInstance.instance.getLogger().log(Level.WARNING, e.getMessage(), e);
                        }
                    });
                }
                if (!(song = externalEmotes.toPath().resolve(file.getName().substring(0, file.getName().length() - 5) + ".nbs").toFile()).isFile() || emotes.size() != 1) break block11;
                try (DataInputStream bis = new DataInputStream(Files.newInputStream(song.toPath(), new OpenOption[0]));){
                    ((KeyframeAnimation)emotes.get((int)0)).extraData.put("song", NBSFileUtils.read((DataInputStream)bis));
                }
                catch (IOException exception) {
                    EmoteInstance.instance.getLogger().log(Level.WARNING, "Error while reading song: " + exception.getMessage(), true);
                    if (((Boolean)EmoteInstance.config.showDebug.get()).booleanValue()) {
                        EmoteInstance.instance.getLogger().log(Level.WARNING, exception.getMessage(), exception);
                    }
                }
            }
            catch (Exception e) {
                EmoteInstance.instance.getLogger().log(Level.WARNING, "Error while importing external emote: " + file.getName() + ".", true);
                EmoteInstance.instance.getLogger().log(Level.WARNING, e.getMessage());
                if (!((Boolean)EmoteInstance.config.showDebug.get()).booleanValue()) break block11;
                EmoteInstance.instance.getLogger().log(Level.WARNING, e.getMessage(), e);
            }
        }
        return emotes;
    }
}

