/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.registry.sync.packet;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import it.unimi.dsi.fastutil.objects.Object2IntLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.impl.registry.sync.packet.RegistryPacketHandler;
import net.minecraft.class_2540;
import net.minecraft.class_2596;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public class DirectRegistryPacketHandler
extends RegistryPacketHandler {
    private static final int MAX_PAYLOAD_SIZE = Integer.getInteger("fabric.registry.direct.maxPayloadSize", 0x100000);
    private static final class_2960 ID = new class_2960("fabric", "registry/sync/direct");
    @Nullable
    private class_2540 combinedBuf;
    @Nullable
    private Map<class_2960, Object2IntMap<class_2960>> syncedRegistryMap;
    private boolean isPacketFinished = false;
    private int totalPacketReceived = 0;

    @Override
    public class_2960 getPacketId() {
        return ID;
    }

    @Override
    public void sendPacket(Consumer<class_2596<?>> sender, Map<class_2960, Object2IntMap<class_2960>> registryMap) {
        int sliceSize;
        class_2540 buf = PacketByteBufs.create();
        Map<String, List<class_2960>> regNamespaceGroups = registryMap.keySet().stream().collect(Collectors.groupingBy(class_2960::method_12836));
        buf.method_10804(regNamespaceGroups.size());
        regNamespaceGroups.forEach((regNamespace, regIds) -> {
            buf.method_10814(DirectRegistryPacketHandler.optimizeNamespace(regNamespace));
            buf.method_10804(regIds.size());
            for (class_2960 regId : regIds) {
                buf.method_10814(regId.method_12832());
                Object2IntMap idMap = (Object2IntMap)registryMap.get(regId);
                Map idNamespaceGroups = idMap.object2IntEntrySet().stream().collect(Collectors.groupingBy(e -> ((class_2960)e.getKey()).method_12836(), LinkedHashMap::new, Collectors.toCollection(ArrayList::new)));
                buf.method_10804(idNamespaceGroups.size());
                int lastBulkLastRawId = 0;
                for (Map.Entry idNamespaceEntry : idNamespaceGroups.entrySet()) {
                    List idPairs = (List)idNamespaceEntry.getValue();
                    idPairs.sort(Comparator.comparingInt(Object2IntMap.Entry::getIntValue));
                    ArrayList bulks = new ArrayList();
                    Iterator idPairIter = idPairs.iterator();
                    ArrayList<Object2IntMap.Entry> currentBulk = new ArrayList<Object2IntMap.Entry>();
                    Object2IntMap.Entry currentPair = (Object2IntMap.Entry)idPairIter.next();
                    currentBulk.add(currentPair);
                    while (idPairIter.hasNext()) {
                        currentPair = (Object2IntMap.Entry)idPairIter.next();
                        if (((Object2IntMap.Entry)currentBulk.get(currentBulk.size() - 1)).getIntValue() + 1 != currentPair.getIntValue()) {
                            bulks.add(currentBulk);
                            currentBulk = new ArrayList();
                        }
                        currentBulk.add(currentPair);
                    }
                    bulks.add(currentBulk);
                    buf.method_10814(DirectRegistryPacketHandler.optimizeNamespace((String)idNamespaceEntry.getKey()));
                    buf.method_10804(bulks.size());
                    for (List list : bulks) {
                        int firstRawId = ((Object2IntMap.Entry)list.get(0)).getIntValue();
                        int bulkRawIdStartDiff = firstRawId - lastBulkLastRawId;
                        buf.method_10804(bulkRawIdStartDiff);
                        buf.method_10804(list.size());
                        for (Object2IntMap.Entry idPair : list) {
                            buf.method_10814(((class_2960)idPair.getKey()).method_12832());
                            lastBulkLastRawId = idPair.getIntValue();
                        }
                    }
                }
            }
        });
        int readableBytes = buf.readableBytes();
        for (int sliceIndex = 0; sliceIndex < readableBytes; sliceIndex += sliceSize) {
            sliceSize = Math.min(readableBytes - sliceIndex, MAX_PAYLOAD_SIZE);
            class_2540 slicedBuf = PacketByteBufs.slice((ByteBuf)buf, (int)sliceIndex, (int)sliceSize);
            this.sendPacket(sender, slicedBuf);
        }
        this.sendPacket(sender, PacketByteBufs.empty());
    }

    @Override
    public void receivePacket(class_2540 slicedBuf) {
        Preconditions.checkState((!this.isPacketFinished ? 1 : 0) != 0);
        ++this.totalPacketReceived;
        if (this.combinedBuf == null) {
            this.combinedBuf = PacketByteBufs.create();
        }
        if (slicedBuf.readableBytes() != 0) {
            this.combinedBuf.method_52975((ByteBuf)slicedBuf);
            return;
        }
        this.isPacketFinished = true;
        this.computeBufSize(this.combinedBuf);
        this.syncedRegistryMap = new LinkedHashMap<class_2960, Object2IntMap<class_2960>>();
        int regNamespaceGroupAmount = this.combinedBuf.method_10816();
        for (int i = 0; i < regNamespaceGroupAmount; ++i) {
            String regNamespace = DirectRegistryPacketHandler.unoptimizeNamespace(this.combinedBuf.method_19772());
            int regNamespaceGroupLength = this.combinedBuf.method_10816();
            for (int j = 0; j < regNamespaceGroupLength; ++j) {
                String regPath = this.combinedBuf.method_19772();
                Object2IntLinkedOpenHashMap idMap = new Object2IntLinkedOpenHashMap();
                int idNamespaceGroupAmount = this.combinedBuf.method_10816();
                int lastBulkLastRawId = 0;
                for (int k = 0; k < idNamespaceGroupAmount; ++k) {
                    String idNamespace = DirectRegistryPacketHandler.unoptimizeNamespace(this.combinedBuf.method_19772());
                    int rawIdBulkAmount = this.combinedBuf.method_10816();
                    for (int l = 0; l < rawIdBulkAmount; ++l) {
                        int bulkRawIdStartDiff = this.combinedBuf.method_10816();
                        int bulkSize = this.combinedBuf.method_10816();
                        int currentRawId = lastBulkLastRawId + bulkRawIdStartDiff - 1;
                        for (int m = 0; m < bulkSize; ++m) {
                            String idPath = this.combinedBuf.method_19772();
                            idMap.put((Object)new class_2960(idNamespace, idPath), ++currentRawId);
                        }
                        lastBulkLastRawId = currentRawId;
                    }
                }
                this.syncedRegistryMap.put(new class_2960(regNamespace, regPath), (Object2IntMap<class_2960>)idMap);
            }
        }
        this.combinedBuf.release();
        this.combinedBuf = null;
    }

    @Override
    public boolean isPacketFinished() {
        return this.isPacketFinished;
    }

    @Override
    public int getTotalPacketReceived() {
        Preconditions.checkState((boolean)this.isPacketFinished);
        return this.totalPacketReceived;
    }

    @Override
    @Nullable
    public Map<class_2960, Object2IntMap<class_2960>> getSyncedRegistryMap() {
        Preconditions.checkState((boolean)this.isPacketFinished);
        Map<class_2960, Object2IntMap<class_2960>> map = this.syncedRegistryMap;
        this.isPacketFinished = false;
        this.totalPacketReceived = 0;
        this.syncedRegistryMap = null;
        return map;
    }

    private static String optimizeNamespace(String namespace) {
        return namespace.equals("minecraft") ? "" : namespace;
    }

    private static String unoptimizeNamespace(String namespace) {
        return namespace.isEmpty() ? "minecraft" : namespace;
    }
}

