/*
 * Decompiled with CFR 0.152.
 */
package de.guntram.mcmod.crowdintranslate;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class CrowdinTranslate
extends Thread {
    private static final Map<String, String> mcCodetoCrowdinCode;
    private static String rootDir;
    private static boolean thisIsAMod;
    private static final Set<String> registeredMods;
    private static Tristate downloadsAllowed;
    private String crowdinProjectName;
    private String minecraftProjectName;
    private Optional<String> sourceFileOverride = Optional.empty();
    private boolean verbose;

    private static void add(String mc, String ci) {
        mcCodetoCrowdinCode.put(mc, ci);
    }

    public static void downloadTranslations(String projectName) {
        CrowdinTranslate.downloadTranslations(projectName, projectName);
    }

    public static void downloadTranslations(String crowdinProjectName, String minecraftProjectName) {
        CrowdinTranslate.downloadTranslations(crowdinProjectName, minecraftProjectName, false);
    }

    public static void downloadTranslations(String crowdinProjectName, String minecraftProjectName, boolean verbose) {
        CrowdinTranslate.downloadTranslations(crowdinProjectName, minecraftProjectName, null, verbose);
    }

    public static void downloadTranslations(String crowdinProjectName, String minecraftProjectName, String sourcefileOverride) {
        CrowdinTranslate.downloadTranslations(crowdinProjectName, minecraftProjectName, sourcefileOverride, false);
    }

    public static void downloadTranslations(String crowdinProjectName, String minecraftProjectName, String sourcefileOverride, boolean verbose) {
        registeredMods.add(minecraftProjectName);
        if (thisIsAMod && (!CrowdinTranslate.downloadsAllowed() || CrowdinTranslate.projectDownloadedRecently(minecraftProjectName))) {
            return;
        }
        CrowdinTranslate runner = new CrowdinTranslate(crowdinProjectName, minecraftProjectName);
        if (verbose) {
            runner.setVerbose();
        }
        if (sourcefileOverride != null) {
            runner.setSourceFileOverride(sourcefileOverride);
        }
        runner.start();
        if (!thisIsAMod) {
            try {
                runner.join(10000L);
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static synchronized boolean downloadsAllowed() {
        if (downloadsAllowed != Tristate.UNKNOWN) {
            return downloadsAllowed == Tristate.YES;
        }
        File file = new File("config/crowdin.txt");
        if (file.exists()) {
            try (FileReader fr2 = new FileReader(file);
                 BufferedReader br = new BufferedReader(fr2);){
                while (true) {
                    String line;
                    if ((line = br.readLine()) != null) {
                        if (!line.startsWith("download=")) continue;
                        String val = line.substring(9);
                        if (!"0".equals(val) && !"false".equalsIgnoreCase(val) && !"no".equalsIgnoreCase(val)) continue;
                        downloadsAllowed = Tristate.NO;
                        boolean bl = false;
                        return bl;
                        continue;
                    }
                    break;
                }
            }
            catch (IOException fr2) {}
        } else {
            try (FileWriter fw = new FileWriter(file);){
                fw.append("#Change this to no to prevent mod translation downloads\ndownload=yes\n");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        downloadsAllowed = Tristate.YES;
        return true;
    }

    private static void forceClose(Closeable c) {
        try {
            c.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static Set<String> registeredMods() {
        return registeredMods;
    }

    public static String getRootDir() {
        return rootDir;
    }

    private CrowdinTranslate(String crowdinProjectName, String minecraftProjectName) {
        this.crowdinProjectName = crowdinProjectName;
        this.minecraftProjectName = minecraftProjectName;
        this.verbose = false;
    }

    private void setVerbose() {
        this.verbose = true;
    }

    private void setSourceFileOverride(String name) {
        this.sourceFileOverride = name == null ? Optional.empty() : (name.toLowerCase().endsWith(".json") ? Optional.of(name) : Optional.of(name + ".json"));
    }

    @Override
    public void run() {
        Map<String, byte[]> translations;
        try {
            translations = this.getCrowdinTranslations(this.crowdinProjectName);
        }
        catch (IOException ex) {
            System.err.println("Exception when downloading translations");
            ex.printStackTrace(System.err);
            return;
        }
        String assetDir = rootDir + File.separatorChar + "assets" + File.separatorChar + this.minecraftProjectName + File.separatorChar + "lang";
        new File(assetDir).mkdirs();
        block2: for (Map.Entry<String, String> entry : mcCodetoCrowdinCode.entrySet()) {
            String[] sourcesByPreference;
            for (String attemptingSource : sourcesByPreference = entry.getValue().split(",")) {
                byte[] buffer = translations.get(attemptingSource);
                if (buffer == null) continue;
                String filePath = assetDir + File.separatorChar + entry.getKey() + ".json";
                if (this.verbose) {
                    System.out.println("writing " + buffer.length + " bytes from \"" + attemptingSource + "\" to MC file " + filePath);
                }
                this.saveBufferToJsonFile(buffer, filePath);
                continue block2;
            }
        }
        if (thisIsAMod) {
            CrowdinTranslate.markDownloadedNow(this.minecraftProjectName);
        }
    }

    private Map<String, byte[]> getCrowdinTranslations(String projectName) throws IOException {
        ZipInputStream zis = null;
        Pattern pattern = Pattern.compile("^([a-z]{2}(-[A-Z]{2})?)/(.+\\.json)$");
        HashMap<String, byte[]> zipContents = new HashMap<String, byte[]>();
        try {
            ZipEntry entry;
            URL url = new URL("https://crowdin.com/backend/download/project/" + projectName + ".zip");
            if (this.verbose) {
                System.out.println("Trying to download " + url);
            }
            zis = new ZipInputStream(url.openStream());
            while ((entry = zis.getNextEntry()) != null) {
                String path = entry.getName();
                Matcher matcher = pattern.matcher(path);
                if (!matcher.matches()) continue;
                String crowdinLang = matcher.group(1);
                String origFileName = matcher.group(3);
                if (this.sourceFileOverride.isPresent() && !this.sourceFileOverride.get().equals(origFileName)) {
                    if (!this.verbose) continue;
                    System.out.println("Ignoring " + path + ", we're looking for " + this.sourceFileOverride.get());
                    continue;
                }
                if (this.verbose) {
                    System.out.println("Found translation \"" + crowdinLang + "\" for file " + origFileName);
                }
                if (entry.getSize() > 10000000L) {
                    throw new IOException("file too large: " + entry.getName() + ": " + entry.getSize());
                }
                byte[] zipFileContent = this.getZipStreamContent(zis, (int)entry.getSize());
                if (zipContents.containsKey(crowdinLang)) {
                    System.err.println("More than one file for " + crowdinLang + ", ignoring " + origFileName);
                    continue;
                }
                zipContents.put(matcher.group(1), zipFileContent);
            }
        }
        catch (IOException ex) {
            if (zis != null) {
                CrowdinTranslate.forceClose(zis);
            }
            throw ex;
        }
        return zipContents;
    }

    private byte[] getZipStreamContent(InputStream is, int size) throws IOException {
        int readNow;
        byte[] buf = new byte[size];
        int totalRead = 0;
        for (int toRead = size; toRead > 0; toRead -= readNow) {
            readNow = is.read(buf, totalRead, toRead);
            if (readNow <= 0) {
                throw new IOException("premature end of stream");
            }
            totalRead += readNow;
        }
        return buf;
    }

    private void saveBufferToJsonFile(byte[] buffer, String filename) {
        File file = new File(filename);
        try (FileOutputStream stream = new FileOutputStream(filename);){
            stream.write(buffer);
        }
        catch (IOException ex) {
            System.err.println("failed to write " + filename);
            System.err.println("absolute path is " + file.getAbsolutePath());
            ex.printStackTrace(System.err);
        }
    }

    private static boolean projectDownloadedRecently(String projectName) {
        File file = new File(rootDir, projectName + ".timestamp");
        return file.exists() && file.lastModified() > System.currentTimeMillis() - 259200000L;
    }

    private static void markDownloadedNow(String projectName) {
        File file = new File(rootDir, projectName + ".timestamp");
        try {
            file.getParentFile().mkdirs();
            file.createNewFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        file.setLastModified(System.currentTimeMillis());
    }

    public static void main(String[] args) {
        boolean verbose = false;
        int startArg = 0;
        rootDir = "src/main/resources";
        thisIsAMod = false;
        if (args.length > 0 && args[0].equals("-v")) {
            verbose = true;
            ++startArg;
        }
        if (args.length == startArg + 1) {
            CrowdinTranslate.downloadTranslations(args[startArg], args[startArg], verbose);
        } else if (args.length == startArg + 2) {
            CrowdinTranslate.downloadTranslations(args[startArg], args[startArg + 1], verbose);
        } else if (args.length == startArg + 3) {
            CrowdinTranslate.downloadTranslations(args[startArg], args[startArg + 1], args[startArg + 2], verbose);
        } else {
            System.out.println("Usage: CrowdinTranslate [-v] crowdin_project_name [minecraft_project_name]");
            System.out.println("\t-v enables verbose logging");
            System.out.println("\tGet the translations from crowdin.com/project/name\n\tand write them to assets/project/lang");
            System.out.println("\tThe second parameter is only neccesary if the crowdin project name\n\tdoesn't match the minecraft project name");
        }
    }

    static {
        rootDir = "ModTranslations";
        thisIsAMod = true;
        downloadsAllowed = Tristate.UNKNOWN;
        mcCodetoCrowdinCode = new HashMap<String, String>();
        registeredMods = new HashSet<String>();
        CrowdinTranslate.add("af_za", "af");
        CrowdinTranslate.add("ar_sa", "ar");
        CrowdinTranslate.add("ast_es", "ast");
        CrowdinTranslate.add("az_az", "az");
        CrowdinTranslate.add("ba_ru", "ba");
        CrowdinTranslate.add("be_by", "be");
        CrowdinTranslate.add("bg_bg", "bg");
        CrowdinTranslate.add("br_fr", "br-FR");
        CrowdinTranslate.add("bs_ba", "bs");
        CrowdinTranslate.add("ca_es", "ca");
        CrowdinTranslate.add("cs_cz", "cs");
        CrowdinTranslate.add("cy_gb", "cy");
        CrowdinTranslate.add("da_dk", "da");
        CrowdinTranslate.add("de_at", "de-AT,de");
        CrowdinTranslate.add("de_ch", "de-CH,de");
        CrowdinTranslate.add("de_de", "de");
        CrowdinTranslate.add("el_gr", "el");
        CrowdinTranslate.add("en_au", "en-AU,en-GB,en-US");
        CrowdinTranslate.add("en_ca", "en-CA,en-GB,en-US");
        CrowdinTranslate.add("en_gb", "en-GB,en-US");
        CrowdinTranslate.add("en_nz", "en-NZ,en-GB,en-US");
        CrowdinTranslate.add("en_pt", "en-PT,en-GB,en-US");
        CrowdinTranslate.add("en_ud", "en-UD,en-GB,en-US");
        CrowdinTranslate.add("en_us", "en-US");
        CrowdinTranslate.add("en_ws", "en-WS");
        CrowdinTranslate.add("en_7s", "en-PT");
        CrowdinTranslate.add("en_ud", "en-UD");
        CrowdinTranslate.add("eo_uy", "eo");
        CrowdinTranslate.add("es_ar", "es-AR,es-ES");
        CrowdinTranslate.add("es_cl", "es-CL,es-ES");
        CrowdinTranslate.add("es_ec", "es-EC,es-ES");
        CrowdinTranslate.add("es_es", "es-ES");
        CrowdinTranslate.add("es_mx", "es-MX,es-ES");
        CrowdinTranslate.add("es_uy", "es-UY,es-ES");
        CrowdinTranslate.add("es_ve", "es-VE,es-ES");
        CrowdinTranslate.add("et_ee", "et");
        CrowdinTranslate.add("eu_es", "eu");
        CrowdinTranslate.add("fa_ir", "fa");
        CrowdinTranslate.add("fi_fi", "fi");
        CrowdinTranslate.add("fil_ph", "fil");
        CrowdinTranslate.add("fo_fo", "fo");
        CrowdinTranslate.add("fr_ca", "fr-CA,fr");
        CrowdinTranslate.add("fr_fr", "fr");
        CrowdinTranslate.add("fra_de", "fra-DE");
        CrowdinTranslate.add("fy_nl", "fy-NL");
        CrowdinTranslate.add("ga_ie", "ga-IE");
        CrowdinTranslate.add("gd_gb", "gd");
        CrowdinTranslate.add("gl_es", "gl");
        CrowdinTranslate.add("haw_us", "haw");
        CrowdinTranslate.add("he_il", "he");
        CrowdinTranslate.add("hi_in", "hi");
        CrowdinTranslate.add("hr_hr", "hr");
        CrowdinTranslate.add("hu_hu", "hu");
        CrowdinTranslate.add("hy_am", "hy-AM");
        CrowdinTranslate.add("id_id", "id");
        CrowdinTranslate.add("ig_ng", "ig");
        CrowdinTranslate.add("io_en", "ido");
        CrowdinTranslate.add("is_is", "is");
        CrowdinTranslate.add("it_it", "it");
        CrowdinTranslate.add("ja_jp", "ja");
        CrowdinTranslate.add("jbo_en", "jbo");
        CrowdinTranslate.add("ka_ge", "ka");
        CrowdinTranslate.add("kk_kz", "kk");
        CrowdinTranslate.add("kn_in", "kn");
        CrowdinTranslate.add("ko_kr", "ko");
        CrowdinTranslate.add("kw_gb", "kw");
        CrowdinTranslate.add("la_la", "la-LA");
        CrowdinTranslate.add("lb_lu", "lb");
        CrowdinTranslate.add("li_li", "li");
        CrowdinTranslate.add("lol_us", "lol");
        CrowdinTranslate.add("lt_lt", "lt");
        CrowdinTranslate.add("lv_lv", "lv");
        CrowdinTranslate.add("mi_NZ", "mi");
        CrowdinTranslate.add("mk_mk", "mk");
        CrowdinTranslate.add("mn_mn", "mn");
        CrowdinTranslate.add("ms_my", "ms");
        CrowdinTranslate.add("mt_mt", "mt");
        CrowdinTranslate.add("nds_de", "nds");
        CrowdinTranslate.add("nl_be", "nl-BE,nl");
        CrowdinTranslate.add("nl_nl", "nl");
        CrowdinTranslate.add("nn_no", "nn-NO,no");
        CrowdinTranslate.add("no_no", "no,nb");
        CrowdinTranslate.add("oc_fr", "oc");
        CrowdinTranslate.add("pl_pl", "pl");
        CrowdinTranslate.add("pt_br", "pt-BR,pt-PT");
        CrowdinTranslate.add("pt_pt", "pt-PT,pt-BR");
        CrowdinTranslate.add("qya_aa", "qya-AA");
        CrowdinTranslate.add("ro_ro", "ro");
        CrowdinTranslate.add("ru_ru", "ru");
        CrowdinTranslate.add("se_no", "se");
        CrowdinTranslate.add("sk_sk", "sk");
        CrowdinTranslate.add("sl_si", "sl");
        CrowdinTranslate.add("so_so", "so");
        CrowdinTranslate.add("sq_al", "sq");
        CrowdinTranslate.add("sr_sp", "sr");
        CrowdinTranslate.add("sv_se", "sv-SE");
        CrowdinTranslate.add("ta_in", "ta");
        CrowdinTranslate.add("th_th", "th");
        CrowdinTranslate.add("tl_ph", "tl");
        CrowdinTranslate.add("tlh_aa", "tlh-AA");
        CrowdinTranslate.add("tr_tr", "tr");
        CrowdinTranslate.add("tt_ru", "tt-RU");
        CrowdinTranslate.add("uk_ua", "uk");
        CrowdinTranslate.add("val_es", "val-ES");
        CrowdinTranslate.add("vec_it", "vec");
        CrowdinTranslate.add("vi_vn", "vi");
        CrowdinTranslate.add("yi_de", "yi");
        CrowdinTranslate.add("yo_ng", "yo");
        CrowdinTranslate.add("zh_cn", "zh-CN,zh-HK");
        CrowdinTranslate.add("zh_hk", "zh-HK,zh-CN");
        CrowdinTranslate.add("zh_tw", "zh-TW");
    }

    static enum Tristate {
        UNKNOWN,
        YES,
        NO;

    }
}

