/*
 * Decompiled with CFR 0.152.
 */
package dev.onyxstudios.cca.internal.base;

import dev.onyxstudios.cca.api.v3.component.ComponentRegistry;
import dev.onyxstudios.cca.internal.base.asm.StaticComponentLoadingException;
import java.io.BufferedReader;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.Properties;
import javax.annotation.Nonnull;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2960;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class ComponentsInternals {
    public static final Logger LOGGER = LogManager.getLogger((String)"Cardinal Components API");
    private static boolean logDeserializationWarnings = true;

    public static void init() {
        Path path = FabricLoader.getInstance().getConfigDir().resolve("cardinal-components-api.properties");
        try (BufferedReader reader = Files.newBufferedReader(path);){
            Properties cfg = new Properties();
            cfg.load(reader);
            logDeserializationWarnings = Boolean.parseBoolean(cfg.getProperty("log-deserialization-warnings", "true"));
        }
        catch (IOException e) {
            try {
                Files.writeString(path, (CharSequence)"# If set to false, warnings will not get logged when a component fails to be resolved (typically due to mods being removed)\n# Default value: true\nlog-deserialization-warnings = true\n\n# Internal value, do not edit or your changes may be arbitrarily reset\nconfig-version = 1\n", new OpenOption[0]);
            }
            catch (IOException ex) {
                LOGGER.error("Failed to write config file at {}", (Object)path);
            }
        }
    }

    @Nonnull
    public static <R> R createFactory(Class<R> factoryClass) {
        try {
            Object[] constructors = factoryClass.getConstructors();
            if (constructors.length != 1) {
                throw new IllegalArgumentException("Expected 1 constructor declaration in " + factoryClass + ", got " + Arrays.toString(constructors));
            }
            Object ret = constructors[0].newInstance(new Object[0]);
            return (R)ret;
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new StaticComponentLoadingException("Failed to instantiate generated component factory", e);
        }
    }

    public static void logDeserializationWarnings(Collection<String> missedKeyIds) {
        if (logDeserializationWarnings) {
            for (String missedKeyId : missedKeyIds) {
                class_2960 id = class_2960.method_12829((String)missedKeyId);
                String cause = id == null ? "invalid identifier" : (ComponentRegistry.get(id) == null ? "unregistered key" : "provider does not have ");
                LOGGER.warn("Failed to deserialize component: {} {}", (Object)cause, (Object)missedKeyId);
            }
        }
    }
}

