/*
 * Decompiled with CFR 0.152.
 */
package com.nettakrim.signed_paintings.rendering;

import com.nettakrim.signed_paintings.SignedPaintingsClient;
import com.nettakrim.signed_paintings.access.SignBlockEntityAccessor;
import com.nettakrim.signed_paintings.rendering.BackType;
import com.nettakrim.signed_paintings.rendering.Centering;
import com.nettakrim.signed_paintings.rendering.PaintingInfo;
import com.nettakrim.signed_paintings.util.ImageData;
import com.nettakrim.signed_paintings.util.SignByteMapper;
import net.minecraft.class_2625;
import net.minecraft.class_3532;
import net.minecraft.class_8242;
import org.joml.Vector3f;

public class SignSideInfo {
    public class_8242 text;
    public PaintingInfo paintingInfo;
    private PaintingDataCache cache;
    private boolean updatingSignText;

    public SignSideInfo(class_8242 text, PaintingInfo paintingInfo) {
        this.text = text;
        this.paintingInfo = paintingInfo;
    }

    public void loadPainting(boolean isFront, class_2625 blockEntity, boolean working) {
        String[] parts = this.getParts();
        this.cache = new PaintingDataCache(parts[0]);
        String url = SignedPaintingsClient.imageManager.applyURLInferences(parts[0]);
        this.loadURL(url, parts.length > 1 ? parts[1] : "", isFront, blockEntity, working);
    }

    public String getData() {
        return String.join((CharSequence)"|", this.getParts());
    }

    public String getUrl() {
        return SignedPaintingsClient.imageManager.applyURLInferences(this.getParts()[0]);
    }

    private String[] getParts() {
        String[] parts;
        String combinedText;
        String string = combinedText = SignedPaintingsClient.currentSignEdit == null ? SignedPaintingsClient.combineSignText(this.text) : SignedPaintingsClient.currentSignEdit.screen.signedPaintings$getText();
        if (combinedText.startsWith(SignByteMapper.INITIALIZER_STRING) && (parts = combinedText.substring(2).split(SignByteMapper.DELIMITER, 2)).length > 0) {
            parts[0] = SignByteMapper.decode(parts[0]);
            combinedText = parts.length > 1 ? parts[0] + "|" + parts[1] : parts[0];
        }
        return combinedText.split("[\\n ]|(\\|)", 2);
    }

    private void loadURL(String url, String afterURL, boolean isFront, class_2625 blockEntity, boolean working) {
        if (this.paintingInfo != null) {
            this.paintingInfo.invalidateImage();
        }
        SignedPaintingsClient.imageManager.loadImage(url, data -> this.updateInfo(data, afterURL, isFront, blockEntity, working));
    }

    public void updateInfo(ImageData data, String afterURL, boolean isFront, class_2625 blockEntity, boolean working) {
        SignedPaintingsClient.info("updating painting info for " + data.getBaseIdentifier(), false);
        if (this.paintingInfo == null) {
            this.paintingInfo = new PaintingInfo(data, isFront, blockEntity);
        } else {
            this.paintingInfo.updateImage(data);
        }
        this.paintingInfo.working = working;
        this.cache.init(this.paintingInfo);
        SignedPaintingsClient.info("loading extra data \"" + afterURL + "\"", false);
        this.updateCache(afterURL);
        if (data.ready && SignedPaintingsClient.currentSignEdit != null && ((SignBlockEntityAccessor)SignedPaintingsClient.currentSignEdit.sign).signedPaintings$hasSignSideInfo(this)) {
            SignedPaintingsClient.currentSignEdit.screen.signedPaintings$setVisibility(true);
            SignedPaintingsClient.currentSignEdit.screen.signedPaintings$initSliders(this);
        }
    }

    public void updatePaintingCentering(Centering.Type xCentering, Centering.Type yCentering) {
        if (this.paintingInfo == null) {
            return;
        }
        this.paintingInfo.updateCuboidCentering(xCentering, yCentering);
        this.cache.xCentering = xCentering;
        this.cache.yCentering = yCentering;
        this.updateSignText();
    }

    public void updatePaintingSize(float xSize, float ySize) {
        if (this.paintingInfo == null) {
            return;
        }
        this.paintingInfo.updateCuboidSize(xSize, ySize);
        this.cache.width = xSize;
        this.cache.height = ySize;
        this.updateSignText();
    }

    public void updatePaintingOffset(Vector3f vec) {
        if (this.paintingInfo == null) {
            return;
        }
        this.paintingInfo.updateOffsetVec(vec);
        this.cache.offsetVec = vec;
        this.updateSignText();
    }

    public void updateRotatingVector(Vector3f vec) {
        if (this.paintingInfo == null) {
            return;
        }
        this.paintingInfo.updateRotationVec(vec);
        this.cache.rotationVec = vec;
        this.updateSignText();
    }

    public void updatePaintingPixelsPerBlock(float pixelsPerBlock) {
        if (this.paintingInfo == null) {
            return;
        }
        this.paintingInfo.updatePixelsPerBlock(pixelsPerBlock);
        this.cache.pixelsPerBlock = pixelsPerBlock;
        this.updateSignText();
    }

    public BackType.Type cyclePaintingBack() {
        this.cache.backType = BackType.cycle(this.cache.backType);
        this.paintingInfo.setBackType(this.cache.backType);
        this.updateSignText();
        return this.cache.backType;
    }

    public void resetSize() {
        this.paintingInfo.resetSize();
        this.cache.width = this.paintingInfo.getWidth();
        this.cache.height = this.paintingInfo.getHeight();
        this.updateSignText();
    }

    private void updateSignText() {
        this.updatingSignText = true;
        this.cache.updateSignText();
        this.updatingSignText = false;
    }

    public boolean updateText() {
        if (this.paintingInfo == null) {
            return false;
        }
        if (this.updatingSignText) {
            return true;
        }
        String[] parts = this.getParts();
        if (!this.cache.url.equals(parts[0])) {
            return false;
        }
        if (parts.length > 1) {
            this.updateCache(parts[1]);
        }
        return true;
    }

    private void updateCache(String afterUrl) {
        this.cache.parseAfterUrl(afterUrl);
        this.paintingInfo.updateCuboidCentering(this.cache.xCentering, this.cache.yCentering);
        this.paintingInfo.updateCuboidSize(this.cache.width, this.cache.height);
        this.paintingInfo.setBackType(this.cache.backType);
        this.paintingInfo.updateOffsetVec(this.cache.offsetVec);
        this.paintingInfo.updatePixelsPerBlock(this.cache.pixelsPerBlock);
        this.paintingInfo.updateRotationVec(this.cache.rotationVec);
    }

    public static Vector3f getRotVector(String s) {
        String[] parts = s.split(",");
        if (parts.length == 3) {
            return new Vector3f(Float.parseFloat(parts[0]), Float.parseFloat(parts[1]), Float.parseFloat(parts[2]));
        }
        return null;
    }

    private static class PaintingDataCache {
        private final String url;
        private Centering.Type xCentering = Centering.Type.CENTER;
        private Centering.Type yCentering = Centering.Type.CENTER;
        private float width;
        private float height;
        private BackType.Type backType = BackType.Type.SIGN;
        private Vector3f offsetVec;
        private Vector3f rotationVec;
        private float pixelsPerBlock;
        private String extraText;

        public PaintingDataCache(String url) {
            this.url = url;
        }

        public void init(PaintingInfo paintingInfo) {
            this.xCentering = Centering.Type.CENTER;
            this.yCentering = Centering.Type.CENTER;
            this.width = paintingInfo.getWidth();
            this.height = paintingInfo.getHeight();
            this.backType = BackType.Type.SIGN;
            this.offsetVec = new Vector3f(0.0f, 0.0f, 0.0f);
            this.rotationVec = new Vector3f(0.0f, 0.0f, 0.0f);
        }

        public void parseAfterUrl(String s) {
            int currentIndex = 0;
            String[] parts = s.split("[|\n ]");
            if (currentIndex < parts.length && this.tryParseCharFlags(parts[currentIndex])) {
                ++currentIndex;
            }
            if (currentIndex < parts.length && this.tryParseSize(parts[currentIndex])) {
                ++currentIndex;
            }
            if (currentIndex < parts.length && this.tryParseYOffset(parts[currentIndex])) {
                ++currentIndex;
            }
            if (currentIndex < parts.length && this.tryParsePixelsPerBlock(parts[currentIndex])) {
                ++currentIndex;
            }
            if (currentIndex < parts.length && this.tryParseXOffset(parts[currentIndex])) {
                ++currentIndex;
            }
            if (currentIndex < parts.length && this.tryParseZOffset(parts[currentIndex])) {
                ++currentIndex;
            }
            if (currentIndex < parts.length && this.tryParseRotationVec(parts[currentIndex])) {
                ++currentIndex;
            }
            StringBuilder builder = new StringBuilder();
            for (int i = currentIndex; i < parts.length; ++i) {
                if (!builder.isEmpty()) {
                    builder.append(" ");
                }
                builder.append(parts[i]);
            }
            this.extraText = builder.toString();
        }

        private boolean tryParseCharFlags(String s) {
            int length = s.length();
            if (length < 2 || length > 3) {
                return false;
            }
            this.xCentering = Centering.parseCentering(String.valueOf(s.charAt(0)));
            this.yCentering = Centering.parseCentering(String.valueOf(s.charAt(1)));
            if (length == 3) {
                this.backType = BackType.parseBackType(String.valueOf(s.charAt(2)));
            }
            return true;
        }

        private boolean tryParseSize(String s) {
            if (!s.contains("/") && !s.contains(":")) {
                return false;
            }
            String[] parts = s.split("[/:]");
            float[] values = new float[2];
            try {
                values[0] = class_3532.method_15363((float)Float.parseFloat(parts[0]), (float)0.03125f, (float)64.0f);
                values[1] = class_3532.method_15363((float)Float.parseFloat(parts[1]), (float)0.03125f, (float)64.0f);
            }
            catch (Exception ignored) {
                return false;
            }
            this.width = values[0];
            this.height = values[1];
            return true;
        }

        private boolean tryParseXOffset(String s) {
            try {
                this.offsetVec.x = class_3532.method_15363((float)Float.parseFloat(s), (float)-64.0f, (float)64.0f);
            }
            catch (Exception ignored) {
                return false;
            }
            return true;
        }

        private boolean tryParseYOffset(String s) {
            try {
                this.offsetVec.y = class_3532.method_15363((float)Float.parseFloat(s), (float)-64.0f, (float)64.0f);
            }
            catch (Exception ignored) {
                return false;
            }
            return true;
        }

        private boolean tryParseZOffset(String s) {
            try {
                this.offsetVec.z = class_3532.method_15363((float)Float.parseFloat(s), (float)-64.0f, (float)64.0f);
            }
            catch (Exception ignored) {
                return false;
            }
            return true;
        }

        private boolean tryParseRotationVec(String s) {
            try {
                Vector3f vec = SignSideInfo.getRotVector(s);
                if (vec == null) {
                    return false;
                }
                this.rotationVec = vec;
            }
            catch (Exception ignored) {
                return false;
            }
            return true;
        }

        private boolean tryParsePixelsPerBlock(String s) {
            try {
                this.pixelsPerBlock = class_3532.method_15363((float)Float.parseFloat(s), (float)0.0f, (float)1024.0f);
            }
            catch (Exception ignored) {
                return false;
            }
            return true;
        }

        public void updateSignText() {
            String urlString = SignedPaintingsClient.imageManager.getShortestURLInference(this.url);
            String widthString = this.getShortFloatString(this.width);
            String heightString = this.getShortFloatString(this.height);
            String xOffsetString = this.getShortFloatString(this.offsetVec.x);
            String yOffsetString = this.getShortFloatString(this.offsetVec.y);
            String zOffsetString = this.getShortFloatString(this.offsetVec.z);
            String rotString = this.getRotString(this.rotationVec);
            String pixelsPerBlockString = this.getShortFloatString(this.pixelsPerBlock);
            String text = urlString + "|" + Centering.getName(true, this.xCentering) + Centering.getName(false, this.yCentering) + BackType.getName(this.backType) + "|" + widthString + ":" + heightString + "|" + yOffsetString + "|" + pixelsPerBlockString + "|" + xOffsetString + "|" + zOffsetString + "|" + rotString;
            String actualText = SignByteMapper.INITIALIZER_STRING + SignByteMapper.encode(text) + SignByteMapper.DELIMITER + this.extraText;
            SignedPaintingsClient.currentSignEdit.screen.signedPaintings$clear(false);
            int newSelection = SignedPaintingsClient.currentSignEdit.screen.signedPaintings$paste(actualText, 0, 0, true);
            SignedPaintingsClient.currentSignEdit.selectionManager.method_27548(newSelection, newSelection);
        }

        private String getShortFloatString(float value) {
            String s = SignedPaintingsClient.floatToStringDP(value, 5);
            s = s.contains(".") ? s.replaceAll("\\.?0*$", "") : s;
            s = s.replaceAll("\\.66[67]+$", ".667");
            s = s.replaceAll("\\.333+$", ".333");
            return s;
        }

        private String getRotString(Vector3f rotationVec) {
            return this.getShortFloatString(rotationVec.x) + "," + this.getShortFloatString(rotationVec.y) + "," + this.getShortFloatString(rotationVec.z);
        }
    }
}

