/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.fabric;

import com.sigmundgranaas.forgero.core.ForgeroStateRegistry;
import com.sigmundgranaas.forgero.core.configuration.ForgeroConfiguration;
import com.sigmundgranaas.forgero.core.configuration.ForgeroConfigurationLoader;
import com.sigmundgranaas.forgero.core.resource.PipelineBuilder;
import com.sigmundgranaas.forgero.fabric.api.entrypoint.ForgeroInitializedEntryPoint;
import com.sigmundgranaas.forgero.fabric.api.entrypoint.ForgeroPreInitializationEntryPoint;
import com.sigmundgranaas.forgero.fabric.registry.RegistryHandler;
import com.sigmundgranaas.forgero.fabric.resources.FabricPackFinder;
import com.sigmundgranaas.forgero.minecraft.common.block.assemblystation.AssemblyStationBlock;
import com.sigmundgranaas.forgero.minecraft.common.block.upgradestation.UpgradeStationBlock;
import com.sigmundgranaas.forgero.minecraft.common.service.StateService;
import java.nio.file.Path;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.entrypoint.EntrypointContainer;
import net.fabricmc.loader.api.metadata.ModMetadata;
import net.minecraft.class_1935;
import net.minecraft.class_5321;
import net.minecraft.class_7706;

public class ForgeroInitializer
implements ModInitializer {
    public static final String MOD_NAMESPACE = "forgero";
    private static final List<ForgeroInitializedEntryPoint> INITIALIZED_ENTRY_POINTS = FabricLoader.getInstance().getEntrypointContainers("forgeroInitialized", ForgeroInitializedEntryPoint.class).stream().map(EntrypointContainer::getEntrypoint).toList();
    private static final List<ForgeroPreInitializationEntryPoint> PRE_INITIALIZED_ENTRY_POINTS = FabricLoader.getInstance().getEntrypointContainers("forgeroPreInitialization", ForgeroPreInitializationEntryPoint.class).stream().map(EntrypointContainer::getEntrypoint).toList();

    public void onInitialize() {
        this.handlePreInitializedEntryPoints();
        Set availableDependencies = FabricLoader.getInstance().getAllMods().stream().map(ModContainer::getMetadata).map(ModMetadata::getId).collect(Collectors.toSet());
        ForgeroConfiguration configuration = ForgeroConfigurationLoader.load((Path)FabricLoader.getInstance().getConfigDir());
        PipelineBuilder.builder().register(() -> configuration).register(FabricPackFinder.supplier()).state(ForgeroStateRegistry.stateListener()).state(ForgeroStateRegistry.compositeListener()).createStates(ForgeroStateRegistry.createStateListener()).inflated(ForgeroStateRegistry.constructListener()).inflated(ForgeroStateRegistry.containerListener()).recipes(ForgeroStateRegistry.recipeListener()).register(availableDependencies).build().execute();
        StateService service = RegistryHandler.getHandler().initialize();
        this.handleInitializedEntryPoints(service);
    }

    private void handleInitializedEntryPoints(StateService service) {
        INITIALIZED_ENTRY_POINTS.forEach(entryPoint -> entryPoint.onInitialized(service));
    }

    private void handlePreInitializedEntryPoints() {
        PRE_INITIALIZED_ENTRY_POINTS.forEach(ForgeroPreInitializationEntryPoint::onPreInitialization);
    }

    static {
        ItemGroupEvents.modifyEntriesEvent((class_5321)class_7706.field_40197).register(entries -> entries.method_45421((class_1935)AssemblyStationBlock.ASSEMBLY_STATION_ITEM));
        ItemGroupEvents.modifyEntriesEvent((class_5321)class_7706.field_40197).register(entries -> entries.method_45421((class_1935)UpgradeStationBlock.UPGRADE_STATION_ITEM));
    }
}

