/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.fabric.client;

import com.google.common.collect.ImmutableList;
import com.sigmundgranaas.forgero.core.ForgeroStateRegistry;
import com.sigmundgranaas.forgero.core.model.ModelRegistry;
import com.sigmundgranaas.forgero.core.model.ModelTemplate;
import com.sigmundgranaas.forgero.core.model.PaletteTemplateModel;
import com.sigmundgranaas.forgero.core.resource.PipelineBuilder;
import com.sigmundgranaas.forgero.core.state.State;
import com.sigmundgranaas.forgero.core.texture.V2.FileLoader;
import com.sigmundgranaas.forgero.core.texture.V2.TextureGenerator;
import com.sigmundgranaas.forgero.core.type.Type;
import com.sigmundgranaas.forgero.fabric.client.model.ForgeroStateModelResolver;
import com.sigmundgranaas.forgero.fabric.client.texture.Generator;
import com.sigmundgranaas.forgero.fabric.resources.FabricPackFinder;
import com.sigmundgranaas.forgero.fabric.resources.FileService;
import com.sigmundgranaas.forgero.minecraft.common.block.assemblystation.AssemblyStationScreen;
import com.sigmundgranaas.forgero.minecraft.common.block.assemblystation.AssemblyStationScreenHandler;
import com.sigmundgranaas.forgero.minecraft.common.block.upgradestation.UpgradeStationScreen;
import com.sigmundgranaas.forgero.minecraft.common.block.upgradestation.UpgradeStationScreenHandler;
import com.sigmundgranaas.forgero.minecraft.common.entity.Entities;
import com.sigmundgranaas.forgero.minecraft.common.handler.use.ThrowableItemRenderer;
import com.sigmundgranaas.forgero.minecraft.common.service.StateService;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.devtech.arrp.api.RRPCallback;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.model.loading.v1.ModelLoadingPlugin;
import net.fabricmc.fabric.api.client.rendering.v1.EntityRendererRegistry;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.SimpleSynchronousResourceReloadListener;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.ModMetadata;
import net.minecraft.class_1299;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_3300;
import net.minecraft.class_3917;
import net.minecraft.class_3929;

@Environment(value=EnvType.CLIENT)
public class ForgeroClient
implements ClientModInitializer {
    public static Map<String, ModelTemplate> TEXTURES = new HashMap<String, ModelTemplate>();
    public static Map<String, String> PALETTE_REMAP = new HashMap<String, String>();

    public void onInitializeClient() {
        this.initializeItemModels();
        class_3929.method_17542((class_3917)AssemblyStationScreenHandler.ASSEMBLY_STATION_SCREEN_HANDLER, AssemblyStationScreen::new);
        class_3929.method_17542((class_3917)UpgradeStationScreenHandler.UPGRADE_STATION_SCREEN_HANDLER, UpgradeStationScreen::new);
    }

    private void initializeItemModels() {
        ModelRegistry modelRegistry = new ModelRegistry();
        Set availableDependencies = FabricLoader.getInstance().getAllMods().stream().map(ModContainer::getMetadata).map(ModMetadata::getId).collect(Collectors.toSet());
        PipelineBuilder.builder().register(FabricPackFinder.supplier()).data(modelRegistry.paletteListener()).data(modelRegistry.modelListener()).register(availableDependencies).silent().build().execute();
        this.assetReloader();
        this.registerToolPartTextures(modelRegistry);
        StateService stateService = StateService.INSTANCE;
        Set<class_2960> models = ForgeroStateRegistry.COMPOSITES.parallelStream().map(arg_0 -> ((StateService)stateService).find(arg_0)).flatMap(Optional::stream).map(id -> new class_2960(id.nameSpace(), "item/" + id.name())).collect(Collectors.toSet());
        ForgeroStateModelResolver stateModels = new ForgeroStateModelResolver(modelRegistry, StateService.INSTANCE, models);
        ModelLoadingPlugin.register(pluginContext -> pluginContext.resolveModel().register((Object)stateModels));
        EntityRendererRegistry.register((class_1299)Entities.THROWN_ITEM_ENTITY, ThrowableItemRenderer::new);
    }

    private void registerToolPartTextures(ModelRegistry modelRegistry) {
        ImmutableList materials = ForgeroStateRegistry.TREE.find(Type.TOOL_MATERIAL).map(node -> node.getResources(State.class)).orElse(ImmutableList.builder().build());
        for (State material : materials) {
            TEXTURES.put(String.format("forgero:%s-repair_kit.png", material.name()), (ModelTemplate)new PaletteTemplateModel(material.name(), "repair_kit.png", 30, null, Integer.valueOf(16), null, null, Collections.emptyList()));
        }
        PALETTE_REMAP.putAll(modelRegistry.getPaletteRemapper());
        TEXTURES.putAll(modelRegistry.getTextures());
        Generator.generate();
        RRPCallback.BEFORE_VANILLA.register(a -> a.add(Generator.RESOURCE_PACK_CLIENT));
    }

    private void assetReloader() {
        ResourceManagerHelper.get((class_3264)class_3264.field_14188).registerReloadListener((IdentifiableResourceReloadListener)new SimpleSynchronousResourceReloadListener(){

            public void method_14491(class_3300 manager) {
                TextureGenerator.getInstance((FileLoader)new FileService(), PALETTE_REMAP).clear();
            }

            public class_2960 getFabricId() {
                return new class_2960("forgero", "dynamic_textures");
            }
        });
    }
}

