/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.fabric.initialization;

import com.google.common.collect.ImmutableList;
import com.sigmundgranaas.forgero.core.ForgeroStateRegistry;
import com.sigmundgranaas.forgero.core.configuration.ForgeroConfigurationLoader;
import com.sigmundgranaas.forgero.core.property.v2.attribute.attributes.AttackSpeed;
import com.sigmundgranaas.forgero.core.property.v2.attribute.attributes.AttributeModification;
import com.sigmundgranaas.forgero.core.property.v2.attribute.attributes.AttributeModificationRegistry;
import com.sigmundgranaas.forgero.core.property.v2.attribute.attributes.BrokenToolAttributeModification;
import com.sigmundgranaas.forgero.core.property.v2.attribute.attributes.Weight;
import com.sigmundgranaas.forgero.core.registry.RankableConverter;
import com.sigmundgranaas.forgero.core.state.Identifiable;
import com.sigmundgranaas.forgero.core.state.MaterialBased;
import com.sigmundgranaas.forgero.core.state.State;
import com.sigmundgranaas.forgero.core.type.Type;
import com.sigmundgranaas.forgero.fabric.api.entrypoint.ForgeroInitializedEntryPoint;
import com.sigmundgranaas.forgero.fabric.initialization.datareloader.DataPipeLineReloader;
import com.sigmundgranaas.forgero.fabric.initialization.datareloader.DisassemblyReloader;
import com.sigmundgranaas.forgero.fabric.initialization.datareloader.LootConditionReloadListener;
import com.sigmundgranaas.forgero.fabric.initialization.registrar.CommandRegistrar;
import com.sigmundgranaas.forgero.fabric.initialization.registrar.DynamicItemsRegistrar;
import com.sigmundgranaas.forgero.fabric.initialization.registrar.StateItemRegistrar;
import com.sigmundgranaas.forgero.fabric.initialization.registrar.TreasureLootRegistrar;
import com.sigmundgranaas.forgero.fabric.registry.RecipeRegistry;
import com.sigmundgranaas.forgero.fabric.resources.ARRPGenerator;
import com.sigmundgranaas.forgero.fabric.resources.dynamic.AllPartToAllSchematicsGenerator;
import com.sigmundgranaas.forgero.fabric.resources.dynamic.MaterialPartTagGenerator;
import com.sigmundgranaas.forgero.fabric.resources.dynamic.PartToSchematicGenerator;
import com.sigmundgranaas.forgero.fabric.resources.dynamic.PartTypeTagGenerator;
import com.sigmundgranaas.forgero.fabric.resources.dynamic.RepairKitResourceGenerator;
import com.sigmundgranaas.forgero.fabric.resources.dynamic.SchematicPartTagGenerator;
import com.sigmundgranaas.forgero.generator.api.GeneratorRegistry;
import com.sigmundgranaas.forgero.generator.api.operation.OperationFactory;
import com.sigmundgranaas.forgero.generator.impl.converter.forgero.ForgeroTypeVariableConverter;
import com.sigmundgranaas.forgero.minecraft.common.block.assemblystation.AssemblyStationBlock;
import com.sigmundgranaas.forgero.minecraft.common.block.assemblystation.AssemblyStationScreenHandler;
import com.sigmundgranaas.forgero.minecraft.common.block.upgradestation.UpgradeStationBlock;
import com.sigmundgranaas.forgero.minecraft.common.block.upgradestation.UpgradeStationScreenHandler;
import com.sigmundgranaas.forgero.minecraft.common.registry.registrar.AttributesRegistrar;
import com.sigmundgranaas.forgero.minecraft.common.registry.registrar.LootFunctionRegistrar;
import com.sigmundgranaas.forgero.minecraft.common.service.StateService;
import com.sigmundgranaas.forgero.minecraft.common.toolhandler.HungerHandler;
import com.sigmundgranaas.forgero.minecraft.common.tooltip.v2.TooltipAttributeRegistry;
import java.util.List;
import java.util.function.Function;
import net.fabricmc.fabric.api.event.player.AttackEntityCallback;
import net.fabricmc.fabric.api.event.player.PlayerBlockBreakEvents;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_7923;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ForgeroPostInit
implements ForgeroInitializedEntryPoint {
    public static final Logger LOGGER = LogManager.getLogger((String)"forgero");

    @Override
    public void onInitialized(StateService stateService) {
        this.registerBlocks();
        this.registerItems(stateService);
        this.registerTreasureLoot();
        this.registerCommands();
        this.registerLootFunctions();
        this.registerItemAttributes();
        this.registerDisassemblyReloadListener();
        this.registerDataReloadListener();
        this.registerLootConditionReloadListener();
        this.registerRecipeSerializers();
        this.registerAARPRecipes(stateService);
        this.registerHungerCallbacks(stateService);
        this.registerToolTipFilters();
        this.registerRecipeGenerators();
    }

    private void registerRecipeGenerators() {
        Function<State, String> idConverter = s -> StateService.INSTANCE.getMapper().stateToContainer(s.identifier()).toString();
        Function<State, String> tagOrItem = state -> class_7923.field_41178.method_10223(StateService.INSTANCE.getMapper().stateToContainer(state.identifier())) == class_1802.field_8162 ? "tag" : "item";
        Function<State, String> material = state -> {
            String string;
            if (state instanceof MaterialBased) {
                MaterialBased based = (MaterialBased)state;
                string = based.baseMaterial().name();
            } else {
                string = "";
            }
            return string;
        };
        OperationFactory factory = new OperationFactory(State.class);
        GeneratorRegistry.operation((String)"forgero:state_name", (String)"name", (RankableConverter)factory.build(Identifiable::name));
        GeneratorRegistry.operation((String)"forgero:state_namespace", (String)"namespace", (RankableConverter)factory.build(Identifiable::nameSpace));
        GeneratorRegistry.operation((String)"forgero:state_material", (String)"material", (RankableConverter)factory.build(material));
        GeneratorRegistry.operation((String)"forgero:state_identifier", (String)"identifier", (RankableConverter)factory.build(idConverter));
        GeneratorRegistry.operation((String)"forgero:state_identifier", (String)"id", (RankableConverter)factory.build(idConverter));
        GeneratorRegistry.operation((String)"forgero:tag_or_item", (String)"tagOrItem", (RankableConverter)factory.build(tagOrItem));
        Function<String, List> stateFinder = type -> (List)ForgeroStateRegistry.TREE.find(Type.of((String)type)).map(node -> node.getResources(State.class)).orElse(ImmutableList.builder().build());
        ForgeroTypeVariableConverter typeConverter = new ForgeroTypeVariableConverter(stateFinder);
        GeneratorRegistry.variableConverter((String)"forgero:type_converter", (RankableConverter)typeConverter);
    }

    private void registerToolTipFilters() {
        List<String> defaults = List.of("ATTACK_DAMAGE", "MINING_SPEED", "DURABILITY", "MINING_LEVEL", AttackSpeed.KEY, "ARMOR", "WEIGHT", "forgero:reach");
        defaults.stream().map(arg_0 -> ((TooltipAttributeRegistry.AttributeBuilder)TooltipAttributeRegistry.attributeBuilder()).attribute(arg_0)).forEach(TooltipAttributeRegistry.AttributeBuilder::register);
        TooltipAttributeRegistry.attributeBuilder().attribute("RARITY").condition(container -> ForgeroConfigurationLoader.configuration.hideRarity == false).register();
        List<String> swords = List.of("ATTACK_DAMAGE", AttackSpeed.KEY, "DURABILITY", "ARMOR", "WEIGHT", "forgero:reach");
        TooltipAttributeRegistry.filterBuilder().attributes(swords).type(Type.SWORD_BLADE).register();
        TooltipAttributeRegistry.filterBuilder().attributes(swords).type(Type.SWORD).register();
        TooltipAttributeRegistry.filterBuilder().attributes(defaults).type(Type.MATERIAL).register();
        this.registerAttributeModifications();
    }

    private void registerAttributeModifications() {
        AttributeModificationRegistry.modificationBuilder().attributeKey("ATTACK_DAMAGE").modification((AttributeModification)new BrokenToolAttributeModification(0.0f)).register();
        AttributeModificationRegistry.modificationBuilder().attributeKey("MINING_SPEED").modification((AttributeModification)new BrokenToolAttributeModification(1.0f)).register();
        AttributeModificationRegistry.modificationBuilder().attributeKey("MINING_LEVEL").modification((AttributeModification)new BrokenToolAttributeModification(0.0f)).register();
        AttributeModificationRegistry.modificationBuilder().attributeKey("ARMOR").modification((AttributeModification)new BrokenToolAttributeModification(0.0f)).register();
        AttributeModificationRegistry.modificationBuilder().attributeKey(AttackSpeed.KEY).modification(AttackSpeed.clampMinimumAttackSpeed()).register();
        if (ForgeroConfigurationLoader.configuration.weightReducesAttackSpeed.booleanValue()) {
            AttributeModificationRegistry.modificationBuilder().attributeKey(AttackSpeed.KEY).modification(Weight.reduceAttackSpeedByWeight()).register();
        }
    }

    private void registerHungerCallbacks(StateService stateService) {
        HungerHandler handler = new HungerHandler(stateService);
        PlayerBlockBreakEvents.AFTER.register((arg_0, arg_1, arg_2, arg_3, arg_4) -> ((HungerHandler)handler).handle(arg_0, arg_1, arg_2, arg_3, arg_4));
        AttackEntityCallback.EVENT.register((arg_0, arg_1, arg_2, arg_3, arg_4) -> ((HungerHandler)handler).handle(arg_0, arg_1, arg_2, arg_3, arg_4));
    }

    private void registerBlocks() {
        class_2378.method_10230((class_2378)class_7923.field_41175, (class_2960)AssemblyStationBlock.ASSEMBLY_STATION, (Object)AssemblyStationBlock.ASSEMBLY_STATION_BLOCK);
        class_2378.method_10230((class_2378)class_7923.field_41178, (class_2960)AssemblyStationBlock.ASSEMBLY_STATION, (Object)AssemblyStationBlock.ASSEMBLY_STATION_ITEM);
        class_2378.method_10230((class_2378)class_7923.field_41187, (class_2960)AssemblyStationBlock.ASSEMBLY_STATION, (Object)AssemblyStationScreenHandler.ASSEMBLY_STATION_SCREEN_HANDLER);
        class_2378.method_10230((class_2378)class_7923.field_41175, (class_2960)UpgradeStationBlock.UPGRADE_STATION, (Object)UpgradeStationBlock.UPGRADE_STATION_BLOCK);
        class_2378.method_10230((class_2378)class_7923.field_41178, (class_2960)UpgradeStationBlock.UPGRADE_STATION, (Object)UpgradeStationBlock.UPGRADE_STATION_ITEM);
        class_2378.method_10230((class_2378)class_7923.field_41187, (class_2960)UpgradeStationBlock.UPGRADE_STATION, (Object)UpgradeStationScreenHandler.UPGRADE_STATION_SCREEN_HANDLER);
    }

    private void registerItems(StateService stateService) {
        new StateItemRegistrar(stateService).registerItem((class_2378<class_1792>)class_7923.field_41178);
        new DynamicItemsRegistrar().register();
    }

    private void registerTreasureLoot() {
        TreasureLootRegistrar.getInstance().register();
    }

    private void registerCommands() {
        new CommandRegistrar().register();
    }

    private void registerLootFunctions() {
        new LootFunctionRegistrar().register();
    }

    private void registerItemAttributes() {
        new AttributesRegistrar().register();
    }

    private void registerDisassemblyReloadListener() {
        ResourceManagerHelper.get((class_3264)class_3264.field_14190).registerReloadListener((IdentifiableResourceReloadListener)new DisassemblyReloader());
    }

    private void registerDataReloadListener() {
        ResourceManagerHelper.get((class_3264)class_3264.field_14190).registerReloadListener((IdentifiableResourceReloadListener)new DataPipeLineReloader());
    }

    private void registerLootConditionReloadListener() {
        ResourceManagerHelper.get((class_3264)class_3264.field_14190).registerReloadListener((IdentifiableResourceReloadListener)new LootConditionReloadListener());
    }

    private void registerRecipeSerializers() {
        RecipeRegistry.INSTANCE.registerRecipeSerializers();
    }

    private void registerAARPRecipes(StateService service) {
        ARRPGenerator.register(new RepairKitResourceGenerator(ForgeroConfigurationLoader.configuration, service));
        if (ForgeroConfigurationLoader.configuration.enableRecipesForAllSchematics.booleanValue()) {
            ARRPGenerator.register(() -> new AllPartToAllSchematicsGenerator(service, new PartToSchematicGenerator.SchematicRecipeCreator(), new PartToSchematicGenerator.AllVariantFilter()));
        } else {
            ARRPGenerator.register(() -> new PartToSchematicGenerator(service, new PartToSchematicGenerator.SchematicRecipeCreator(), new PartToSchematicGenerator.BaseVariantFilter()));
        }
        ARRPGenerator.register(() -> new MaterialPartTagGenerator(service));
        ARRPGenerator.register(() -> new SchematicPartTagGenerator(service));
        ARRPGenerator.register(() -> new PartTypeTagGenerator(service));
        ARRPGenerator.generate(service);
    }
}

