/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.fabric.initialization;

import com.google.gson.Gson;
import com.google.gson.stream.JsonReader;
import com.mojang.serialization.Codec;
import com.sigmundgranaas.forgero.core.Forgero;
import com.sigmundgranaas.forgero.core.api.identity.DefaultRules;
import com.sigmundgranaas.forgero.core.api.identity.ModificationRuleRegistry;
import com.sigmundgranaas.forgero.core.api.identity.sorting.SortingRule;
import com.sigmundgranaas.forgero.core.api.identity.sorting.SortingRuleRegistry;
import com.sigmundgranaas.forgero.core.handler.HandlerBuilderRegistry;
import com.sigmundgranaas.forgero.core.model.match.PredicateFactory;
import com.sigmundgranaas.forgero.core.model.match.builders.PredicateBuilder;
import com.sigmundgranaas.forgero.core.model.match.builders.string.StringIdentifierBuilder;
import com.sigmundgranaas.forgero.core.model.match.builders.string.StringModelBuilder;
import com.sigmundgranaas.forgero.core.model.match.builders.string.StringNameBuilder;
import com.sigmundgranaas.forgero.core.model.match.builders.string.StringSlotBuilder;
import com.sigmundgranaas.forgero.core.model.match.builders.string.StringSlotCategoryBuilder;
import com.sigmundgranaas.forgero.core.model.match.builders.string.StringTypeBuilder;
import com.sigmundgranaas.forgero.core.property.v2.feature.ClassKey;
import com.sigmundgranaas.forgero.core.property.v2.feature.FeatureBuilder;
import com.sigmundgranaas.forgero.core.property.v2.feature.FeatureRegistry;
import com.sigmundgranaas.forgero.core.property.v2.feature.JsonBuilder;
import com.sigmundgranaas.forgero.core.registry.GenericRegistry;
import com.sigmundgranaas.forgero.core.registry.Registerable;
import com.sigmundgranaas.forgero.core.registry.RegistryFactory;
import com.sigmundgranaas.forgero.core.registry.SoulLevelPropertyRegistry;
import com.sigmundgranaas.forgero.core.resource.data.v2.data.SoulLevelPropertyData;
import com.sigmundgranaas.forgero.core.soul.PropertyLevelProvider;
import com.sigmundgranaas.forgero.core.soul.SoulLevelPropertyDataProcessor;
import com.sigmundgranaas.forgero.core.type.Type;
import com.sigmundgranaas.forgero.fabric.api.entrypoint.ForgeroPreInitializationEntryPoint;
import com.sigmundgranaas.forgero.fabric.item.ItemGroupRegisters;
import com.sigmundgranaas.forgero.fabric.item.ItemSettingRegistrars;
import com.sigmundgranaas.forgero.fabric.registry.DefaultLevelProperties;
import com.sigmundgranaas.forgero.minecraft.common.api.v0.predicate.Registries;
import com.sigmundgranaas.forgero.minecraft.common.entity.Entities;
import com.sigmundgranaas.forgero.minecraft.common.feature.BlockBreakFeature;
import com.sigmundgranaas.forgero.minecraft.common.feature.BlockEfficiencyFeature;
import com.sigmundgranaas.forgero.minecraft.common.feature.EntityTickFeature;
import com.sigmundgranaas.forgero.minecraft.common.feature.OnHitBlockFeature;
import com.sigmundgranaas.forgero.minecraft.common.feature.OnHitEntityFeature;
import com.sigmundgranaas.forgero.minecraft.common.feature.OnUseFeature;
import com.sigmundgranaas.forgero.minecraft.common.feature.SwingHandFeature;
import com.sigmundgranaas.forgero.minecraft.common.handler.afterUse.AfterUseHandler;
import com.sigmundgranaas.forgero.minecraft.common.handler.afterUse.ConsumeStackHandler;
import com.sigmundgranaas.forgero.minecraft.common.handler.afterUse.ConsumeUpgradeHandler;
import com.sigmundgranaas.forgero.minecraft.common.handler.afterUse.CoolDownHandler;
import com.sigmundgranaas.forgero.minecraft.common.handler.afterUse.DamageHandler;
import com.sigmundgranaas.forgero.minecraft.common.handler.blockbreak.filter.BlockFilter;
import com.sigmundgranaas.forgero.minecraft.common.handler.blockbreak.filter.CanMineFilter;
import com.sigmundgranaas.forgero.minecraft.common.handler.blockbreak.filter.FilterWrapper;
import com.sigmundgranaas.forgero.minecraft.common.handler.blockbreak.filter.IsBlockFilter;
import com.sigmundgranaas.forgero.minecraft.common.handler.blockbreak.filter.SameBlockFilter;
import com.sigmundgranaas.forgero.minecraft.common.handler.blockbreak.filter.SimilarBlockFilter;
import com.sigmundgranaas.forgero.minecraft.common.handler.blockbreak.hardness.All;
import com.sigmundgranaas.forgero.minecraft.common.handler.blockbreak.hardness.Average;
import com.sigmundgranaas.forgero.minecraft.common.handler.blockbreak.hardness.BlockBreakSpeedCalculator;
import com.sigmundgranaas.forgero.minecraft.common.handler.blockbreak.hardness.Instant;
import com.sigmundgranaas.forgero.minecraft.common.handler.blockbreak.hardness.Single;
import com.sigmundgranaas.forgero.minecraft.common.handler.blockbreak.selector.BlockSelector;
import com.sigmundgranaas.forgero.minecraft.common.handler.blockbreak.selector.ColumnSelector;
import com.sigmundgranaas.forgero.minecraft.common.handler.blockbreak.selector.PatternSelector;
import com.sigmundgranaas.forgero.minecraft.common.handler.blockbreak.selector.RadiusVeinSelector;
import com.sigmundgranaas.forgero.minecraft.common.handler.blockbreak.selector.SingleSelector;
import com.sigmundgranaas.forgero.minecraft.common.handler.entity.EntityBasedHandler;
import com.sigmundgranaas.forgero.minecraft.common.handler.entity.FrostHandler;
import com.sigmundgranaas.forgero.minecraft.common.handler.entity.FunctionExecuteHandler;
import com.sigmundgranaas.forgero.minecraft.common.handler.entity.MagneticHandler;
import com.sigmundgranaas.forgero.minecraft.common.handler.entity.ParticleHandler;
import com.sigmundgranaas.forgero.minecraft.common.handler.entity.SoundHandler;
import com.sigmundgranaas.forgero.minecraft.common.handler.entity.SummonHandler;
import com.sigmundgranaas.forgero.minecraft.common.handler.entity.TeleportHandler;
import com.sigmundgranaas.forgero.minecraft.common.handler.swing.EntityHandHandler;
import com.sigmundgranaas.forgero.minecraft.common.handler.targeted.ExplosionHandler;
import com.sigmundgranaas.forgero.minecraft.common.handler.targeted.onHitBlock.BlockTargetHandler;
import com.sigmundgranaas.forgero.minecraft.common.handler.targeted.onHitEntity.ConvertHandler;
import com.sigmundgranaas.forgero.minecraft.common.handler.targeted.onHitEntity.EntityTargetHandler;
import com.sigmundgranaas.forgero.minecraft.common.handler.targeted.onHitEntity.FireHandler;
import com.sigmundgranaas.forgero.minecraft.common.handler.targeted.onHitEntity.KnockbackHandler;
import com.sigmundgranaas.forgero.minecraft.common.handler.targeted.onHitEntity.LightningStrikeHandler;
import com.sigmundgranaas.forgero.minecraft.common.handler.targeted.onHitEntity.StatusEffectHandler;
import com.sigmundgranaas.forgero.minecraft.common.handler.use.BlockUseHandler;
import com.sigmundgranaas.forgero.minecraft.common.handler.use.Consume;
import com.sigmundgranaas.forgero.minecraft.common.handler.use.EntityUseHandler;
import com.sigmundgranaas.forgero.minecraft.common.handler.use.StopHandler;
import com.sigmundgranaas.forgero.minecraft.common.handler.use.ThrowTridentHandler;
import com.sigmundgranaas.forgero.minecraft.common.handler.use.ThrowableHandler;
import com.sigmundgranaas.forgero.minecraft.common.handler.use.UseHandler;
import com.sigmundgranaas.forgero.minecraft.common.item.BuildableStateConverter;
import com.sigmundgranaas.forgero.minecraft.common.item.GemItemRegistrar;
import com.sigmundgranaas.forgero.minecraft.common.item.ItemRegistries;
import com.sigmundgranaas.forgero.minecraft.common.item.RegistryUtils;
import com.sigmundgranaas.forgero.minecraft.common.item.tool.DynamicToolItemRegistrationHandler;
import com.sigmundgranaas.forgero.minecraft.common.item.tool.DynamicWeaponItemRegistrationHandler;
import com.sigmundgranaas.forgero.minecraft.common.match.predicate.DamagePercentagePredicate;
import com.sigmundgranaas.forgero.minecraft.common.match.predicate.MatchContextTypePredicate;
import com.sigmundgranaas.forgero.minecraft.common.match.predicate.RandomPredicate;
import com.sigmundgranaas.forgero.minecraft.common.predicate.KeyPair;
import com.sigmundgranaas.forgero.minecraft.common.predicate.block.Adapters;
import com.sigmundgranaas.forgero.minecraft.common.predicate.block.BlockPredicateMatcher;
import com.sigmundgranaas.forgero.minecraft.common.predicate.entity.EntityAdapter;
import com.sigmundgranaas.forgero.minecraft.common.predicate.entity.EntityFlagPredicates;
import com.sigmundgranaas.forgero.minecraft.common.predicate.entity.EntityPredicate;
import com.sigmundgranaas.forgero.minecraft.common.predicate.flag.FlagGroupPredicate;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.SimpleSynchronousResourceReloadListener;
import net.minecraft.class_1761;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_7706;

public class ForgeroPreInit
implements ForgeroPreInitializationEntryPoint {
    @Override
    public void onPreInitialization() {
        this.soulLevelPropertyReloader();
        DefaultLevelProperties.defaults().forEach(SoulLevelPropertyRegistry::register);
        Entities.register();
        this.registerPredicateBuilders();
        this.registerFeatureBuilder();
        this.registerHandlerBuilders();
        this.registerItemConverters();
        this.registerNameModifications();
    }

    private void registerNameModifications() {
        SortingRuleRegistry sorting = SortingRuleRegistry.staticRegistry();
        sorting.registerRule("forgero:schematic", SortingRule.of((Type)Type.SCHEMATIC, (int)20));
        sorting.registerRule("forgero:material", SortingRule.of((Type)Type.MATERIAL, (int)10));
        sorting.registerRule("forgero:part", SortingRule.of((Type)Type.PART, (int)30));
        ModificationRuleRegistry modification = ModificationRuleRegistry.staticRegistry();
        modification.registerRule("forgero:schematic", DefaultRules.schematic.build());
        modification.registerRule("forgero:handle", DefaultRules.handle.build());
        modification.registerRule("forgero:pickaxe", DefaultRules.pickaxe.build());
        modification.registerRule("forgero:sword", DefaultRules.sword.build());
        modification.registerRule("forgero:hoe", DefaultRules.hoe.build());
        modification.registerRule("forgero:axe", DefaultRules.axe.build());
        modification.registerRule("forgero:shovel", DefaultRules.shovel.build());
    }

    private void registerItemConverters() {
        GenericRegistry settingRegistry = ItemRegistries.SETTING_PROCESSOR;
        GenericRegistry groupRegistry = ItemRegistries.GROUP_CONVERTER;
        GenericRegistry converterRegistry = ItemRegistries.STATE_CONVERTER;
        groupRegistry.register("forgero:default", state -> (class_1761)class_7706.method_47341().get(0));
        RegistryFactory factory = new RegistryFactory(groupRegistry);
        RegistryUtils.register((GenericRegistry)settingRegistry, ItemSettingRegistrars::new);
        RegistryUtils.register((GenericRegistry)groupRegistry, ItemGroupRegisters::new);
        BuildableStateConverter baseConverter = BuildableStateConverter.builder().group(arg_0 -> ((RegistryFactory)factory).convert(arg_0)).settings(RegistryUtils.settingProcessor((GenericRegistry)settingRegistry)).item(RegistryUtils.defaultItem).priority(0).build();
        converterRegistry.register("forgero:default", (Object)baseConverter);
        RegistryUtils.register((GenericRegistry)converterRegistry, (Registerable)new DynamicWeaponItemRegistrationHandler(baseConverter));
        RegistryUtils.register((GenericRegistry)converterRegistry, (Registerable)new DynamicToolItemRegistrationHandler(baseConverter));
        RegistryUtils.register((GenericRegistry)converterRegistry, (Registerable)new GemItemRegistrar(baseConverter));
    }

    private void registerPredicateBuilders() {
        Registries.BLOCK_CODEC_REGISTRY.register(Adapters.BLOCKS_KEY, (Object)Adapters.blocksAdapter());
        Registries.BLOCK_CODEC_REGISTRY.register(Adapters.BLOCK_KEY, (Object)Adapters.blockAdapter());
        Registries.BLOCK_CODEC_REGISTRY.register(Adapters.TAGS_KEY, (Object)Adapters.blockTagsAdapter());
        Registries.BLOCK_CODEC_REGISTRY.register(Adapters.TAG_KEY, (Object)Adapters.blockTagAdapter());
        PredicateFactory.register((Codec)BlockPredicateMatcher.CODEC);
        Registries.ENTITY_FLAG_PREDICATE_REGISTRY.register(EntityFlagPredicates.IS_SNEAKING);
        Registries.ENTITY_FLAG_PREDICATE_REGISTRY.register(EntityFlagPredicates.IS_SPRINTING);
        Registries.ENTITY_FLAG_PREDICATE_REGISTRY.register(EntityFlagPredicates.IS_SWIMMING);
        Registries.ENTITY_FLAG_PREDICATE_REGISTRY.register(EntityFlagPredicates.IS_ON_GROUND);
        Registries.ENTITY_CODEC_REGISTRY.register(KeyPair.pair((String)"flag", (Object)FlagGroupPredicate.CODEC_SPECIFICATION));
        Registries.ENTITY_CODEC_REGISTRY.register(KeyPair.pair((String)"pos", (Object)EntityAdapter.entityPosCodec()));
        Registries.ENTITY_CODEC_REGISTRY.register(KeyPair.pair((String)EntityAdapter.ENTITY_TYPE_KEY, (Object)EntityAdapter.entityTypePredicate()));
        PredicateFactory.register((Codec)EntityPredicate.CODEC);
        PredicateFactory.register((PredicateBuilder)new StringModelBuilder());
        PredicateFactory.register((PredicateBuilder)new StringIdentifierBuilder());
        PredicateFactory.register((PredicateBuilder)new StringModelBuilder());
        PredicateFactory.register((PredicateBuilder)new StringSlotBuilder());
        PredicateFactory.register(StringTypeBuilder::new);
        PredicateFactory.register(StringNameBuilder::new);
        PredicateFactory.register(StringSlotCategoryBuilder::new);
        PredicateFactory.register(DamagePercentagePredicate.DamagePercentagePredicateBuilder::new);
        PredicateFactory.register(CanMineFilter.CanMineFilterBuilder::new);
        PredicateFactory.register(RandomPredicate.RandomPredicatePredicateBuilder::new);
        PredicateFactory.register(MatchContextTypePredicate.MatchContextTypePredicateBuilder::new);
    }

    private void registerFeatureBuilder() {
        FeatureRegistry.register((ClassKey)OnHitEntityFeature.KEY, (FeatureBuilder)OnHitEntityFeature.BUILDER);
        FeatureRegistry.register((ClassKey)OnHitBlockFeature.KEY, (FeatureBuilder)OnHitBlockFeature.BUILDER);
        FeatureRegistry.register((ClassKey)BlockBreakFeature.KEY, (FeatureBuilder)BlockBreakFeature.BUILDER);
        FeatureRegistry.register((ClassKey)EntityTickFeature.KEY, (FeatureBuilder)EntityTickFeature.BUILDER);
        FeatureRegistry.register((ClassKey)BlockEfficiencyFeature.KEY, (FeatureBuilder)BlockEfficiencyFeature.BUILDER);
        FeatureRegistry.register((ClassKey)OnUseFeature.KEY, (FeatureBuilder)OnUseFeature.BUILDER);
        FeatureRegistry.register((ClassKey)SwingHandFeature.KEY, (FeatureBuilder)SwingHandFeature.BUILDER);
    }

    private void registerHandlerBuilders() {
        this.registerEntityBasedHandler("minecraft:function", (JsonBuilder<? extends EntityBasedHandler>)FunctionExecuteHandler.BUILDER);
        this.registerEntityBasedHandler("minecraft:play_sound", (JsonBuilder<? extends EntityBasedHandler>)SoundHandler.BUILDER);
        this.registerEntityBasedHandler("minecraft:particle", (JsonBuilder<? extends EntityBasedHandler>)ParticleHandler.BUILDER);
        this.registerEntityBasedHandler("minecraft:frost", (JsonBuilder<? extends EntityBasedHandler>)FrostHandler.BUILDER);
        this.registerEntityBasedHandler("minecraft:teleport", (JsonBuilder<? extends EntityBasedHandler>)TeleportHandler.BUILDER);
        HandlerBuilderRegistry.register((ClassKey)EntityTargetHandler.KEY, (String)"minecraft:status_effect", (Codec)StatusEffectHandler.BUILDER);
        HandlerBuilderRegistry.register((ClassKey)EntityTargetHandler.KEY, (String)"minecraft:explosion", (JsonBuilder)ExplosionHandler.BUILDER);
        HandlerBuilderRegistry.register((ClassKey)EntityTargetHandler.KEY, (String)"minecraft:lightning_strike", (JsonBuilder)LightningStrikeHandler.BUILDER);
        HandlerBuilderRegistry.register((ClassKey)EntityTargetHandler.KEY, (String)"minecraft:fire", (JsonBuilder)FireHandler.BUILDER);
        HandlerBuilderRegistry.register((ClassKey)EntityTargetHandler.KEY, (String)"minecraft:convert", (JsonBuilder)ConvertHandler.BUILDER);
        HandlerBuilderRegistry.register((ClassKey)EntityTargetHandler.KEY, (String)"minecraft:knockback", (JsonBuilder)KnockbackHandler.BUILDER);
        HandlerBuilderRegistry.register((ClassKey)EntityTargetHandler.KEY, (String)"minecraft:summon", (JsonBuilder)SummonHandler.BUILDER);
        HandlerBuilderRegistry.register((ClassKey)EntityTargetHandler.KEY, (String)"forgero:magnetic", (JsonBuilder)MagneticHandler.BUILDER);
        HandlerBuilderRegistry.register((ClassKey)BlockTargetHandler.KEY, (String)"minecraft:summon", (JsonBuilder)SummonHandler.BUILDER);
        HandlerBuilderRegistry.register((ClassKey)BlockTargetHandler.KEY, (String)"minecraft:explosion", (JsonBuilder)ExplosionHandler.BUILDER);
        HandlerBuilderRegistry.register((ClassKey)BlockTargetHandler.KEY, (String)"forgero:magnetic", (JsonBuilder)MagneticHandler.BUILDER);
        HandlerBuilderRegistry.register((ClassKey)BlockTargetHandler.KEY, (String)"minecraft:fire", (JsonBuilder)FireHandler.BUILDER);
        HandlerBuilderRegistry.register((ClassKey)AfterUseHandler.KEY, (String)"minecraft:consume_stack", (JsonBuilder)ConsumeStackHandler.BUILDER);
        HandlerBuilderRegistry.register((ClassKey)AfterUseHandler.KEY, (String)"forgero:consume_upgrade", (JsonBuilder)ConsumeUpgradeHandler.BUILDER);
        HandlerBuilderRegistry.register((ClassKey)AfterUseHandler.KEY, (String)"minecraft:stack_damage", (JsonBuilder)DamageHandler.BUILDER);
        HandlerBuilderRegistry.register((ClassKey)AfterUseHandler.KEY, (String)"minecraft:cooldown", (JsonBuilder)CoolDownHandler.BUILDER);
        HandlerBuilderRegistry.register((ClassKey)EntityBasedHandler.KEY, (String)"forgero:magnetic", (JsonBuilder)MagneticHandler.BUILDER);
        HandlerBuilderRegistry.register((ClassKey)EntityBasedHandler.KEY, (String)"minecraft:summon", (JsonBuilder)SummonHandler.BUILDER);
        HandlerBuilderRegistry.register((ClassKey)BlockSelector.KEY, (String)"forgero:column", (JsonBuilder)ColumnSelector.BUILDER);
        HandlerBuilderRegistry.register((ClassKey)BlockSelector.KEY, (String)"forgero:pattern", (JsonBuilder)PatternSelector.BUILDER);
        HandlerBuilderRegistry.register((ClassKey)BlockSelector.KEY, (String)"forgero:radius", (JsonBuilder)RadiusVeinSelector.BUILDER);
        HandlerBuilderRegistry.register((ClassKey)BlockSelector.KEY, (String)"forgero:single", (JsonBuilder)SingleSelector.BUILDER);
        HandlerBuilderRegistry.register((ClassKey)BlockBreakSpeedCalculator.KEY, (String)"forgero:all", (JsonBuilder)All.BUILDER);
        HandlerBuilderRegistry.register((ClassKey)BlockBreakSpeedCalculator.KEY, (String)"forgero:average", (JsonBuilder)Average.BUILDER);
        HandlerBuilderRegistry.register((ClassKey)BlockBreakSpeedCalculator.KEY, (String)"forgero:instant", (JsonBuilder)Instant.BUILDER);
        HandlerBuilderRegistry.register((ClassKey)BlockBreakSpeedCalculator.KEY, (String)"forgero:single", (JsonBuilder)Single.BUILDER);
        HandlerBuilderRegistry.builder((String)"minecraft:consume", (JsonBuilder)Consume.BUILDER).register(BlockUseHandler.KEY).register(EntityUseHandler.KEY).register(UseHandler.KEY);
        HandlerBuilderRegistry.register((ClassKey)StopHandler.KEY, (String)"forgero:throw_trident", (JsonBuilder)ThrowTridentHandler.BUILDER);
        HandlerBuilderRegistry.register((ClassKey)StopHandler.KEY, (String)"forgero:throw", (JsonBuilder)ThrowableHandler.BUILDER);
        HandlerBuilderRegistry.register((ClassKey)StopHandler.KEY, (String)"minecraft:consume_stack", (JsonBuilder)ConsumeStackHandler.BUILDER);
        HandlerBuilderRegistry.register((ClassKey)StopHandler.KEY, (String)"forgero:consume_upgrade", (JsonBuilder)ConsumeUpgradeHandler.BUILDER);
        HandlerBuilderRegistry.register((ClassKey)StopHandler.KEY, (String)"minecraft:stack_damage", (JsonBuilder)DamageHandler.BUILDER);
        HandlerBuilderRegistry.register((ClassKey)StopHandler.KEY, (String)"minecraft:cooldown", (JsonBuilder)CoolDownHandler.BUILDER);
        HandlerBuilderRegistry.register((ClassKey)BlockFilter.KEY, (String)FilterWrapper.TYPE, (JsonBuilder)FilterWrapper.BUILDER);
        HandlerBuilderRegistry.register((ClassKey)BlockFilter.KEY, (String)"forgero:can_mine", (JsonBuilder)CanMineFilter.BUILDER);
        HandlerBuilderRegistry.register((ClassKey)BlockFilter.KEY, (String)"forgero:is_block", (JsonBuilder)IsBlockFilter.BUILDER);
        HandlerBuilderRegistry.register((ClassKey)BlockFilter.KEY, (String)"forgero:same_block", (JsonBuilder)SameBlockFilter.BUILDER);
        HandlerBuilderRegistry.register((ClassKey)BlockFilter.KEY, (String)"forgero:similar_block", (JsonBuilder)SimilarBlockFilter.BUILDER);
        HandlerBuilderRegistry.register((ClassKey)BlockFilter.KEY, (String)"minecraft:block", (Codec)BlockPredicateMatcher.CODEC);
    }

    private void registerEntityBasedHandler(String key, JsonBuilder<? extends EntityBasedHandler> builder) {
        HandlerBuilderRegistry.builder((String)key, builder).register(EntityTargetHandler.KEY).register(BlockTargetHandler.KEY).register(EntityBasedHandler.KEY).register(EntityHandHandler.KEY).register(BlockUseHandler.KEY).register(EntityUseHandler.KEY).register(UseHandler.KEY).register(StopHandler.KEY);
    }

    private void soulLevelPropertyReloader() {
        ResourceManagerHelper.get((class_3264)class_3264.field_14190).registerReloadListener((IdentifiableResourceReloadListener)new SimpleSynchronousResourceReloadListener(){

            public void method_14491(class_3300 manager) {
                SoulLevelPropertyRegistry.refresh();
                Gson gson = new Gson();
                for (class_3298 res : manager.method_14488("leveled_soul_properties", path -> path.method_12832().endsWith(".json")).values()) {
                    try {
                        InputStream stream = res.method_14482();
                        try {
                            SoulLevelPropertyData data = (SoulLevelPropertyData)gson.fromJson(new JsonReader((Reader)new InputStreamReader(stream)), SoulLevelPropertyData.class);
                            SoulLevelPropertyRegistry.register((String)data.getId(), (PropertyLevelProvider)new SoulLevelPropertyDataProcessor(data));
                        }
                        finally {
                            if (stream == null) continue;
                            stream.close();
                        }
                    }
                    catch (Exception e) {
                        Forgero.LOGGER.error((Object)e);
                    }
                }
            }

            public class_2960 getFabricId() {
                return new class_2960("forgero", "soul_level_property");
            }
        });
    }
}

