/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.fabric.initialization.datareloader;

import com.google.common.reflect.TypeToken;
import com.google.gson.GsonBuilder;
import com.google.gson.stream.JsonReader;
import com.sigmundgranaas.forgero.core.Forgero;
import com.sigmundgranaas.forgero.core.context.Context;
import com.sigmundgranaas.forgero.core.resource.data.PropertyPojo;
import com.sigmundgranaas.forgero.core.resource.data.deserializer.AttributeGroupDeserializer;
import com.sigmundgranaas.forgero.core.resource.data.deserializer.ContextDeserializer;
import com.sigmundgranaas.forgero.core.resource.data.v2.data.DependencyData;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_3298;
import net.minecraft.class_3300;

public class ResourceManagerJsonLoader<T> {
    private final class_3300 resourceManager;
    private final Class<T> clazz;
    private final String path;

    public ResourceManagerJsonLoader(class_3300 resourceManager, Class<T> clazz, String path) {
        this.resourceManager = resourceManager;
        this.clazz = clazz;
        this.path = path;
    }

    private Collection<class_3298> loadJsonData(String path) {
        return this.resourceManager.method_14488(path, p -> p.method_12832().endsWith(".json")).values();
    }

    private Stream<T> streamElements() {
        return this.loadJsonData(this.path).stream().map(this::tryParse).flatMap(Optional::stream);
    }

    public List<T> load() {
        return this.streamElements().collect(Collectors.toList());
    }

    private Optional<T> tryParse(class_3298 resource) {
        Optional<Object> optional;
        block8: {
            InputStream stream = resource.method_14482();
            try {
                GsonBuilder builder = new GsonBuilder();
                builder.registerTypeAdapter(DependencyData.class, (Object)new DependencyData.DependencyDataDeserializer());
                builder.registerTypeAdapter(new TypeToken<List<PropertyPojo.Attribute>>(){}.getType(), (Object)new AttributeGroupDeserializer());
                builder.registerTypeAdapter(new TypeToken<Context>(){}.getType(), (Object)new ContextDeserializer());
                Object element = builder.create().fromJson(new JsonReader((Reader)new InputStreamReader(stream)), this.clazz);
                optional = Optional.of(element);
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    Forgero.LOGGER.error((Object)e);
                    return Optional.empty();
                }
            }
            stream.close();
        }
        return optional;
    }
}

