/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.fabric.initialization.registrar;

import com.sigmundgranaas.forgero.core.Forgero;
import com.sigmundgranaas.forgero.core.ForgeroStateRegistry;
import com.sigmundgranaas.forgero.core.identifier.Common;
import com.sigmundgranaas.forgero.core.registry.RegistryFactory;
import com.sigmundgranaas.forgero.core.state.State;
import com.sigmundgranaas.forgero.core.state.StateProvider;
import com.sigmundgranaas.forgero.core.type.Type;
import com.sigmundgranaas.forgero.core.util.match.Matchable;
import com.sigmundgranaas.forgero.minecraft.common.item.ItemData;
import com.sigmundgranaas.forgero.minecraft.common.item.ItemRegistries;
import com.sigmundgranaas.forgero.minecraft.common.registry.registrar.Registrar;
import com.sigmundgranaas.forgero.minecraft.common.service.StateService;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.minecraft.class_151;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_7923;

public class StateItemRegistrar
implements Registrar {
    private final StateService service;

    public StateItemRegistrar(StateService service) {
        this.service = service;
    }

    private Map<String, Integer> generateSortingMap() {
        HashMap<String, Integer> sortingMap = new HashMap<String, Integer>();
        this.service.all().stream().map(Supplier::get).filter(state -> !state.test((Matchable)Type.WEAPON) && !state.test((Matchable)Type.TOOL)).forEach(state -> sortingMap.compute(StateAttributes.getMaterialName(state), (key, value) -> value == null || StateAttributes.getRarity(state) > value ? StateAttributes.getRarity(state) : value));
        return sortingMap;
    }

    private Stream<StateProvider> getValidStates(class_2378<class_1792> registry) {
        return ForgeroStateRegistry.CREATE_STATES.stream().filter(state -> !registry.method_10250(new class_2960(this.service.getMapper().stateToContainer(((State)state.get()).identifier()).toString()))).filter(state -> !registry.method_10250(new class_2960(((State)state.get()).identifier())));
    }

    private void registerState(StateProvider state) {
        try {
            RegistryFactory factory = new RegistryFactory(ItemRegistries.STATE_CONVERTER);
            ItemData data = (ItemData)factory.convert((Object)state);
            class_2960 identifier = data.id();
            class_1792 item = data.item();
            this.registerGroup(data);
            class_2378.method_10230((class_2378)class_7923.field_41178, (class_2960)identifier, (Object)item);
        }
        catch (class_151 e) {
            Forgero.LOGGER.error("Invalid identifier: {}", (Object)((State)state.get()).identifier());
            Forgero.LOGGER.error((Object)e);
        }
    }

    private void registerGroup(ItemData data) {
        class_7923.field_44687.method_29113((Object)data.group()).ifPresent(group -> ItemGroupEvents.modifyEntriesEvent((class_5321)group).register(entries -> entries.method_45420(new class_1799((class_1935)data.item()))));
    }

    public void registerItem(class_2378<class_1792> registry) {
        Map<String, Integer> sortingMap = this.generateSortingMap();
        this.getValidStates(registry).sorted(new StateComparator(sortingMap)).forEach(this::registerState);
    }

    static class StateComparator
    implements Comparator<Supplier<State>> {
        private final Map<String, Integer> orderingMap;

        public StateComparator(Map<String, Integer> orderingMap) {
            this.orderingMap = orderingMap;
        }

        private int getOrderingFromState(State state) {
            String name = StateAttributes.getMaterialName(state);
            int rarity = StateAttributes.getRarity(state);
            return this.orderingMap.getOrDefault(name, rarity);
        }

        @Override
        public int compare(Supplier<State> state1, Supplier<State> state2) {
            State element1 = state1.get();
            State element2 = state2.get();
            int elementOrdering = this.getOrderingFromState(element1) - this.getOrderingFromState(element2);
            int nameOrdering = StateAttributes.getMaterialName(element1).compareTo(StateAttributes.getMaterialName(element2));
            if (elementOrdering != 0) {
                return elementOrdering;
            }
            if (nameOrdering != 0) {
                return nameOrdering;
            }
            return StateAttributes.getRarity(element1) - StateAttributes.getRarity(element2);
        }
    }

    static class StateAttributes {
        StateAttributes() {
        }

        static String getMaterialName(State state) {
            String[] elements = state.name().split(Common.ELEMENT_SEPARATOR);
            if (elements.length > 1) {
                if (elements[1].equals("schematic") || elements[1].equals("gem")) {
                    return elements[1];
                }
                return elements[0];
            }
            return state.name();
        }

        static int getRarity(State state) {
            return (int)state.stream().applyAttribute("RARITY");
        }
    }
}

