/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.fabric.initialization.registrar;

import com.sigmundgranaas.forgero.fabric.loot.ExtendedLootTable;
import com.sigmundgranaas.forgero.minecraft.common.loot.LootEntry;
import com.sigmundgranaas.forgero.minecraft.common.loot.SingleLootEntry;
import com.sigmundgranaas.forgero.minecraft.common.loot.StateFilter;
import com.sigmundgranaas.forgero.minecraft.common.registry.registrar.Registrar;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.fabric.api.loot.v2.LootTableEvents;
import net.minecraft.class_1299;
import net.minecraft.class_2960;
import net.minecraft.class_39;

public class TreasureLootRegistrar
implements Registrar {
    private static TreasureLootRegistrar INSTANCE;
    private final Map<String, LootEntry> entryMap = new HashMap<String, LootEntry>();
    private final List<LootEntry> entries = new ArrayList<LootEntry>();

    public static TreasureLootRegistrar getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new TreasureLootRegistrar();
        }
        return INSTANCE;
    }

    private void registerEntries() {
        this.entries.clear();
        this.stronghold();
        this.ancientCity();
        this.pyramid();
        this.junglePyramid();
        this.toolSmithAndPillagerOutPost();
        this.weaponsSmith();
        this.ruinedPortal();
        this.shipwreck();
        this.endCity();
        this.netherFortress();
        this.bastionRemnants();
        this.spawner();
        this.witch();
        this.zombie();
        this.pillager();
        this.smallForgingHouse();
    }

    private void registerEntry(LootEntry entry) {
        this.entries.add(entry);
    }

    public void registerEntry(String id, LootEntry entry) {
        this.entryMap.put(id, entry);
    }

    public void register() {
        this.registerEntries();
        if (ExtendedLootTable.isValid()) {
            ExtendedLootTable.register();
        }
        LootTableEvents.MODIFY.register((resourceManager, lootManager, id, table, setter) -> this.entries.stream().filter(entry -> entry.matches(id)).forEach(entry -> entry.apply(table)));
    }

    public void registerDynamicLoot() {
        LootTableEvents.MODIFY.register((resourceManager, lootManager, id, table, setter) -> this.entryMap.values().stream().filter(entry -> entry.matches(id)).forEach(entry -> entry.apply(table)));
    }

    private void stronghold() {
        StateFilter.StateFilterBuilder partFilter = StateFilter.builder().lowerRarity(30).upperRarity(90).types(List.of("PART"));
        SingleLootEntry partEntry = SingleLootEntry.builder().filter(() -> ((StateFilter)partFilter.build()).filter()).target(List.of(class_39.field_800, class_39.field_800)).chance(0.3f).rolls(2).build();
        StateFilter.StateFilterBuilder schematicFilter = StateFilter.builder().lowerRarity(30).upperRarity(90).types(List.of("SCHEMATIC"));
        SingleLootEntry schematicEntry = SingleLootEntry.builder().filter(() -> ((StateFilter)schematicFilter.build()).filter()).target(List.of(class_39.field_800, class_39.field_800)).chance(0.3f).rolls(1).build();
        this.registerEntry((LootEntry)partEntry);
        this.registerEntry((LootEntry)schematicEntry);
    }

    private void ancientCity() {
        StateFilter.StateFilterBuilder partFilter = StateFilter.builder().lowerRarity(60).upperRarity(120).types(List.of("PART"));
        SingleLootEntry partEntry = SingleLootEntry.builder().filter(() -> ((StateFilter)partFilter.build()).filter()).target(List.of(class_39.field_38438, class_39.field_38439)).chance(0.3f).rolls(2).build();
        StateFilter.StateFilterBuilder gemFilter = StateFilter.builder().lowerRarity(30).upperRarity(60).types(List.of("GEM"));
        SingleLootEntry gemEntry = SingleLootEntry.builder().filter(() -> ((StateFilter)gemFilter.build()).filter()).target(List.of(class_39.field_38438, class_39.field_38439)).chance(0.3f).rolls(2).build();
        StateFilter.StateFilterBuilder schematicFilter = StateFilter.builder().lowerRarity(60).upperRarity(120).types(List.of("SCHEMATIC"));
        SingleLootEntry schematicEntry = SingleLootEntry.builder().filter(() -> ((StateFilter)schematicFilter.build()).filter()).target(List.of(class_39.field_38438, class_39.field_38439)).chance(0.3f).rolls(1).build();
        this.registerEntry((LootEntry)gemEntry);
        this.registerEntry((LootEntry)partEntry);
        this.registerEntry((LootEntry)schematicEntry);
    }

    private void pyramid() {
        StateFilter.StateFilterBuilder partFilter = StateFilter.builder().lowerRarity(10).upperRarity(50).types(List.of("SHOVEL_HEAD", "TOOL_BINDING", "HANDLE"));
        SingleLootEntry partEntry = SingleLootEntry.builder().filter(() -> ((StateFilter)partFilter.build()).filter()).target(List.of(class_39.field_885)).chance(0.3f).rolls(2).build();
        StateFilter.StateFilterBuilder schematicFilter = StateFilter.builder().lowerRarity(10).upperRarity(40).types(List.of("SHOVEL_HEAD_SCHEMATIC", "HANDLE_SCHEMATIC"));
        SingleLootEntry schematicEntry = SingleLootEntry.builder().filter(() -> ((StateFilter)schematicFilter.build()).filter()).target(List.of(class_39.field_885)).chance(0.3f).rolls(1).build();
        this.registerEntry((LootEntry)partEntry);
        this.registerEntry((LootEntry)schematicEntry);
    }

    private void junglePyramid() {
        StateFilter.StateFilterBuilder partFilter = StateFilter.builder().lowerRarity(10).upperRarity(50).types(List.of("AXE_HEAD", "TOOL_BINDING", "HANDLE"));
        SingleLootEntry partEntry = SingleLootEntry.builder().filter(() -> ((StateFilter)partFilter.build()).filter()).target(List.of(class_39.field_803)).chance(0.3f).rolls(2).build();
        StateFilter.StateFilterBuilder schematicFilter = StateFilter.builder().lowerRarity(10).upperRarity(40).types(List.of("AXE_HEAD_SCHEMATIC", "HANDLE_SCHEMATIC"));
        SingleLootEntry schematicEntry = SingleLootEntry.builder().filter(() -> ((StateFilter)schematicFilter.build()).filter()).target(List.of(class_39.field_803)).chance(0.3f).rolls(1).build();
        this.registerEntry((LootEntry)partEntry);
        this.registerEntry((LootEntry)schematicEntry);
    }

    private void toolSmithAndPillagerOutPost() {
        StateFilter.StateFilterBuilder partFilter = StateFilter.builder().lowerRarity(10).upperRarity(50).types(List.of("AXE_HEAD", "PICKAXE_HEAD", "HOE_HEAD", "SHOVEL_HEAD", "HANDLE", "TOOL_BINDING"));
        SingleLootEntry partEntry = SingleLootEntry.builder().filter(() -> ((StateFilter)partFilter.build()).filter()).target(List.of(class_39.field_17107, class_39.field_16593)).chance(0.3f).rolls(2).build();
        StateFilter.StateFilterBuilder schematicFilter = StateFilter.builder().lowerRarity(10).upperRarity(40).types(List.of("AXE_HEAD_SCHEMATIC", "PICKAXE_HEAD_SCHEMATIC", "HOE_HEAD_SCHEMATIC", "SHOVEL_HEAD_SCHEMATIC", "HANDLE_SCHEMATIC", "TOOL_BINDING_SCHEMATIC"));
        SingleLootEntry schematicEntry = SingleLootEntry.builder().filter(() -> ((StateFilter)schematicFilter.build()).filter()).target(List.of(class_39.field_17107, class_39.field_16593)).chance(0.3f).rolls(1).build();
        this.registerEntry((LootEntry)partEntry);
        this.registerEntry((LootEntry)schematicEntry);
    }

    private void weaponsSmith() {
        StateFilter.StateFilterBuilder partFilter = StateFilter.builder().lowerRarity(10).upperRarity(50).types(List.of("AXE_HEAD", "SWORD_BLADE", "SWORD_GUARD", "HANDLE"));
        SingleLootEntry partEntry = SingleLootEntry.builder().filter(() -> ((StateFilter)partFilter.build()).filter()).target(List.of(class_39.field_434)).chance(0.3f).rolls(2).build();
        StateFilter.StateFilterBuilder schematicFilter = StateFilter.builder().lowerRarity(5).upperRarity(40).types(List.of("AXE_HEAD_SCHEMATIC", "SWORD_BLADE_SCHEMATIC", "SWORD_GUARD_SCHEMATIC"));
        SingleLootEntry schematicEntry = SingleLootEntry.builder().filter(() -> ((StateFilter)schematicFilter.build()).filter()).target(List.of(class_39.field_434)).chance(0.3f).rolls(1).build();
        this.registerEntry((LootEntry)partEntry);
        this.registerEntry((LootEntry)schematicEntry);
    }

    private void ruinedPortal() {
        StateFilter.StateFilterBuilder partFilter = StateFilter.builder().lowerRarity(10).upperRarity(90).include(List.of("gold")).types(List.of("PART"));
        SingleLootEntry partEntry = SingleLootEntry.builder().filter(() -> ((StateFilter)partFilter.build()).filter()).target(List.of(class_39.field_24050)).chance(0.3f).rolls(2).build();
        this.registerEntry((LootEntry)partEntry);
    }

    private void shipwreck() {
        StateFilter.StateFilterBuilder partFilter = StateFilter.builder().lowerRarity(10).upperRarity(80).types(List.of("PART"));
        SingleLootEntry partEntry = SingleLootEntry.builder().filter(() -> ((StateFilter)partFilter.build()).filter()).target(List.of(class_39.field_665, class_39.field_251)).chance(0.3f).rolls(2).build();
        StateFilter.StateFilterBuilder gemFilter = StateFilter.builder().lowerRarity(30).upperRarity(60).types(List.of("GEM"));
        SingleLootEntry gemEntry = SingleLootEntry.builder().filter(() -> ((StateFilter)gemFilter.build()).filter()).target(List.of(class_39.field_665)).chance(0.3f).rolls(2).build();
        this.registerEntry((LootEntry)gemEntry);
        StateFilter.StateFilterBuilder schematicFilter = StateFilter.builder().lowerRarity(10).upperRarity(50).types(List.of("SCHEMATIC"));
        SingleLootEntry schematicEntry = SingleLootEntry.builder().filter(() -> ((StateFilter)schematicFilter.build()).filter()).target(List.of(class_39.field_665, class_39.field_251)).chance(0.3f).rolls(1).build();
        this.registerEntry((LootEntry)partEntry);
        this.registerEntry((LootEntry)schematicEntry);
    }

    private void netherFortress() {
        StateFilter.StateFilterBuilder partFilter = StateFilter.builder().lowerRarity(40).upperRarity(70).types(List.of("PART"));
        SingleLootEntry partEntry = SingleLootEntry.builder().filter(() -> ((StateFilter)partFilter.build()).filter()).target(List.of(class_39.field_615)).chance(0.3f).rolls(2).build();
        StateFilter.StateFilterBuilder schematicFilter = StateFilter.builder().lowerRarity(20).upperRarity(50).types(List.of("SCHEMATIC"));
        SingleLootEntry schematicEntry = SingleLootEntry.builder().filter(() -> ((StateFilter)schematicFilter.build()).filter()).target(List.of(class_39.field_615)).chance(0.3f).rolls(1).build();
        StateFilter.StateFilterBuilder gemFilter = StateFilter.builder().lowerRarity(30).upperRarity(60).include(List.of("blazing")).types(List.of("GEM"));
        SingleLootEntry gemEntry = SingleLootEntry.builder().filter(() -> ((StateFilter)gemFilter.build()).filter()).target(List.of(class_39.field_615)).chance(0.1f).rolls(2).build();
        this.registerEntry((LootEntry)gemEntry);
        this.registerEntry((LootEntry)partEntry);
        this.registerEntry((LootEntry)schematicEntry);
    }

    private void bastionRemnants() {
        StateFilter.StateFilterBuilder goldFilter = StateFilter.builder().lowerRarity(30).upperRarity(100).include(List.of("gold")).types(List.of("PART"));
        SingleLootEntry goldPartEntry = SingleLootEntry.builder().filter(() -> ((StateFilter)goldFilter.build()).filter()).target(List.of(class_39.field_24046)).chance(0.3f).rolls(2).build();
        StateFilter.StateFilterBuilder gemFilter = StateFilter.builder().lowerRarity(30).upperRarity(60).include(List.of("blazed", "quartz")).types(List.of("GEM"));
        SingleLootEntry gemEntry = SingleLootEntry.builder().filter(() -> ((StateFilter)gemFilter.build()).filter()).target(List.of(class_39.field_24046)).chance(0.1f).rolls(2).build();
        this.registerEntry((LootEntry)gemEntry);
        StateFilter.StateFilterBuilder partFilter = StateFilter.builder().lowerRarity(50).upperRarity(90).types(List.of("PART"));
        SingleLootEntry partEntry = SingleLootEntry.builder().filter(() -> ((StateFilter)partFilter.build()).filter()).target(List.of(class_39.field_24046)).chance(0.3f).rolls(2).build();
        StateFilter.StateFilterBuilder schematicFilter = StateFilter.builder().lowerRarity(20).upperRarity(70).types(List.of("SCHEMATIC"));
        SingleLootEntry schematicEntry = SingleLootEntry.builder().filter(() -> ((StateFilter)schematicFilter.build()).filter()).target(List.of(class_39.field_24046)).chance(0.3f).rolls(1).build();
        this.registerEntry((LootEntry)goldPartEntry);
        this.registerEntry((LootEntry)partEntry);
        this.registerEntry((LootEntry)schematicEntry);
    }

    private void endCity() {
        StateFilter.StateFilterBuilder partFilter = StateFilter.builder().lowerRarity(50).upperRarity(130).types(List.of("PART"));
        SingleLootEntry partEntry = SingleLootEntry.builder().filter(() -> ((StateFilter)partFilter.build()).filter()).target(List.of(class_39.field_274)).chance(0.5f).rolls(2).build();
        StateFilter.StateFilterBuilder schematicFilter = StateFilter.builder().lowerRarity(30).upperRarity(70).types(List.of("SCHEMATIC"));
        SingleLootEntry schematicEntry = SingleLootEntry.builder().filter(() -> ((StateFilter)schematicFilter.build()).filter()).target(List.of(class_39.field_274)).chance(0.5f).rolls(1).build();
        StateFilter.StateFilterBuilder gemFilter = StateFilter.builder().lowerRarity(30).upperRarity(60).types(List.of("GEM"));
        SingleLootEntry gemEntry = SingleLootEntry.builder().filter(() -> ((StateFilter)gemFilter.build()).filter()).target(List.of(class_39.field_274)).chance(0.5f).rolls(2).build();
        this.registerEntry((LootEntry)gemEntry);
        this.registerEntry((LootEntry)partEntry);
        this.registerEntry((LootEntry)schematicEntry);
    }

    private void spawner() {
        StateFilter.StateFilterBuilder partFilter = StateFilter.builder().lowerRarity(20).upperRarity(50).types(List.of("PART"));
        SingleLootEntry partEntry = SingleLootEntry.builder().filter(() -> ((StateFilter)partFilter.build()).filter()).target(List.of(class_39.field_356)).chance(0.3f).rolls(2).build();
        StateFilter.StateFilterBuilder schematicFilter = StateFilter.builder().lowerRarity(1).upperRarity(40).types(List.of("SCHEMATIC"));
        SingleLootEntry schematicEntry = SingleLootEntry.builder().filter(() -> ((StateFilter)schematicFilter.build()).filter()).target(List.of(class_39.field_356)).chance(0.3f).rolls(1).build();
        this.registerEntry((LootEntry)partEntry);
        this.registerEntry((LootEntry)schematicEntry);
    }

    private void zombie() {
        StateFilter.StateFilterBuilder partFilter = StateFilter.builder().lowerRarity(30).upperRarity(40).types(List.of("PART"));
        SingleLootEntry partEntry = SingleLootEntry.builder().filter(() -> ((StateFilter)partFilter.build()).filter()).target(List.of(class_1299.field_6051.method_16351())).chance(0.01f).rolls(1).build();
        StateFilter.StateFilterBuilder schematicFilter = StateFilter.builder().lowerRarity(5).upperRarity(40).types(List.of("SCHEMATIC"));
        SingleLootEntry schematicEntry = SingleLootEntry.builder().filter(() -> ((StateFilter)schematicFilter.build()).filter()).target(List.of(class_1299.field_6051.method_16351())).chance(0.01f).rolls(1).build();
        this.registerEntry((LootEntry)partEntry);
        this.registerEntry((LootEntry)schematicEntry);
    }

    private void pillager() {
        StateFilter.StateFilterBuilder partFilter = StateFilter.builder().lowerRarity(40).upperRarity(50).types(List.of("PART"));
        SingleLootEntry partEntry = SingleLootEntry.builder().filter(() -> ((StateFilter)partFilter.build()).filter()).target(List.of(class_1299.field_6105.method_16351())).chance(0.1f).rolls(1).build();
        StateFilter.StateFilterBuilder schematicFilter = StateFilter.builder().lowerRarity(1).upperRarity(40).types(List.of("SCHEMATIC"));
        SingleLootEntry schematicEntry = SingleLootEntry.builder().filter(() -> ((StateFilter)schematicFilter.build()).filter()).target(List.of(class_1299.field_6105.method_16351())).chance(0.05f).rolls(1).build();
        this.registerEntry((LootEntry)partEntry);
        this.registerEntry((LootEntry)schematicEntry);
    }

    private void witch() {
        StateFilter.StateFilterBuilder gemFilter = StateFilter.builder().lowerRarity(30).upperRarity(60).types(List.of("GEM"));
        SingleLootEntry gemEntry = SingleLootEntry.builder().filter(() -> ((StateFilter)gemFilter.build()).filter()).target(List.of(class_1299.field_6145.method_16351())).chance(0.01f).rolls(2).build();
        this.registerEntry((LootEntry)gemEntry);
    }

    private void smallForgingHouse() {
        class_2960 id = new class_2960("forgero:chests/treasure_loot");
        StateFilter.StateFilterBuilder partFilter = StateFilter.builder().lowerRarity(10).upperRarity(80).types(List.of("PART"));
        SingleLootEntry partEntry = SingleLootEntry.builder().filter(() -> ((StateFilter)partFilter.build()).filter()).target(List.of(id)).chance(0.3f).rolls(2).build();
        StateFilter.StateFilterBuilder gemFilter = StateFilter.builder().lowerRarity(30).upperRarity(60).types(List.of("GEM"));
        SingleLootEntry gemEntry = SingleLootEntry.builder().filter(() -> ((StateFilter)gemFilter.build()).filter()).target(List.of(id)).chance(0.3f).rolls(2).build();
        this.registerEntry((LootEntry)gemEntry);
        StateFilter.StateFilterBuilder schematicFilter = StateFilter.builder().lowerRarity(10).upperRarity(50).types(List.of("SCHEMATIC"));
        SingleLootEntry schematicEntry = SingleLootEntry.builder().filter(() -> ((StateFilter)schematicFilter.build()).filter()).target(List.of(id)).chance(0.3f).rolls(1).build();
        this.registerEntry((LootEntry)partEntry);
        this.registerEntry((LootEntry)schematicEntry);
    }
}

