/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.fabric.mixins;

import com.google.common.collect.Multimap;
import com.sigmundgranaas.forgero.core.Forgero;
import com.sigmundgranaas.forgero.minecraft.common.item.DynamicAttributeItem;
import com.sigmundgranaas.forgero.minecraft.common.toolhandler.DynamicDurability;
import com.sigmundgranaas.forgero.minecraft.common.toolhandler.DynamicMiningSpeed;
import com.sigmundgranaas.forgero.minecraft.common.toolhandler.MultiMapMergeHandler;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1799.class})
public abstract class DynamicToolItemStackMixin {
    @Unique
    @Nullable
    private class_1309 contextEntity = null;

    @Shadow
    public abstract class_1792 method_7909();

    @Shadow
    public abstract int method_7919();

    @Shadow
    public abstract int method_7936();

    @Inject(at={@At(value="RETURN")}, method={"isSuitableFor"}, cancellable=true)
    public void isEffectiveOn(class_2680 state, CallbackInfoReturnable<Boolean> info) {
        class_1792 class_17922 = this.method_7909();
        if (class_17922 instanceof DynamicAttributeItem) {
            DynamicAttributeItem holder = (DynamicAttributeItem)class_17922;
            info.setReturnValue((Object)holder.isEffectiveOn(state, (class_1799)this));
        }
    }

    @Inject(at={@At(value="RETURN")}, method={"getMiningSpeedMultiplier"}, cancellable=true)
    public void getMiningSpeedMultiplier(class_2680 state, CallbackInfoReturnable<Float> info) {
        class_1792 class_17922 = this.method_7909();
        if (class_17922 instanceof DynamicMiningSpeed) {
            DynamicMiningSpeed holder = (DynamicMiningSpeed)class_17922;
            float customSpeed = holder.getMiningSpeedMultiplier(state, (class_1799)this);
            info.setReturnValue((Object)Float.valueOf(customSpeed));
        }
    }

    @Inject(at={@At(value="INVOKE", target="Lnet/minecraft/item/ItemStack;getAttributeModifiers(Lnet/minecraft/entity/EquipmentSlot;)Lcom/google/common/collect/Multimap;")}, method={"getTooltip"})
    @Environment(value=EnvType.CLIENT)
    private void storeTooltipAttributeEntityContext(class_1657 player, class_1836 context, CallbackInfoReturnable<List<class_2561>> cir) {
        this.contextEntity = player;
    }

    @Inject(at={@At(value="INVOKE", target="Lnet/minecraft/item/ItemStack;getAttributeModifiers(Lnet/minecraft/entity/EquipmentSlot;)Lcom/google/common/collect/Multimap;", shift=At.Shift.AFTER)}, method={"getTooltip"})
    @Environment(value=EnvType.CLIENT)
    private void revokeTooltipAttributeEntityContext(class_1657 player, class_1836 context, CallbackInfoReturnable<List<class_2561>> cir) {
        this.contextEntity = null;
    }

    @ModifyVariable(method={"getAttributeModifiers"}, at=@At(value="RETURN", shift=At.Shift.BEFORE))
    public Multimap<class_1320, class_1322> modifyAttributeModifiersMap(Multimap<class_1320, class_1322> multimap, class_1304 slot) {
        class_1799 stack = (class_1799)this;
        return new MultiMapMergeHandler().modifyAttributeModifiersMap(multimap, slot, stack, this.contextEntity);
    }

    @Inject(method={"getMaxDamage"}, at={@At(value="HEAD")}, cancellable=true)
    public void getCustomDurability(CallbackInfoReturnable<Integer> cir) {
        class_1792 class_17922 = this.method_7909();
        if (class_17922 instanceof DynamicDurability) {
            DynamicDurability tool = (DynamicDurability)class_17922;
            class_1799 stack = (class_1799)this;
            int durability = tool.getDurability(stack);
            if (durability < 0) {
                Forgero.LOGGER.error("Somehow tried to set the durability of tool {} to a negative value: {}. This should never happen, please report this issue to the Forgero developers on GitHub.", (Object)stack, (Object)durability);
                return;
            }
            cir.setReturnValue((Object)durability);
        }
    }

    @Inject(method={"getItemBarStep"}, at={@At(value="HEAD")}, cancellable=true)
    public void getItemBarStep(CallbackInfoReturnable<Integer> cir) {
        if (this.method_7909() instanceof DynamicDurability) {
            int durability = this.method_7936();
            if (durability < 0) {
                class_1799 stack = (class_1799)this;
                Forgero.LOGGER.error("Somehow tried to set the durability of tool {} to a negative value: {}. This should never happen, please report this issue to the Forgero developers on GitHub.", (Object)stack, (Object)durability);
                return;
            }
            cir.setReturnValue((Object)(durability == 0 ? 0 : Math.round(13.0f - (float)this.method_7919() * 13.0f / (float)durability)));
        }
    }
}

