/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.fabric.mixins;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.sigmundgranaas.forgero.core.configuration.ForgeroConfigurationLoader;
import com.sigmundgranaas.forgero.core.identifier.Common;
import com.sigmundgranaas.forgero.fabric.registry.RecipeRegistry;
import com.sigmundgranaas.forgero.fabric.resources.RecipeDeletionReloader;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1863;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_1863.class})
public class RecipeManagerMixin {
    @Unique
    private static final List<String> vanillaMaterials = List.of("wooden", "stone", "iron", "golden", "diamond", "netherite");
    @Unique
    private static final List<String> vanillaTools = List.of("pickaxe", "shovel", "axe", "sword", "hoe");

    @Inject(method={"apply(Ljava/util/Map;Lnet/minecraft/resource/ResourceManager;Lnet/minecraft/util/profiler/Profiler;)V"}, at={@At(value="HEAD")})
    public void interceptApply(Map<class_2960, JsonElement> map, class_3300 resourceManager, class_3695 profiler, CallbackInfo info) {
        RecipeRegistry.INSTANCE.registerRecipes(map);
        if (ForgeroConfigurationLoader.configuration.convertVanillaRecipesToForgeroTools.booleanValue()) {
            this.convertAllVanillaToolRecipes(map);
        }
        if (ForgeroConfigurationLoader.configuration.disableVanillaRecipes.booleanValue() || ForgeroConfigurationLoader.configuration.disableVanillaTools.booleanValue()) {
            this.removeAllVanillaToolRecipes(map);
        }
        if (ForgeroConfigurationLoader.configuration.enableCustomRecipeDeletion.booleanValue()) {
            this.deleteRecipes(map, resourceManager);
        }
    }

    @Unique
    private void deleteRecipes(Map<class_2960, JsonElement> map, class_3300 resourceManager) {
        RecipeDeletionReloader.reload(resourceManager);
        RecipeDeletionReloader.entries.forEach(map::remove);
    }

    @Unique
    private void removeAllVanillaToolRecipes(Map<class_2960, JsonElement> map) {
        vanillaMaterials.stream().map(material -> vanillaTools.stream().map(tool -> new class_2960(String.format("%s_%s", material, tool))).toList()).flatMap(Collection::stream).forEach(map::remove);
    }

    @Unique
    private void convertAllVanillaToolRecipes(Map<class_2960, JsonElement> map) {
        vanillaMaterials.stream().map(material -> vanillaTools.stream().map(tool -> new class_2960(String.format("%s_%s", material, tool))).toList()).flatMap(Collection::stream).map(id -> Optional.ofNullable((JsonElement)map.get(id))).flatMap(Optional::stream).forEach(this::convertMinecraftToForgeroNameSpace);
    }

    @Unique
    private void convertMinecraftToForgeroNameSpace(JsonElement recipe) {
        JsonObject object;
        if (recipe instanceof JsonObject && (object = (JsonObject)recipe).has("result") && object.get("result").getAsJsonObject().has("item")) {
            String newItem = this.resultItemRenamer(object.getAsJsonObject("result").get("item").getAsString());
            object.getAsJsonObject("result").addProperty("item", newItem);
        }
    }

    @Unique
    private String resultItemRenamer(String item) {
        String result = item;
        if (result.contains("minecraft")) {
            result = result.replace("minecraft", "forgero");
        }
        if (result.contains("golden")) {
            result = result.replace("golden", "gold");
        }
        if (result.contains("wooden")) {
            result = result.replace("wooden", "oak");
        }
        if (result.contains("_")) {
            result = result.replace("_", Common.ELEMENT_SEPARATOR);
        }
        return result;
    }
}

