/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.fabric.registry;

import com.sigmundgranaas.forgero.core.Forgero;
import com.sigmundgranaas.forgero.core.configuration.ForgeroConfigurationLoader;
import com.sigmundgranaas.forgero.core.registry.StateCollection;
import com.sigmundgranaas.forgero.core.state.State;
import com.sigmundgranaas.forgero.core.state.StateProvider;
import com.sigmundgranaas.forgero.fabric.registry.UncachedStateService;
import com.sigmundgranaas.forgero.minecraft.common.conversion.CachedStackConverter;
import com.sigmundgranaas.forgero.minecraft.common.conversion.ItemToStateConverter;
import com.sigmundgranaas.forgero.minecraft.common.conversion.StateToStackConverter;
import com.sigmundgranaas.forgero.minecraft.common.item.nbt.v2.NbtConstants;
import com.sigmundgranaas.forgero.minecraft.common.service.StateMapper;
import com.sigmundgranaas.forgero.minecraft.common.service.StateService;
import com.sigmundgranaas.forgero.minecraft.common.utils.ItemUtils;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7923;

public class ForgeroInstanceRegistry
implements StateService {
    private final List<class_2960> tags;
    private final StateCollection collection;
    private final class_2378<class_1792> itemRegistry;
    private final Map<String, String> itemToStateMap;
    private final Map<String, String> tagToStateMap;
    private final StateMapper mapper;

    public ForgeroInstanceRegistry(List<class_2960> tags, StateCollection collection, class_2378<class_1792> itemRegistry, Map<String, String> itemToStateMap, Map<String, String> tagToStateMap, StateMapper mapper) {
        this.tags = tags;
        this.collection = collection;
        this.itemRegistry = itemRegistry;
        this.itemToStateMap = itemToStateMap;
        this.tagToStateMap = tagToStateMap;
        this.mapper = mapper;
    }

    public Optional<State> find(String id) {
        return this.collection.find(id).map(Supplier::get).or(() -> this.findMappedId(id)).or(() -> this.findInTags(id));
    }

    private Optional<State> findMappedId(String id) {
        return Optional.ofNullable(this.itemToStateMap.get(id)).flatMap(arg_0 -> ((StateCollection)this.collection).find(arg_0)).map(Supplier::get);
    }

    private Optional<State> findInTags(String id) {
        try {
            return this.mapper.containerToState(id).flatMap(arg_0 -> ((StateCollection)this.collection).find(arg_0)).map(Supplier::get);
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    private Optional<State> findInTags(class_2960 id) {
        return this.tags.stream().map(tag -> class_6862.method_40092((class_5321)class_7923.field_41178.method_30517(), (class_2960)tag)).filter(tag -> this.hasItem((class_6862<class_1792>)tag, id)).map(tag -> Optional.ofNullable(this.tagToStateMap.get(tag.toString()))).flatMap(Optional::stream).findFirst().flatMap(tag -> this.find(id));
    }

    private boolean hasItem(class_6862<class_1792> tag, class_2960 id) {
        for (class_6880 entry : this.itemRegistry.method_40286(tag)) {
            if (!entry.method_40226(id)) continue;
            return true;
        }
        return false;
    }

    public Optional<State> find(class_1792 item) {
        return new ItemToStateConverter(this.itemRegistry, (StateService)this).convert(item);
    }

    public Collection<StateProvider> all() {
        return this.collection.all();
    }

    public Optional<State> find(class_2960 id) {
        return this.find(id.toString());
    }

    public Optional<State> convert(class_1799 stack) {
        return new CachedStackConverter((StateService)this).convert(stack);
    }

    public Optional<class_1799> convert(State state) {
        if (state == null) {
            return Optional.empty();
        }
        Function<String, Optional> mapFn = id -> Optional.of(this.mapper.stateToContainer(id));
        class_1799 stack = new StateToStackConverter(ItemUtils::itemFinder, mapFn).convert(state);
        if ((stack == null || stack.method_7960()) && ForgeroConfigurationLoader.configuration.debugLogging.booleanValue()) {
            Forgero.LOGGER.warn("The converted stack is empty, which means you tried to convert invalid data: {}", (Object)state.toString());
        }
        return Optional.ofNullable(stack);
    }

    public class_1799 update(State updated, class_1799 stack) {
        class_1799 copy = stack.method_7972();
        Optional<State> stackConverted = this.convert(stack);
        Optional<class_1799> updatedStack = this.convert(updated);
        if (updatedStack.isPresent() && stackConverted.isPresent() && updatedStack.get().method_7985() && stackConverted.get().identifier().equals(updated.identifier())) {
            class_2487 forgeroCompound = updatedStack.get().method_7948().method_10562(NbtConstants.FORGERO_IDENTIFIER);
            copy.method_7948().method_10566(NbtConstants.FORGERO_IDENTIFIER, (class_2520)forgeroCompound);
        }
        return copy;
    }

    public boolean isInitialized() {
        return true;
    }

    public StateMapper getMapper() {
        return this.mapper;
    }

    public StateService uncached() {
        return new UncachedStateService(this);
    }
}

