/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.fabric.registry;

import com.sigmundgranaas.forgero.core.Forgero;
import com.sigmundgranaas.forgero.core.ForgeroStateRegistry;
import com.sigmundgranaas.forgero.core.registry.StateCollection;
import com.sigmundgranaas.forgero.fabric.registry.ForgeroInstanceRegistry;
import com.sigmundgranaas.forgero.minecraft.common.service.StateMapper;
import com.sigmundgranaas.forgero.minecraft.common.service.StateService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.class_1792;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_7923;

public class RegistryHandler {
    private static final RegistryHandler HANDLER = new RegistryHandler();
    private final List<Runnable> entries = new ArrayList<Runnable>();
    private final List<Consumer<StateService>> syncedEntries = new ArrayList<Consumer<StateService>>();

    public static RegistryHandler getHandler() {
        return HANDLER;
    }

    public void runJobs() {
        this.run();
    }

    public StateService initialize() {
        StateCollection collection = ForgeroStateRegistry.STATES;
        Map itemToStateMap = ForgeroStateRegistry.CONTAINER_TO_STATE;
        Map stateToItemMap = ForgeroStateRegistry.STATE_TO_CONTAINER;
        Map tagToStateMap = ForgeroStateRegistry.TAG_TO_STATE;
        Map stateToTag = ForgeroStateRegistry.STATE_TO_TAG;
        if (collection == null || ForgeroStateRegistry.CONTAINER_TO_STATE == null) {
            Forgero.LOGGER.error("Forgero is not initialized yet. Please wait for the mod to finish loading.");
            throw new IllegalStateException("Forgero is not initialized yet. Please wait for the mod to finish loading.");
        }
        List<class_2960> convertedTags = ForgeroStateRegistry.TAG_TO_STATE.keySet().stream().map(class_2960::new).toList();
        StateMapper mapper = new StateMapper(itemToStateMap, stateToItemMap, stateToTag, tagToStateMap);
        ForgeroInstanceRegistry service = new ForgeroInstanceRegistry(convertedTags, collection, (class_2378<class_1792>)class_7923.field_41178, itemToStateMap, tagToStateMap, mapper);
        StateService.initialize((StateService)service);
        this.runSynced(service);
        return service;
    }

    public void acceptJob(Runnable handler) {
        this.entries.add(handler);
    }

    public void acceptSyncedJob(Consumer<StateService> handler) {
        this.syncedEntries.add(handler);
    }

    private void run() {
        this.entries.forEach(Runnable::run);
    }

    private void runSynced(StateService service) {
        this.syncedEntries.forEach(callable -> callable.accept(service));
    }
}

