/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.fabric.registry;

import com.sigmundgranaas.forgero.core.state.Composite;
import com.sigmundgranaas.forgero.core.state.State;
import com.sigmundgranaas.forgero.core.state.StateProvider;
import com.sigmundgranaas.forgero.minecraft.common.item.nbt.v2.CompoundParser;
import com.sigmundgranaas.forgero.minecraft.common.item.nbt.v2.NbtConstants;
import com.sigmundgranaas.forgero.minecraft.common.service.StateMapper;
import com.sigmundgranaas.forgero.minecraft.common.service.StateService;
import java.util.Collection;
import java.util.Optional;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2960;

public class UncachedStateService
implements StateService {
    private final StateService stateService;

    public UncachedStateService(StateService fallBack) {
        this.stateService = fallBack;
    }

    public Optional<State> find(class_1792 item) {
        return this.copy(this.stateService.find(item));
    }

    public Collection<StateProvider> all() {
        return this.stateService.all();
    }

    public Optional<State> find(class_2960 id) {
        return this.copy(this.stateService.find(id));
    }

    public Optional<State> convert(class_1799 stack) {
        if (stack.method_7985() && stack.method_7969().method_10545(NbtConstants.FORGERO_IDENTIFIER)) {
            return CompoundParser.STATE_PARSER.parse(stack.method_7948().method_10562(NbtConstants.FORGERO_IDENTIFIER));
        }
        return this.stateService.convert(stack.method_7972());
    }

    public Optional<class_1799> convert(State state) {
        return this.stateService.convert(state);
    }

    public class_1799 update(State state, class_1799 stack) {
        return this.stateService.update(state, stack);
    }

    private State copy(State state) {
        if (state instanceof Composite) {
            Composite composite = (Composite)state;
            return (State)composite.copy();
        }
        return state;
    }

    private Optional<State> copy(Optional<State> state) {
        return state.map(this::copy);
    }

    public boolean isInitialized() {
        return true;
    }

    public StateMapper getMapper() {
        return this.stateService.getMapper();
    }

    public StateService uncached() {
        return this;
    }

    public Optional<State> find(String id) {
        return this.copy(this.stateService.find(id));
    }
}

