/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.fabric.resources;

import com.google.common.collect.ImmutableList;
import com.sigmundgranaas.forgero.core.ForgeroStateRegistry;
import com.sigmundgranaas.forgero.core.identifier.Common;
import com.sigmundgranaas.forgero.core.state.Identifiable;
import com.sigmundgranaas.forgero.core.state.State;
import com.sigmundgranaas.forgero.core.type.MutableTypeNode;
import com.sigmundgranaas.forgero.core.type.Type;
import com.sigmundgranaas.forgero.fabric.resources.dynamic.DynamicResourceGenerator;
import com.sigmundgranaas.forgero.minecraft.common.service.StateMapper;
import com.sigmundgranaas.forgero.minecraft.common.service.StateService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.devtech.arrp.api.RRPCallback;
import net.devtech.arrp.api.RuntimeResourcePack;
import net.devtech.arrp.json.tags.JTag;
import net.minecraft.class_2960;

public class ARRPGenerator {
    private static final Object $LOCK = new Object[0];
    public static final RuntimeResourcePack RESOURCE_PACK_BUILTIN = RuntimeResourcePack.create((String)"forgero:builtin_generator");
    public static final RuntimeResourcePack RESOURCE_PACK = RuntimeResourcePack.create((String)"forgero:dynamic_generator");
    private static final List<DynamicResourceGenerator> generators = new ArrayList<DynamicResourceGenerator>();
    private final StateMapper mapper;

    public ARRPGenerator(StateMapper mapper) {
        this.mapper = mapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void register(DynamicResourceGenerator generator) {
        Object object = $LOCK;
        synchronized (object) {
            generators.add(generator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void register(Supplier<DynamicResourceGenerator> supplier) {
        Object object = $LOCK;
        synchronized (object) {
            generators.add(supplier.get());
        }
    }

    public static void generate(StateService service) {
        new ARRPGenerator(service.getMapper()).generateResources();
        generators.stream().filter(DynamicResourceGenerator::enabled).forEach(generator -> generator.generate(RESOURCE_PACK));
        RRPCallback.BEFORE_VANILLA.register(a -> a.add(RESOURCE_PACK));
    }

    public void generateResources() {
        this.generateTagsFromStateTree();
        this.createMaterialToolTags();
        RRPCallback.BEFORE_VANILLA.register(a -> a.add(RESOURCE_PACK_BUILTIN));
    }

    public void generateTagsFromStateTree() {
        ForgeroStateRegistry.TREE.nodes().forEach(this::createTagFromType);
    }

    private void createTagFromType(MutableTypeNode node) {
        JTag typeTag = new JTag();
        ImmutableList states = node.getResources(State.class);
        if (states.size() > 0) {
            states.stream().map(Identifiable::identifier).forEach(id -> this.add((String)id, typeTag));
            RESOURCE_PACK_BUILTIN.addTag(new class_2960("forgero", "items/" + node.name().toLowerCase(Locale.ENGLISH)), typeTag);
        }
    }

    private void createMaterialToolTags() {
        ImmutableList tools = ForgeroStateRegistry.STATES.find(Type.HOLDABLE);
        ImmutableList materials = ForgeroStateRegistry.STATES.find(Type.TOOL_MATERIAL);
        Map<String, List> materialMap = materials.stream().map(Supplier::get).collect(Collectors.toMap(Identifiable::name, material -> tools.stream().map(Supplier::get).filter(tool -> Arrays.stream(tool.name().split(Common.ELEMENT_SEPARATOR)).anyMatch(nameElement -> nameElement.equals(material.name()))).toList()));
        for (Map.Entry<String, List> entry : materialMap.entrySet()) {
            String key = entry.getKey();
            List states = entry.getValue();
            JTag materialToolTag = new JTag();
            if (states.size() <= 0) continue;
            states.stream().map(Identifiable::identifier).forEach(id -> this.add((String)id, materialToolTag));
            RESOURCE_PACK_BUILTIN.addTag(new class_2960("forgero", "items/" + key + "_tool"), materialToolTag);
        }
    }

    private void add(String id, JTag tag) {
        Optional tagId = this.mapper.stateToTag(id);
        if (tagId.isPresent()) {
            tag.tag((class_2960)tagId.get());
        } else {
            tag.add(this.mapper.stateToContainer(id));
        }
    }
}

