/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.fabric.resources;

import com.sigmundgranaas.forgero.core.Forgero;
import com.sigmundgranaas.forgero.core.identifier.texture.TemplateIdentifier;
import com.sigmundgranaas.forgero.core.identifier.texture.TextureIdentifier;
import com.sigmundgranaas.forgero.core.identifier.texture.toolpart.PaletteIdentifier;
import com.sigmundgranaas.forgero.core.texture.V2.FileLoader;
import com.sigmundgranaas.forgero.fabric.resources.FabricModFileLoader;
import java.io.InputStream;
import java.util.Optional;

public class FileService
implements FileLoader {
    private String getTexturePath(TextureIdentifier id) {
        if (id.getFileNameWithoutExtension().contains(":")) {
            return "assets/" + id.getFileNameWithExtension().replace(":", "/");
        }
        if (id instanceof TemplateIdentifier) {
            TemplateIdentifier texture = (TemplateIdentifier)id;
            return "assets/forgero/templates/textures/" + texture.getFileNameWithExtension();
        }
        if (id instanceof PaletteIdentifier) {
            return "assets/forgero/templates/materials/" + id.getFileNameWithExtension();
        }
        return "";
    }

    public InputStream getStream(TextureIdentifier id) {
        Optional<InputStream> inputStream = new FabricModFileLoader().loadFileFromMods(this.getTexturePath(id));
        if (inputStream.isEmpty()) {
            throw new IllegalArgumentException("file not found! " + this.getTexturePath(id));
        }
        return inputStream.get();
    }

    public Optional<InputStream> getStream(String location) {
        return new FabricModFileLoader().loadFileFromMods(location);
    }

    public Optional<InputStream> getStreamSilent(String location) {
        return new FabricModFileLoader().loadFileFromMods(location);
    }

    public Optional<InputStream> getStreamLogged(String location) {
        Optional<InputStream> inputStream = new FabricModFileLoader().loadFileFromMods(location);
        if (inputStream.isEmpty()) {
            Forgero.LOGGER.error("file not found: {} ", (Object)location);
        }
        return inputStream;
    }
}

