/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.fabric.resources.dynamic;

import com.sigmundgranaas.forgero.core.state.State;
import com.sigmundgranaas.forgero.core.type.Type;
import com.sigmundgranaas.forgero.core.type.TypeTree;
import com.sigmundgranaas.forgero.fabric.resources.dynamic.DynamicResourceGenerator;
import com.sigmundgranaas.forgero.minecraft.common.service.StateService;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.devtech.arrp.api.RuntimeResourcePack;
import net.devtech.arrp.json.tags.JTag;
import net.minecraft.class_2960;

public class MaterialPartGroupTagGenerator
implements DynamicResourceGenerator {
    private final StateService service;
    private final TypeTree tree;
    private final Map<String, List<String>> idTagEntries = new HashMap<String, List<String>>();
    private final List<String> materialGroups = List.of("WOOD", "STONE", "METAL");

    public MaterialPartGroupTagGenerator(StateService service, TypeTree tree) {
        this.service = service;
        this.tree = tree;
    }

    @Override
    public void generate(RuntimeResourcePack pack) {
        this.materialGroups.forEach(this::findPartsInGroup);
        for (Map.Entry<String, List<String>> entry : this.idTagEntries.entrySet()) {
            JTag tag = new JTag();
            entry.getValue().stream().map(class_2960::new).forEach(arg_0 -> ((JTag)tag).add(arg_0));
            pack.addTag(new class_2960("forgero", "items/" + entry.getKey()), tag);
        }
    }

    private void findPartsInGroup(String type) {
        Set materials = this.tree.find(Type.of((String)type)).map(node -> node.getResources(State.class)).map(HashSet::new).orElse(new HashSet());
    }
}

