/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.fabric.resources.dynamic;

import com.sigmundgranaas.forgero.core.identifier.Common;
import com.sigmundgranaas.forgero.core.state.Composite;
import com.sigmundgranaas.forgero.fabric.resources.dynamic.DynamicResourceGenerator;
import com.sigmundgranaas.forgero.minecraft.common.service.StateService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Supplier;
import net.devtech.arrp.api.RuntimeResourcePack;
import net.devtech.arrp.json.tags.JTag;
import net.minecraft.class_2960;

public class MaterialPartTagGenerator
implements DynamicResourceGenerator {
    private final StateService service;
    private final Map<String, List<String>> idTagEntries = new HashMap<String, List<String>>();

    public MaterialPartTagGenerator(StateService service) {
        this.service = service;
    }

    @Override
    public void generate(RuntimeResourcePack pack) {
        this.service.all().stream().map(Supplier::get).filter(Composite.class::isInstance).map(Composite.class::cast).forEach(this::mapTags);
        for (Map.Entry<String, List<String>> entry : this.idTagEntries.entrySet()) {
            JTag tag = new JTag();
            entry.getValue().stream().map(class_2960::new).forEach(arg_0 -> ((JTag)tag).add(arg_0));
            pack.addTag(new class_2960("forgero", "items/" + entry.getKey()), tag);
        }
    }

    private void mapTags(Composite construct) {
        String[] elements = construct.name().split(Common.ELEMENT_SEPARATOR);
        if (elements.length > 1) {
            String tag = String.format("%s-%s", elements[0], construct.type().typeName().toLowerCase(Locale.ENGLISH));
            if (this.idTagEntries.containsKey(tag)) {
                this.idTagEntries.get(tag).add(construct.identifier());
            } else {
                this.idTagEntries.put(tag, new ArrayList<String>(List.of(construct.identifier())));
            }
        }
    }
}

