/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.fabric.resources.dynamic;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.sigmundgranaas.forgero.core.identifier.Common;
import com.sigmundgranaas.forgero.core.resource.data.v2.data.IngredientData;
import com.sigmundgranaas.forgero.core.resource.data.v2.data.RecipeData;
import com.sigmundgranaas.forgero.core.state.State;
import com.sigmundgranaas.forgero.core.state.composite.ConstructedState;
import com.sigmundgranaas.forgero.fabric.resources.dynamic.DynamicResourceGenerator;
import com.sigmundgranaas.forgero.minecraft.common.recipe.customrecipe.RecipeTypes;
import com.sigmundgranaas.forgero.minecraft.common.recipe.implementation.RecipeUtils;
import com.sigmundgranaas.forgero.minecraft.common.recipe.implementation.generator.CompositeRecipeOptimiser;
import com.sigmundgranaas.forgero.minecraft.common.service.StateService;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Supplier;
import net.devtech.arrp.api.RuntimeResourcePack;
import net.minecraft.class_2960;

public class PartToSchematicGenerator
implements DynamicResourceGenerator {
    protected final StateService service;
    protected final RecipeCreator recipeCreator;
    protected final RecipeFilter recipeFilter;

    public PartToSchematicGenerator(StateService service, RecipeCreator recipeCreator, RecipeFilter recipeFilter) {
        this.service = service;
        this.recipeCreator = recipeCreator;
        this.recipeFilter = recipeFilter;
    }

    @Override
    public void generate(RuntimeResourcePack pack) {
        List recipes = this.parts().stream().map(this.recipeCreator::createRecipe).flatMap(Optional::stream).toList();
        CompositeRecipeOptimiser optimiser = new CompositeRecipeOptimiser();
        optimiser.process(recipes).stream().map(this::convertRecipeData).forEach(recipe -> pack.addData(this.generateId((JsonObject)recipe), recipe.toString().getBytes()));
    }

    protected List<ConstructedState> parts() {
        return this.service.all().stream().map(Supplier::get).filter(ConstructedState.class::isInstance).map(ConstructedState.class::cast).filter(comp -> comp.parts().stream().anyMatch(ingredient -> ingredient.name().contains("schematic"))).filter(this.recipeFilter::shouldKeep).toList();
    }

    protected JsonObject convertRecipeData(RecipeData construct) {
        JsonObject json = new JsonObject();
        json.addProperty("type", "minecraft:crafting_shapeless");
        JsonArray ingredients = new JsonArray();
        construct.ingredients().stream().map(RecipeUtils::ingredientsToJsonEntry).forEach(arg_0 -> ((JsonArray)ingredients).add(arg_0));
        json.add("ingredients", (JsonElement)ingredients);
        JsonObject result = new JsonObject();
        result.addProperty("item", construct.target());
        json.add("result", (JsonElement)result);
        return json;
    }

    protected class_2960 generateId(JsonObject recipe) {
        String output = recipe.getAsJsonObject("result").get("item").getAsString().split(":")[1];
        return new class_2960("forgero:recipes/" + output + "_recipe.json");
    }

    public static interface RecipeCreator {
        public Optional<RecipeData> createRecipe(ConstructedState var1);
    }

    public static interface RecipeFilter {
        public boolean shouldKeep(ConstructedState var1);
    }

    public static class SchematicRecipeCreator
    implements RecipeCreator {
        @Override
        public Optional<RecipeData> createRecipe(ConstructedState construct) {
            Optional<State> schematic = construct.parts().stream().filter(ingredient -> ingredient.name().contains("schematic")).findFirst();
            if (schematic.isPresent()) {
                IngredientData paper = IngredientData.builder().id("minecraft:paper").build();
                IngredientData constructIngredient = IngredientData.builder().id(construct.identifier()).build();
                RecipeData recipe = RecipeData.builder().ingredients(List.of(paper, constructIngredient)).target(schematic.get().identifier()).craftingType(RecipeTypes.TOOLPART_SCHEMATIC_RECIPE.toString()).build();
                return Optional.of(recipe);
            }
            return Optional.empty();
        }
    }

    public static class AllVariantFilter
    implements RecipeFilter {
        @Override
        public boolean shouldKeep(ConstructedState state) {
            return true;
        }
    }

    public static class BaseVariantFilter
    implements RecipeFilter {
        @Override
        public boolean shouldKeep(ConstructedState state) {
            String name = state.name().toLowerCase(Locale.ENGLISH);
            String type = state.type().typeName().toLowerCase(Locale.ENGLISH);
            String[] nameComponents = name.split(Common.ELEMENT_SEPARATOR);
            if (nameComponents.length < 2) {
                return false;
            }
            return nameComponents[1].equals(type) || nameComponents[1].equals("binding");
        }
    }
}

