/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.fabric.resources.dynamic;

import com.sigmundgranaas.forgero.core.state.State;
import com.sigmundgranaas.forgero.core.type.Type;
import com.sigmundgranaas.forgero.core.util.match.Matchable;
import com.sigmundgranaas.forgero.fabric.resources.dynamic.DynamicResourceGenerator;
import com.sigmundgranaas.forgero.minecraft.common.service.StateService;
import com.sigmundgranaas.forgero.minecraft.common.utils.StateUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import net.devtech.arrp.api.RuntimeResourcePack;
import net.devtech.arrp.json.tags.JTag;
import net.minecraft.class_2960;

public class PartTypeTagGenerator
implements DynamicResourceGenerator {
    private final StateService service;
    private final Map<String, List<String>> idTagEntries = new HashMap<String, List<String>>();

    public PartTypeTagGenerator(StateService service) {
        this.service = service;
    }

    @Override
    public void generate(RuntimeResourcePack pack) {
        this.service.all().stream().map(Supplier::get).filter(state -> state.test((Matchable)Type.PART)).forEach(this::mapTags);
        for (Map.Entry<String, List<String>> entry : this.idTagEntries.entrySet()) {
            JTag tag = new JTag();
            entry.getValue().stream().map(class_2960::new).forEach(arg_0 -> ((JTag)tag).add(arg_0));
            pack.addTag(new class_2960("forgero", "items/" + entry.getKey()), tag);
        }
    }

    private void mapTags(State construct) {
        String type = construct.type().typeName().toLowerCase(Locale.ENGLISH);
        if (this.idTagEntries.containsKey(type)) {
            this.convertId(construct).ifPresent(id -> this.idTagEntries.get(type).add((String)id));
        } else {
            this.convertId(construct).ifPresent(id -> this.idTagEntries.put(type, new ArrayList<String>(List.of(id))));
        }
    }

    private Optional<String> convertId(State state) {
        return StateUtils.containerMapper((String)state.identifier()).map(class_2960::toString);
    }
}

