/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.fabric.resources.dynamic;

import com.google.common.collect.ImmutableList;
import com.sigmundgranaas.forgero.core.ForgeroStateRegistry;
import com.sigmundgranaas.forgero.core.configuration.ForgeroConfiguration;
import com.sigmundgranaas.forgero.core.state.State;
import com.sigmundgranaas.forgero.core.type.Type;
import com.sigmundgranaas.forgero.fabric.resources.dynamic.DynamicResourceGenerator;
import com.sigmundgranaas.forgero.minecraft.common.item.Items;
import com.sigmundgranaas.forgero.minecraft.common.service.StateService;
import java.util.Optional;
import net.devtech.arrp.api.RuntimeResourcePack;
import net.devtech.arrp.json.lang.JLang;
import net.devtech.arrp.json.models.JModel;
import net.devtech.arrp.json.models.JTextures;
import net.devtech.arrp.json.recipe.JIngredient;
import net.devtech.arrp.json.recipe.JIngredients;
import net.devtech.arrp.json.recipe.JRecipe;
import net.devtech.arrp.json.recipe.JResult;
import net.devtech.arrp.json.recipe.JShapelessRecipe;
import net.minecraft.class_2960;

public class RepairKitResourceGenerator
implements DynamicResourceGenerator {
    private final ForgeroConfiguration configuration;
    private final StateService stateService;

    public RepairKitResourceGenerator(ForgeroConfiguration configuration, StateService stateService) {
        this.configuration = configuration;
        this.stateService = stateService;
    }

    @Override
    public boolean enabled() {
        return this.configuration.enableRepairKits;
    }

    @Override
    public void generate(RuntimeResourcePack pack) {
        this.createRepairKitsRecipes(pack);
        this.createRepairKitLang(pack);
        this.createRepairKitModel(pack);
    }

    private void createRepairKitsRecipes(RuntimeResourcePack pack) {
        ImmutableList materials = ForgeroStateRegistry.TREE.find(Type.TOOL_MATERIAL).map(node -> node.getResources(State.class)).orElse(ImmutableList.builder().build());
        for (State material : materials) {
            JIngredients ingredients = JIngredients.ingredients();
            ingredients.add(this.convertStateToIngredient(material));
            ingredients.add(JIngredient.ingredient().item(Items.EMPTY_REPAIR_KIT));
            JShapelessRecipe recipe = JShapelessRecipe.shapeless((JIngredients)ingredients, (JResult)JResult.result((String)new class_2960("forgero", material.name() + "_repair_kit").toString()));
            pack.addRecipe(new class_2960("forgero", material.name() + "_repair_kit"), (JRecipe)recipe);
        }
    }

    private JIngredient convertStateToIngredient(State state) {
        Optional tagId = this.stateService.getMapper().stateToTag(state.identifier());
        if (tagId.isPresent()) {
            return JIngredient.ingredient().tag(((class_2960)tagId.get()).toString());
        }
        return JIngredient.ingredient().item(this.stateService.getMapper().stateToContainer(state.identifier()).toString());
    }

    private void createRepairKitModel(RuntimeResourcePack pack) {
        ImmutableList materials = ForgeroStateRegistry.TREE.find(Type.TOOL_MATERIAL).map(node -> node.getResources(State.class)).orElse(ImmutableList.builder().build());
        for (State material : materials) {
            JModel model = new JModel();
            model.parent("item/generated");
            model.textures(new JTextures().layer0("forgero:item/repair_kit_leather_base").layer1("forgero:item/repair_kit_needle_base").layer2(String.format("forgero:item/%s-repair_kit", material.name())));
            pack.addModel(model, new class_2960("forgero", "item/" + material.name() + "_repair_kit"));
        }
    }

    private void createRepairKitLang(RuntimeResourcePack pack) {
        ImmutableList materials = ForgeroStateRegistry.TREE.find(Type.TOOL_MATERIAL).map(node -> node.getResources(State.class)).orElse(ImmutableList.builder().build());
        JLang lang = new JLang();
        for (State material : materials) {
            if (!StateService.INSTANCE.find(material.identifier()).isPresent()) continue;
            String name = material.name().substring(0, 1).toUpperCase() + material.name().substring(1).replace("_", " ");
            lang.item(new class_2960("forgero", material.name() + "_repair_kit"), String.format("%s Repair kit", name));
        }
        pack.addLang(new class_2960("forgero", "en_us"), lang);
    }
}

