/*
 * Decompiled with CFR 0.152.
 */
package fuzs.diagonalblocks.api.v2.client;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import fuzs.diagonalblocks.api.v2.DiagonalBlockType;
import fuzs.diagonalblocks.client.resources.model.MultipartAppender;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.class_1091;
import net.minecraft.class_1100;
import net.minecraft.class_2248;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_773;
import net.minecraft.class_816;
import org.jetbrains.annotations.Nullable;

public class MultiPartTranslator {
    private static final Map<DiagonalBlockType, MultiPartTranslator> TRANSLATORS = Maps.newConcurrentMap();
    protected final DiagonalBlockType type;

    protected MultiPartTranslator(DiagonalBlockType type) {
        this.type = type;
    }

    public static void register(DiagonalBlockType diagonalBlockType, MultiPartTranslator translator) {
        TRANSLATORS.put(diagonalBlockType, translator);
    }

    public static MultiPartTranslator get(DiagonalBlockType diagonalBlockType) {
        return TRANSLATORS.computeIfAbsent(diagonalBlockType, MultiPartTranslator::new);
    }

    public class_1091 convertAnyBlockState(class_2248 oldBlock, class_2248 newBlock) {
        class_2689 stateDefinition = oldBlock.method_9595();
        class_2680 blockState = this.convertBlockState((class_2689<class_2248, class_2680>)newBlock.method_9595(), (class_2680)stateDefinition.method_11664());
        return class_773.method_3340((class_2680)blockState);
    }

    private class_2680 convertBlockState(class_2689<class_2248, class_2680> newStateDefinition, class_2680 oldBlockState) {
        class_2680 newBlockState = (class_2680)newStateDefinition.method_11664();
        for (Map.Entry entry : oldBlockState.method_11656().entrySet()) {
            newBlockState = this.setBlockStateValue((class_2769)entry.getKey(), (Comparable)entry.getValue(), arg_0 -> newStateDefinition.method_11663(arg_0), newBlockState);
        }
        return newBlockState;
    }

    private <T extends Comparable<T>, V extends T> class_2680 setBlockStateValue(class_2769<?> oldProperty, Comparable<?> oldValue, Function<String, @Nullable class_2769<?>> propertyGetter, class_2680 blockState) {
        class_2769<?> newProperty = propertyGetter.apply(oldProperty.method_11899());
        if (newProperty != null) {
            Comparable<?> newValue = this.getNewPropertyValue(oldProperty, newProperty, oldValue);
            return (class_2680)blockState.method_11657(newProperty, newValue);
        }
        return blockState;
    }

    protected Comparable<?> getNewPropertyValue(class_2769<?> oldProperty, class_2769<?> newProperty, Comparable<?> oldValue) {
        return oldValue;
    }

    public class_816 apply(class_2248 diagonalBlock, class_816 baseBlockModel, BiConsumer<class_2960, class_1100> modelAdder) {
        return this.applyAdditionalSelectors(modelAdder, this.getModelFromBase(diagonalBlock, baseBlockModel));
    }

    protected class_816 getModelFromBase(class_2248 diagonalBlock, class_816 baseBlockModel) {
        ArrayList selectors = Lists.newArrayList((Iterable)baseBlockModel.method_3519());
        return new class_816(diagonalBlock.method_9595(), (List)selectors);
    }

    protected class_816 applyAdditionalSelectors(BiConsumer<class_2960, class_1100> modelAdder, class_816 multiPart) {
        return MultipartAppender.appendDiagonalSelectors(modelAdder, multiPart, false);
    }

    public boolean allowBaseModelAsFallback() {
        return true;
    }
}

