/*
 * Decompiled with CFR 0.152.
 */
package fuzs.diagonalblocks.api.v2.impl;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Maps;
import fuzs.diagonalblocks.api.v2.DiagonalBlock;
import fuzs.diagonalblocks.api.v2.DiagonalBlockType;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.UnaryOperator;
import net.minecraft.class_2248;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7924;

public class DiagonalBlockTypeImpl
implements DiagonalBlockType {
    private static final UnaryOperator<class_2248> NULL_FACTORY = UnaryOperator.identity();
    private final BiMap<class_2248, class_2248> blocks = HashBiMap.create();
    private final BiMap<class_2248, class_2248> blocksView = Maps.unmodifiableBiMap(this.blocks);
    private final class_2960 name;
    private final Class<? extends class_2248> targetType;
    private final UnaryOperator<class_2248> factory;
    private final int blockPropertiesCount;
    private final class_6862<class_2248> blacklistTagKey;
    private final Map<class_2960, UnaryOperator<class_2248>> factoryOverrides = Maps.newConcurrentMap();

    public DiagonalBlockTypeImpl(String name, Class<? extends class_2248> targetType, UnaryOperator<class_2248> factory, class_2769<?> ... blockProperties) {
        this(name, targetType, factory, blockProperties.length);
    }

    public DiagonalBlockTypeImpl(String name, Class<? extends class_2248> targetType, UnaryOperator<class_2248> factory, int blockPropertiesCount) {
        name = name.toLowerCase(Locale.ROOT);
        this.name = new class_2960("diagonal" + name, name);
        this.targetType = targetType;
        this.factory = factory;
        this.blockPropertiesCount = blockPropertiesCount;
        this.blacklistTagKey = class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)this.id("non_diagonal_" + name));
    }

    @Override
    public class_2960 id(String path) {
        return new class_2960(this.name.method_12836(), path);
    }

    @Override
    public class_6862<class_2248> getBlacklistTagKey() {
        return this.blacklistTagKey;
    }

    public String toString() {
        return this.name.toString();
    }

    @Override
    public boolean isTarget(class_2960 resourceLocation, class_2248 block) {
        if (!(block instanceof DiagonalBlock) && this.factoryOverrides.get(resourceLocation) != NULL_FACTORY) {
            boolean isTarget = this.targetType.isInstance(block) && this.blockPropertiesCount == block.method_9595().method_11659().size();
            return isTarget || this.factoryOverrides.containsKey(resourceLocation);
        }
        return false;
    }

    @Override
    public class_2248 makeDiagonalBlock(class_2960 resourceLocation, class_2248 block) {
        if (this.isTarget(resourceLocation, block)) {
            class_2248 diagonalBlock = (class_2248)this.factoryOverrides.getOrDefault(resourceLocation, this.factory).apply(block);
            Objects.requireNonNull(diagonalBlock, "diagonal block for '%s' is null".formatted(resourceLocation));
            this.blocks.put((Object)block, (Object)diagonalBlock);
            return diagonalBlock;
        }
        throw new IllegalArgumentException("%s is no target for %s".formatted(block, this));
    }

    @Override
    public BiMap<class_2248, class_2248> getBlockConversions() {
        return this.blocksView;
    }

    @Override
    public void registerBlockFactory(class_2960 resourceLocation, UnaryOperator<class_2248> factory) {
        Objects.requireNonNull(resourceLocation, "resource location is null");
        Objects.requireNonNull(factory, "factory is null");
        this.factoryOverrides.put(resourceLocation, factory);
    }

    @Override
    public void registerDefaultBlockFactory(class_2960 resourceLocation) {
        Objects.requireNonNull(resourceLocation, "resource location is null");
        this.factoryOverrides.put(resourceLocation, this.factory);
    }

    @Override
    public void disableBlockFactory(class_2960 resourceLocation) {
        Objects.requireNonNull(resourceLocation, "resource location is null");
        this.factoryOverrides.put(resourceLocation, NULL_FACTORY);
    }
}

