/*
 * Decompiled with CFR 0.152.
 */
package fuzs.diagonalblocks.api.v2.impl;

import com.google.common.collect.Maps;
import fuzs.diagonalblocks.api.v2.DiagonalBlock;
import fuzs.diagonalblocks.api.v2.EightWayDirection;
import fuzs.diagonalblocks.api.v2.impl.StarShapeProvider;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.class_1750;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_247;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2746;
import net.minecraft.class_2769;

public interface StarCollisionBlock
extends DiagonalBlock,
StarShapeProvider {
    public static final Map<EightWayDirection, class_2746> PROPERTY_BY_DIRECTION = Maps.immutableEnumMap(Map.of(EightWayDirection.NORTH, DiagonalBlock.NORTH, EightWayDirection.EAST, DiagonalBlock.EAST, EightWayDirection.SOUTH, DiagonalBlock.SOUTH, EightWayDirection.WEST, DiagonalBlock.WEST, EightWayDirection.NORTH_EAST, DiagonalBlock.NORTH_EAST, EightWayDirection.SOUTH_EAST, DiagonalBlock.SOUTH_EAST, EightWayDirection.SOUTH_WEST, DiagonalBlock.SOUTH_WEST, EightWayDirection.NORTH_WEST, DiagonalBlock.NORTH_WEST));
    public static final Int2ObjectMap<Map<EightWayDirection, class_265>> CORNER_SHAPES_CACHE = new Int2ObjectOpenHashMap();
    public static final Object2ObjectMap<DiagonalBlock, Map<EightWayDirection, class_265>> CORNER_SHAPES_BLOCK_CACHE = new Object2ObjectOpenHashMap();

    public static class_2680 updateDiagonalProperties(DiagonalBlock diagonalBlock, class_2680 blockState, class_1936 levelAccessor, class_2338 blockPos, EightWayDirection ... eightWayDirections) {
        for (EightWayDirection eightWayDirection : eightWayDirections) {
            if (!eightWayDirection.isIntercardinal()) {
                throw new IllegalArgumentException("direction must be intercardinal");
            }
            class_2338 neighborBlockPos = blockPos.method_10069(eightWayDirection.getX(), eightWayDirection.getY(), eightWayDirection.getZ());
            class_2680 neighborBlockState = levelAccessor.method_8320(neighborBlockPos);
            boolean value = StarCollisionBlock.allowsDiagonalProperty(diagonalBlock, levelAccessor, blockPos, neighborBlockState, eightWayDirection);
            if (value) {
                DiagonalBlock neighborDiagonalBlock = (DiagonalBlock)neighborBlockState.method_26204();
                value = StarCollisionBlock.allowsDiagonalProperty(neighborDiagonalBlock, levelAccessor, neighborBlockPos, blockState, eightWayDirection.getOpposite());
            }
            blockState = (class_2680)blockState.method_11657((class_2769)PROPERTY_BY_DIRECTION.get((Object)eightWayDirection), (Comparable)Boolean.valueOf(value));
        }
        return blockState;
    }

    public static boolean allowsDiagonalProperty(DiagonalBlock diagonalBlock, class_1936 levelAccessor, class_2338 blockPos, class_2680 neighborBlockState, EightWayDirection eightWayDirection) {
        return diagonalBlock.attachesDiagonallyTo(neighborBlockState) && StarCollisionBlock.isFreeForDiagonalProperty(diagonalBlock, levelAccessor, blockPos, eightWayDirection) && StarCollisionBlock.isNotCollidingWithNeighbors(diagonalBlock, levelAccessor, blockPos, eightWayDirection);
    }

    public static boolean isFreeForDiagonalProperty(DiagonalBlock diagonalBlock, class_1936 levelAccessor, class_2338 blockPos, EightWayDirection eightWayDirection) {
        for (EightWayDirection neighbor : eightWayDirection.getCardinalNeighbors()) {
            boolean isSideSolid;
            class_2350 direction = neighbor.toDirection();
            class_2338 neighborBlockPos = blockPos.method_10093(direction);
            class_2680 neighborBlockState = levelAccessor.method_8320(neighborBlockPos);
            if (!diagonalBlock.attachesDirectlyTo(neighborBlockState, isSideSolid = neighborBlockState.method_26206((class_1922)levelAccessor, neighborBlockPos, direction.method_10153()), direction.method_10153())) continue;
            return false;
        }
        return true;
    }

    public static boolean isNotCollidingWithNeighbors(DiagonalBlock diagonalBlock, class_1936 levelAccessor, class_2338 blockPos, EightWayDirection eightWayDirection) {
        if (CORNER_SHAPES_BLOCK_CACHE.containsKey((Object)diagonalBlock)) {
            Map shapes = (Map)CORNER_SHAPES_BLOCK_CACHE.get((Object)diagonalBlock);
            for (EightWayDirection neighbor : eightWayDirection.getCardinalNeighbors()) {
                class_2338 neighborBlockPos;
                class_2680 neighborBlockState;
                class_265 voxelShape;
                class_265 cornerShape = (class_265)shapes.get((Object)(eightWayDirection.data2d != neighbor.data2d ? eightWayDirection.rotateClockWise(2) : eightWayDirection.rotateCounterClockWise(2)));
                if (!class_259.method_1074((class_265)cornerShape, (class_265)(voxelShape = (neighborBlockState = levelAccessor.method_8320(neighborBlockPos = blockPos.method_10093(neighbor.toDirection()))).method_26220((class_1922)levelAccessor, neighborBlockPos)), (class_247)class_247.field_16896)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    default public class_265[] _makeShapes(float nodeWidth, float extensionWidth, float nodeTop, float extensionBottom, float extensionTop) {
        if (extensionBottom == 0.0f && extensionTop <= 16.0f && !CORNER_SHAPES_BLOCK_CACHE.containsKey((Object)this)) {
            Map cornerShapes = (Map)CORNER_SHAPES_CACHE.computeIfAbsent(Arrays.hashCode(new float[]{extensionWidth, extensionBottom, extensionTop}), $ -> (Map)Stream.of(EightWayDirection.getIntercardinalDirections()).collect(Maps.toImmutableEnumMap(Function.identity(), eightWayDirection -> this.getCornerShape((EightWayDirection)((Object)((Object)eightWayDirection)), extensionWidth, extensionBottom, extensionTop))));
            CORNER_SHAPES_BLOCK_CACHE.put((Object)this, (Object)cornerShapes);
        }
        return StarShapeProvider.super._makeShapes(nodeWidth, extensionWidth, nodeTop, extensionBottom, extensionTop);
    }

    private class_265 getCornerShape(EightWayDirection eightWayDirection, float extensionWidth, float extensionBottom, float extensionTop) {
        int posX = eightWayDirection.getX() > 0 ? 0 : 16;
        int posZ = eightWayDirection.getZ() > 0 ? 0 : 16;
        return class_2248.method_9541((double)((float)posX - extensionWidth), (double)extensionBottom, (double)((float)posZ - extensionWidth), (double)((float)posX + extensionWidth), (double)extensionTop, (double)((float)posZ + extensionWidth));
    }

    @Override
    default public boolean attachesDiagonallyTo(class_2680 blockState) {
        DiagonalBlock diagonalBlock;
        class_2248 class_22482 = blockState.method_26204();
        return class_22482 instanceof DiagonalBlock && (diagonalBlock = (DiagonalBlock)class_22482).getType() == this.getType();
    }

    default public class_2680 addDefaultStates(class_2680 defaultState) {
        return (class_2680)((class_2680)((class_2680)((class_2680)defaultState.method_11657((class_2769)DiagonalBlock.NORTH_EAST, (Comparable)Boolean.FALSE)).method_11657((class_2769)DiagonalBlock.SOUTH_EAST, (Comparable)Boolean.FALSE)).method_11657((class_2769)DiagonalBlock.SOUTH_WEST, (Comparable)Boolean.FALSE)).method_11657((class_2769)DiagonalBlock.NORTH_WEST, (Comparable)Boolean.FALSE);
    }

    default public void _createBlockStateDefinition(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{DiagonalBlock.NORTH_EAST, DiagonalBlock.SOUTH_EAST, DiagonalBlock.SOUTH_WEST, DiagonalBlock.NORTH_WEST});
    }

    default public class_2680 _getStateForPlacement(class_1750 context, class_2680 blockState) {
        class_1937 level = context.method_8045();
        class_2338 clickedPos = context.method_8037();
        EightWayDirection[] eightWayDirections = EightWayDirection.getIntercardinalDirections();
        return StarCollisionBlock.updateDiagonalProperties(this, blockState, (class_1936)level, clickedPos, eightWayDirections);
    }

    default public class_2680 _updateShape(class_2680 blockState, class_2350 direction, class_2680 neighboringBlockState, class_1936 levelAccessor, class_2338 blockPos, class_2338 neighboringBlockPos) {
        if (direction.method_10166().method_10180() == class_2350.class_2353.field_11062) {
            EightWayDirection[] eightWayDirections = EightWayDirection.toEightWayDirection(direction).getIntercardinalNeighbors();
            return StarCollisionBlock.updateDiagonalProperties(this, blockState, levelAccessor, blockPos, eightWayDirections);
        }
        return blockState;
    }

    default public void _updateIndirectNeighbourShapes(class_2680 blockState, class_1936 levelAccessor, class_2338 blockPos, int flags, int recursionLeft) {
        for (EightWayDirection eightWayDirection : EightWayDirection.getIntercardinalDirections()) {
            class_2680 newNeighborBlockState;
            if (!((Boolean)blockState.method_11654((class_2769)PROPERTY_BY_DIRECTION.get((Object)eightWayDirection))).booleanValue()) continue;
            class_2338 neighborBlockPos = blockPos.method_10069(eightWayDirection.getX(), eightWayDirection.getY(), eightWayDirection.getZ());
            class_2680 neighborBlockState = levelAccessor.method_8320(neighborBlockPos);
            class_2248 class_22482 = neighborBlockState.method_26204();
            if (class_22482 instanceof StarCollisionBlock) {
                StarCollisionBlock starCollisionBlock = (StarCollisionBlock)class_22482;
                newNeighborBlockState = starCollisionBlock.updateIndirectNeighborDiagonalProperty(neighborBlockState, levelAccessor, neighborBlockPos, eightWayDirection.getOpposite());
            } else {
                class_22482 = neighborBlockState.method_26204();
                if (class_22482 instanceof DiagonalBlock) {
                    DiagonalBlock diagonalBlock = (DiagonalBlock)class_22482;
                    newNeighborBlockState = StarCollisionBlock.updateDiagonalProperties(diagonalBlock, neighborBlockState, levelAccessor, neighborBlockPos, eightWayDirection.getOpposite());
                } else {
                    newNeighborBlockState = null;
                }
            }
            if (newNeighborBlockState == null) continue;
            class_2248.method_9611((class_2680)neighborBlockState, (class_2680)newNeighborBlockState, (class_1936)levelAccessor, (class_2338)neighborBlockPos, (int)flags, (int)recursionLeft);
        }
    }

    default public class_2680 updateIndirectNeighborDiagonalProperty(class_2680 blockState, class_1936 levelAccessor, class_2338 blockPos, EightWayDirection eightWayDirection) {
        return StarCollisionBlock.updateDiagonalProperties(this, blockState, levelAccessor, blockPos, eightWayDirection);
    }
}

