/*
 * Decompiled with CFR 0.152.
 */
package fuzs.diagonalblocks.api.v2.impl;

import com.google.common.base.Stopwatch;
import fuzs.diagonalblocks.DiagonalBlocks;
import fuzs.diagonalblocks.api.v2.EightWayDirection;
import fuzs.diagonalblocks.api.v2.impl.StarCollisionBlock;
import fuzs.diagonalblocks.world.phys.shapes.NoneVoxelShape;
import fuzs.diagonalblocks.world.phys.shapes.VoxelCollection;
import fuzs.diagonalblocks.world.phys.shapes.VoxelUtils;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.class_2248;
import net.minecraft.class_243;
import net.minecraft.class_247;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2746;
import net.minecraft.class_2769;

public interface StarShapeProvider {
    public static final Object2IntMap<class_2680> STATE_INDEX_CACHE = new Object2IntOpenHashMap();
    public static final Int2ObjectMap<class_265[]> SHAPES_CACHE = new Int2ObjectOpenHashMap();

    default public int _getAABBIndex(class_2680 state) {
        return STATE_INDEX_CACHE.computeIfAbsent((Object)state, this::makeIndex);
    }

    default public int makeIndex(class_2680 blockState) {
        int index = 0;
        for (Map.Entry<EightWayDirection, class_2746> entry : StarCollisionBlock.PROPERTY_BY_DIRECTION.entrySet()) {
            if (!((Boolean)blockState.method_11654((class_2769)entry.getValue())).booleanValue()) continue;
            index |= entry.getKey().getHorizontalIndex();
        }
        return index;
    }

    default public class_265[] _makeShapes(float nodeWidth, float extensionWidth, float nodeTop, float extensionBottom, float extensionTop) {
        return (class_265[])SHAPES_CACHE.computeIfAbsent(Arrays.hashCode(new float[]{nodeWidth, extensionWidth, nodeTop, extensionBottom, extensionTop}), $ -> this.makeDiagonalShapes(nodeWidth, extensionWidth, nodeTop, extensionBottom, extensionTop));
    }

    default public class_265[] makeDiagonalShapes(float nodeWidth, float extensionWidth, float nodeTop, float extensionBottom, float extensionTop) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        float nodeStart = 8.0f - nodeWidth;
        float nodeEnd = 8.0f + nodeWidth;
        float extensionStart = 8.0f - extensionWidth;
        float extensionEnd = 8.0f + extensionWidth;
        class_265 nodeShape = class_2248.method_9541((double)nodeStart, (double)0.0, (double)nodeStart, (double)nodeEnd, (double)nodeTop, (double)nodeEnd);
        class_243[] sideShape = new class_243[]{new class_243((double)extensionStart, (double)extensionBottom, 0.0), new class_243((double)extensionEnd, (double)extensionTop, (double)nodeStart)};
        class_243[] sideParticleShape = new class_243[]{new class_243(0.0, (double)extensionBottom, 0.0), new class_243((double)nodeStart, (double)extensionTop, (double)nodeStart)};
        class_265[] verticalShapes = (class_265[])Stream.of(EightWayDirection.getCardinalDirections()).map(direction -> direction.transform(sideShape)).map(VoxelUtils::scaleDown).map(VoxelUtils::box).toArray(class_265[]::new);
        class_265[] diagonalShapes = (class_265[])Stream.of(EightWayDirection.getIntercardinalDirections()).map(direction -> this.getDiagonalShape(extensionWidth, extensionBottom, extensionTop, (EightWayDirection)((Object)direction), nodeWidth == extensionWidth)).toArray(class_265[]::new);
        class_265[] diagonalParticleShapes = (class_265[])Stream.of(EightWayDirection.getIntercardinalDirections()).map(direction -> {
            class_243[] edges = sideParticleShape;
            if (direction.getX() != 1) {
                edges = VoxelUtils.flipX(edges);
            }
            if (direction.getZ() != 1) {
                edges = VoxelUtils.flipZ(edges);
            }
            return edges;
        }).map(VoxelUtils::scaleDown).map(VoxelUtils::box).toArray(class_265[]::new);
        class_265[] sideShapes = new class_265[]{verticalShapes[2], verticalShapes[3], verticalShapes[0], verticalShapes[1], diagonalShapes[2], diagonalShapes[3], diagonalShapes[0], diagonalShapes[1]};
        class_265[] particleSideShapes = new class_265[]{verticalShapes[2], verticalShapes[3], verticalShapes[0], verticalShapes[1], diagonalParticleShapes[2], diagonalParticleShapes[3], diagonalParticleShapes[0], diagonalParticleShapes[1]};
        class_265[] stateShapes = this.constructStateShapes(nodeShape, sideShapes, particleSideShapes);
        DiagonalBlocks.LOGGER.info("Constructing shapes for {}[NodeWidth={},ExtensionWidth={},NodeTop={},ExtensionBottom={},ExtensionTop={}] took {}ms", (Object)this.getClass().getSimpleName(), (Object)Float.valueOf(nodeWidth), (Object)Float.valueOf(extensionWidth), (Object)Float.valueOf(nodeTop), (Object)Float.valueOf(extensionBottom), (Object)Float.valueOf(extensionTop), (Object)stopwatch.stop().elapsed().toMillis());
        return stateShapes;
    }

    default public class_265[] constructStateShapes(class_265 nodeShape, class_265[] directionalShapes, class_265[] particleDirectionalShapes) {
        VoxelCollection[] stateShapes = new VoxelCollection[(int)Math.pow(2.0, directionalShapes.length)];
        for (int i = 0; i < stateShapes.length; ++i) {
            VoxelCollection voxelCollection = new VoxelCollection(nodeShape);
            for (int j = 0; j < directionalShapes.length; ++j) {
                if ((i & 1 << j) == 0) continue;
                voxelCollection.addVoxelShape(directionalShapes[j], particleDirectionalShapes[j]);
            }
            stateShapes[i] = voxelCollection.optimize();
        }
        return stateShapes;
    }

    default public class_265 getDiagonalShape(float extensionWidth, float extensionBottom, float extensionHeight, EightWayDirection direction, boolean stretchWidth) {
        class_265 collisionShape = this.getDiagonalCollisionShape(extensionWidth, extensionBottom, extensionHeight, direction);
        if (stretchWidth) {
            extensionWidth = (float)Math.sqrt(extensionWidth * extensionWidth * 2.0f);
        }
        float diagonalSide = 0.70710677f * extensionWidth;
        class_243[] corners = VoxelUtils.createVectorArray(Float.valueOf(-diagonalSide), Float.valueOf(extensionHeight), Float.valueOf(diagonalSide), Float.valueOf(-diagonalSide + 8.0f), Float.valueOf(extensionHeight), Float.valueOf(diagonalSide + 8.0f), Float.valueOf(-diagonalSide), Float.valueOf(extensionBottom), Float.valueOf(diagonalSide), Float.valueOf(-diagonalSide + 8.0f), Float.valueOf(extensionBottom), Float.valueOf(diagonalSide + 8.0f), Float.valueOf(diagonalSide), Float.valueOf(extensionHeight), Float.valueOf(-diagonalSide), Float.valueOf(diagonalSide + 8.0f), Float.valueOf(extensionHeight), Float.valueOf(-diagonalSide + 8.0f), Float.valueOf(diagonalSide), Float.valueOf(extensionBottom), Float.valueOf(-diagonalSide), Float.valueOf(diagonalSide + 8.0f), Float.valueOf(extensionBottom), Float.valueOf(-diagonalSide + 8.0f));
        class_243[] edges = VoxelUtils.create12Edges(corners);
        if (direction.getX() != 1) {
            edges = VoxelUtils.flipX(edges);
        }
        if (direction.getZ() != 1) {
            edges = VoxelUtils.flipZ(edges);
        }
        return new NoneVoxelShape(collisionShape, VoxelUtils.scaleDown(edges));
    }

    default public class_265 getDiagonalCollisionShape(float extensionWidth, float extensionBottom, float extensionTop, EightWayDirection direction) {
        class_265 collisionShape = class_259.method_1073();
        for (int i = 0; i < 8; ++i) {
            int posX = direction.getX() > 0 ? i : 16 - i;
            int posZ = direction.getZ() > 0 ? i : 16 - i;
            class_265 cuboidShape = class_2248.method_9541((double)((float)posX - extensionWidth), (double)extensionBottom, (double)((float)posZ - extensionWidth), (double)((float)posX + extensionWidth), (double)extensionTop, (double)((float)posZ + extensionWidth));
            collisionShape = class_259.method_1082((class_265)collisionShape, (class_265)cuboidShape, (class_247)class_247.field_1366);
        }
        return collisionShape.method_1097();
    }
}

