/*
 * Decompiled with CFR 0.152.
 */
package fuzs.diagonalblocks.client;

import com.google.common.collect.Lists;
import fuzs.diagonalblocks.DiagonalBlocks;
import fuzs.diagonalblocks.api.v2.DiagonalBlockType;
import fuzs.diagonalblocks.api.v2.DiagonalBlockTypes;
import fuzs.diagonalblocks.api.v2.client.MultiPartTranslator;
import fuzs.diagonalblocks.client.core.ClientAbstractions;
import fuzs.diagonalblocks.client.handler.DiagonalModelHandler;
import fuzs.diagonalblocks.client.resources.model.MultipartAppender;
import fuzs.diagonalblocks.data.client.DynamicModelProvider;
import fuzs.diagonalblocks.mixin.client.accessor.KeyValueConditionAccessor;
import fuzs.diagonalblocks.mixin.client.accessor.SelectorAccessor;
import fuzs.puzzleslib.api.client.core.v1.ClientModConstructor;
import fuzs.puzzleslib.api.client.event.v1.ModelEvents;
import fuzs.puzzleslib.api.core.v1.context.PackRepositorySourcesContext;
import fuzs.puzzleslib.api.data.v2.core.DataProviderContext;
import fuzs.puzzleslib.api.event.v1.LoadCompleteCallback;
import fuzs.puzzleslib.api.resources.v1.DynamicPackResources;
import fuzs.puzzleslib.api.resources.v1.PackResourcesHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.class_1100;
import net.minecraft.class_1921;
import net.minecraft.class_2248;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3285;
import net.minecraft.class_4778;
import net.minecraft.class_815;
import net.minecraft.class_816;
import net.minecraft.class_818;
import net.minecraft.class_819;

public class DiagonalBlocksClient
implements ClientModConstructor {
    public void onConstructMod() {
        DiagonalBlocksClient.registerHandlers();
    }

    private static void registerHandlers() {
        ModelEvents.MODIFY_UNBAKED_MODEL.register(DiagonalModelHandler::onModifyUnbakedModel);
        ModelEvents.AFTER_MODEL_LOADING.register(DiagonalModelHandler::onAfterModelLoading);
        LoadCompleteCallback.EVENT.register(() -> {
            for (DiagonalBlockType type : DiagonalBlockType.TYPES) {
                for (Map.Entry entry : type.getBlockConversions().entrySet()) {
                    class_1921 renderType = fuzs.puzzleslib.api.client.core.v1.ClientAbstractions.INSTANCE.getRenderType((class_2248)entry.getKey());
                    ClientAbstractions.INSTANCE.registerRenderType((class_2248)entry.getValue(), renderType);
                }
            }
        });
    }

    public void onClientSetup() {
        MultiPartTranslator.register(DiagonalBlockTypes.WINDOW, new MultiPartTranslator(DiagonalBlockTypes.WINDOW){

            @Override
            protected class_816 applyAdditionalSelectors(BiConsumer<class_2960, class_1100> modelAdder, class_816 multiPart) {
                return MultipartAppender.appendDiagonalSelectors(modelAdder, multiPart, true);
            }
        });
        MultiPartTranslator.register(DiagonalBlockTypes.WALL, new MultiPartTranslator(DiagonalBlockTypes.WALL){

            @Override
            protected Comparable<?> getNewPropertyValue(class_2769<?> oldProperty, class_2769<?> newProperty, Comparable<?> oldValue) {
                if (newProperty.method_11902() == class_4778.class) {
                    return (Boolean)oldValue != false ? class_4778.field_22179 : class_4778.field_22178;
                }
                return super.getNewPropertyValue(oldProperty, newProperty, oldValue);
            }

            @Override
            protected class_816 getModelFromBase(class_2248 diagonalBlock, class_816 baseBlockModel) {
                ArrayList selectors = Lists.newArrayList((Iterable)baseBlockModel.method_3519());
                ListIterator<class_819> iterator = selectors.listIterator();
                while (iterator.hasNext()) {
                    class_819 selector = (class_819)iterator.next();
                    class_815 class_8152 = ((SelectorAccessor)selector).diagonalfences$getCondition();
                    if (!(class_8152 instanceof class_818)) continue;
                    class_818 keyValueCondition = (class_818)class_8152;
                    String value = ((KeyValueConditionAccessor)keyValueCondition).diagonalfences$getValue();
                    if (value.equals(class_4778.field_22179.toString())) {
                        value = Boolean.TRUE.toString();
                    } else if (value.equals(class_4778.field_22178.toString())) {
                        value = Boolean.FALSE.toString();
                    } else {
                        if (!value.equals(class_4778.field_22180.toString())) continue;
                        value = null;
                    }
                    if (value != null) {
                        String key = ((KeyValueConditionAccessor)keyValueCondition).diagonalfences$getKey();
                        iterator.set(new class_819((class_815)new class_818(key, value), selector.method_3529()));
                        continue;
                    }
                    iterator.remove();
                }
                return new class_816(diagonalBlock.method_9595(), (List)selectors);
            }

            @Override
            public boolean allowBaseModelAsFallback() {
                return false;
            }
        });
    }

    public void onAddResourcePackFinders(PackRepositorySourcesContext context) {
        context.addRepositorySource(new class_3285[]{PackResourcesHelper.buildClientPack((class_2960)DiagonalBlocks.id("default_block_models"), (Supplier)DynamicPackResources.create((DataProviderContext.Factory[])new DataProviderContext.Factory[]{DynamicModelProvider::new}), (boolean)true)});
    }
}

