/*
 * Decompiled with CFR 0.152.
 */
package fuzs.diagonalblocks.client.handler;

import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import fuzs.diagonalblocks.DiagonalBlocks;
import fuzs.diagonalblocks.api.v2.DiagonalBlockType;
import fuzs.diagonalblocks.api.v2.client.MultiPartTranslator;
import fuzs.diagonalblocks.data.ModBlockTagsProvider;
import fuzs.puzzleslib.api.event.v1.core.EventResultHolder;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.class_1091;
import net.minecraft.class_1092;
import net.minecraft.class_1100;
import net.minecraft.class_156;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import net.minecraft.class_816;

public class DiagonalModelHandler {
    private static final Supplier<Map<DiagonalBlockType, Map<class_2960, class_2248>>> BASE_BLOCKS_BY_DIAGONAL_LOCATION;
    private static final Map<class_2960, class_1100> UNBAKED_MODEL_CACHE;
    private static final Set<class_2960> REPORTED_BLOCKS;

    public static EventResultHolder<class_1100> onModifyUnbakedModel(class_2960 modelLocation, Supplier<class_1100> unbakedModel, Function<class_2960, class_1100> modelGetter, BiConsumer<class_2960, class_1100> modelAdder) {
        class_2960 resourceLocation = new class_2960(modelLocation.method_12836(), modelLocation.method_12832());
        if (UNBAKED_MODEL_CACHE.containsKey(resourceLocation)) {
            return EventResultHolder.interrupt((Object)UNBAKED_MODEL_CACHE.get(resourceLocation));
        }
        for (Map.Entry<DiagonalBlockType, Map<class_2960, class_2248>> entry : BASE_BLOCKS_BY_DIAGONAL_LOCATION.get().entrySet()) {
            class_2248 baseBlock = entry.getValue().get(resourceLocation);
            if (baseBlock == null) continue;
            class_2248 diagonalBlock = (class_2248)entry.getKey().getBlockConversions().get((Object)baseBlock);
            Objects.requireNonNull(diagonalBlock, "diagonal block is null");
            MultiPartTranslator translator = MultiPartTranslator.get(entry.getKey());
            class_1091 modelResourceLocation = translator.convertAnyBlockState(diagonalBlock, baseBlock);
            class_1100 baseModel = modelGetter.apply((class_2960)modelResourceLocation);
            if (baseModel instanceof class_816) {
                class_816 multiPart = (class_816)baseModel;
                class_816 newModel = translator.apply(diagonalBlock, multiPart, modelAdder);
                UNBAKED_MODEL_CACHE.put(resourceLocation, (class_1100)newModel);
                return EventResultHolder.interrupt((Object)newModel);
            }
            if (REPORTED_BLOCKS.add(resourceLocation)) {
                class_2960 blockLocation = class_7923.field_41175.method_10221((Object)baseBlock);
                if (!ModBlockTagsProvider.TAG_BLACKLISTED_TYPES.getOrDefault(entry.getKey(), Collections.emptyList()).contains(blockLocation.toString())) {
                    DiagonalBlocks.LOGGER.warn("Block '{}' is using incompatible model '{}' and should be added to the '{}' block tag. The model will not appear correctly under some circumstances!", (Object)blockLocation, (Object)baseModel.getClass().getName(), (Object)entry.getKey().getBlacklistTagKey().comp_327());
                }
            }
            if (!translator.allowBaseModelAsFallback()) break;
            return EventResultHolder.interrupt((Object)baseModel);
        }
        return EventResultHolder.pass();
    }

    public static void onAfterModelLoading(Supplier<class_1092> modelManager) {
        UNBAKED_MODEL_CACHE.clear();
    }

    static {
        UNBAKED_MODEL_CACHE = Maps.newConcurrentMap();
        REPORTED_BLOCKS = Sets.newHashSet();
        BASE_BLOCKS_BY_DIAGONAL_LOCATION = Suppliers.memoize(() -> (Map)DiagonalBlockType.TYPES.stream().collect(ImmutableMap.toImmutableMap(Function.identity(), type -> (Map)type.getBlockConversions().entrySet().stream().map(entry -> Map.entry(class_7923.field_41175.method_10221((Object)((class_2248)entry.getValue())), (class_2248)entry.getKey())).collect(class_156.method_664()))));
    }
}

