/*
 * Decompiled with CFR 0.152.
 */
package fuzs.diagonalblocks.client.resources.model;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import fuzs.diagonalblocks.api.v2.EightWayDirection;
import fuzs.diagonalblocks.client.core.ClientAbstractions;
import fuzs.diagonalblocks.client.resources.model.QuadUtils;
import fuzs.diagonalblocks.client.resources.model.RotatedVariant;
import fuzs.diagonalblocks.mixin.client.accessor.AndConditionAccessor;
import fuzs.diagonalblocks.mixin.client.accessor.KeyValueConditionAccessor;
import fuzs.diagonalblocks.mixin.client.accessor.MultiPartAccessor;
import fuzs.diagonalblocks.mixin.client.accessor.OrConditionAccessor;
import fuzs.diagonalblocks.mixin.client.accessor.SelectorAccessor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import net.minecraft.class_1087;
import net.minecraft.class_1100;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_5819;
import net.minecraft.class_777;
import net.minecraft.class_807;
import net.minecraft.class_812;
import net.minecraft.class_813;
import net.minecraft.class_815;
import net.minecraft.class_816;
import net.minecraft.class_818;
import net.minecraft.class_819;
import net.minecraft.class_821;
import org.apache.commons.lang3.ArrayUtils;
import org.jetbrains.annotations.Nullable;

public class MultipartAppender {
    public static class_816 appendDiagonalSelectors(BiConsumer<class_2960, class_1100> modelAdder, class_816 multiPart, boolean rotateCenter) {
        ArrayList selectors = Lists.newArrayList((Iterable)multiPart.method_3519());
        ArrayList newSelectors = Lists.newArrayList();
        ListIterator<class_819> iterator = selectors.listIterator();
        while (iterator.hasNext()) {
            class_819 selector = (class_819)iterator.next();
            class_815 condition = ((SelectorAccessor)selector).diagonalfences$getCondition();
            ConditionFactoryPair conditionFactoryPair = MultipartAppender.findKeyValueCondition(condition, keyValueCondition -> EightWayDirection.byName(((KeyValueConditionAccessor)keyValueCondition).diagonalfences$getKey()) != null);
            if (conditionFactoryPair != null) {
                class_815 newCondition;
                EightWayDirection direction = EightWayDirection.byName(((KeyValueConditionAccessor)conditionFactoryPair.condition()).diagonalfences$getKey());
                if (direction == null) continue;
                if (direction.isIntercardinal()) {
                    return multiPart;
                }
                if (Objects.equals(((KeyValueConditionAccessor)conditionFactoryPair.condition()).diagonalfences$getValue(), "true")) {
                    newCondition = new class_818(direction.rotateClockWise().method_15434(), "true");
                    MultipartAppender.appendNewSelector(modelAdder, (class_815)conditionFactoryPair.factory().apply(newCondition), selector, direction, newSelectors);
                    continue;
                }
                newCondition = MultipartAppender.negateCondition((class_815)new class_821(MultipartAppender.rotateCenterConditions().values()));
                class_819 newSelector = new class_819((class_815)new class_812((Iterable)Lists.newArrayList((Object[])new class_815[]{condition, newCondition})), selector.method_3529());
                iterator.set(newSelector);
                class_815 otherNewCondition = MultipartAppender.getAndCondition(direction.rotateCounterClockWise(), direction.rotateCounterClockWise().getOpposite());
                MultipartAppender.appendNewSelector(modelAdder, otherNewCondition, selector, direction.rotateClockWise().rotateClockWise(), newSelectors);
                continue;
            }
            if (!rotateCenter || condition != class_815.field_16900) continue;
            Map<EightWayDirection, class_815> conditions = MultipartAppender.rotateCenterConditions();
            for (Map.Entry<EightWayDirection, class_815> entry : conditions.entrySet()) {
                MultipartAppender.appendNewSelector(modelAdder, entry.getValue(), selector, entry.getKey(), newSelectors);
            }
            class_819 newSelector = new class_819(MultipartAppender.negateCondition((class_815)new class_821(conditions.values())), selector.method_3529());
            iterator.set(newSelector);
        }
        selectors.addAll(newSelectors);
        return new class_816(((MultiPartAccessor)multiPart).diagonalfences$getDefinition(), (List)selectors);
    }

    @Nullable
    private static ConditionFactoryPair findKeyValueCondition(class_815 condition, Predicate<class_818> filter) {
        block4: {
            block3: {
                if (condition instanceof class_818) {
                    class_818 keyValueCondition = (class_818)condition;
                    return filter.test(keyValueCondition) ? new ConditionFactoryPair(keyValueCondition, UnaryOperator.identity()) : null;
                }
                if (!(condition instanceof class_812)) break block3;
                ArrayList conditions = Lists.newArrayList(((AndConditionAccessor)condition).diagonalfences$getConditions());
                for (int i = 0; i < conditions.size(); ++i) {
                    ConditionFactoryPair conditionFactoryPair = MultipartAppender.findKeyValueCondition((class_815)conditions.get(i), filter);
                    if (conditionFactoryPair == null) continue;
                    conditions.remove(conditionFactoryPair.condition());
                    return new ConditionFactoryPair(conditionFactoryPair.condition(), condition1 -> {
                        conditions.add((class_815)conditionFactoryPair.factory().apply((class_815)condition1));
                        return new class_812((Iterable)conditions);
                    });
                }
                break block4;
            }
            if (!(condition instanceof class_821)) break block4;
            ArrayList conditions = Lists.newArrayList(((OrConditionAccessor)condition).diagonalfences$getConditions());
            for (int i = 0; i < conditions.size(); ++i) {
                ConditionFactoryPair conditionFactoryPair = MultipartAppender.findKeyValueCondition((class_815)conditions.get(i), filter);
                if (conditionFactoryPair == null) continue;
                conditions.remove(conditionFactoryPair.condition());
                return new ConditionFactoryPair(conditionFactoryPair.condition(), condition1 -> {
                    conditions.add((class_815)conditionFactoryPair.factory().apply((class_815)condition1));
                    return new class_821((Iterable)conditions);
                });
            }
        }
        return null;
    }

    private static Map<EightWayDirection, class_815> rotateCenterConditions() {
        HashMap conditions = Maps.newHashMap();
        for (EightWayDirection direction : EightWayDirection.getCardinalDirections()) {
            if (direction.getX() != 1 && direction.getZ() != 1) continue;
            EightWayDirection interDirection = direction.rotateClockWise();
            class_815 newCondition = MultipartAppender.getAndCondition(interDirection, interDirection.getOpposite());
            conditions.put(direction, newCondition);
        }
        return conditions;
    }

    private static class_815 negateCondition(class_815 condition) {
        return stateDefinition -> condition.getPredicate(stateDefinition).negate();
    }

    private static class_815 getAndCondition(EightWayDirection ... directions) {
        ArrayList conditions = Lists.newArrayList();
        for (EightWayDirection direction : EightWayDirection.values()) {
            String value = ArrayUtils.contains((Object[])directions, (Object)((Object)direction)) ? "true" : "false";
            conditions.add(new class_818(direction.method_15434(), value));
        }
        return new class_812((Iterable)conditions);
    }

    private static void appendNewSelector(BiConsumer<class_2960, class_1100> modelAdder, class_815 newCondition, class_819 selector, EightWayDirection direction, List<class_819> newSelectors) {
        EightWayDirection interDirection = direction.rotateClockWise();
        List variants = selector.method_3529().method_3497();
        ArrayList newVariants = Lists.newArrayList();
        for (class_813 variant : variants) {
            class_2960 location = new class_2960(variant.method_3510() + "_" + interDirection.method_15434());
            modelAdder.accept(location, new RotatedVariant(variant, direction.toDirection()));
            newVariants.add(new class_813(location, variant.method_3509(), variant.method_3512(), variant.method_3511()));
        }
        newSelectors.add(new class_819(newCondition, new class_807((List)newVariants)));
    }

    public static class_1087 rotateMultipartSegment(@Nullable class_2680 state, class_1087 segmentModel, class_2350 armDir) {
        HashMap<class_2350, List<class_777>> quadMap = new HashMap<class_2350, List<class_777>>();
        MultipartAppender.rotateQuads(quadMap, state, segmentModel, null, armDir);
        for (class_2350 cullFace : class_2350.values()) {
            MultipartAppender.rotateQuads(quadMap, state, segmentModel, cullFace, armDir);
        }
        return ClientAbstractions.INSTANCE.createWrappedBakedModel(segmentModel, quadMap);
    }

    private static void rotateQuads(Map<class_2350, List<class_777>> quadMap, @Nullable class_2680 state, class_1087 segmentModel, class_2350 cullFace, class_2350 segmentDir) {
        List quads = segmentModel.method_4707(state, cullFace, class_5819.method_43047());
        ArrayList newQuads = Lists.newArrayList();
        for (class_777 quad : quads) {
            class_777 copy = QuadUtils.duplicateQuad(quad);
            QuadUtils.rotateQuad(copy, segmentDir);
            newQuads.add(copy);
        }
        quadMap.put(cullFace, newQuads);
    }

    private record ConditionFactoryPair(class_818 condition, UnaryOperator<class_815> factory) {
    }
}

