/*
 * Decompiled with CFR 0.152.
 */
package fuzs.diagonalblocks.client.resources.model;

import net.minecraft.class_2350;
import net.minecraft.class_777;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;
import org.joml.Vector4fc;

public class QuadUtils {
    private static final float ROTATION_ANGLE = -0.7853982f;
    private static final float SCALE_ROTATION_45 = 1.0f / (float)Math.cos(0.7853981633974483) - 1.0f;
    private static final Vector3f ROTATION_ORIGIN = new Vector3f(0.5f, 0.5f, 0.5f);
    private static final Matrix4f ROTATION_MATRIX = new Matrix4f().rotation((Quaternionfc)new Quaternionf().setAngleAxis(-0.7853982f, 0.0f, 1.0f, 0.0f));

    public static class_777 duplicateQuad(class_777 quad) {
        int[] vertexData = new int[quad.method_3357().length];
        System.arraycopy(quad.method_3357(), 0, vertexData, 0, vertexData.length);
        return new class_777(vertexData, quad.method_3359(), quad.method_3358(), quad.method_35788(), quad.method_24874());
    }

    public static void rotateQuad(class_777 quad, class_2350 dir) {
        Vector3f scaleMult = new Vector3f((float)Math.abs(dir.method_10148()), 1.0f, (float)Math.abs(dir.method_10165()));
        Vector3f scaleVec = new Vector3f(1.0f, 0.0f, 1.0f);
        scaleVec.mul(SCALE_ROTATION_45);
        scaleVec.mul(scaleMult.x(), scaleMult.y(), scaleMult.z());
        scaleVec.add(1.0f, 1.0f, 1.0f);
        int[] vertexData = quad.method_3357();
        float[][] pos = QuadUtils.unpackQuadPosition(vertexData);
        for (int i = 0; i < 4; ++i) {
            Vector4f vector4f = new Vector4f(pos[i][0] - ROTATION_ORIGIN.x(), pos[i][1] - ROTATION_ORIGIN.y(), pos[i][2] - ROTATION_ORIGIN.z(), 1.0f);
            vector4f.mul((Vector4fc)new Vector4f((Vector3fc)scaleVec, 1.0f));
            ROTATION_MATRIX.transform(vector4f);
            pos[i][0] = vector4f.x() + ROTATION_ORIGIN.x();
            pos[i][1] = vector4f.y() + ROTATION_ORIGIN.y();
            pos[i][2] = vector4f.z() + ROTATION_ORIGIN.z();
        }
        QuadUtils.packQuadPositions(vertexData, pos);
        QuadUtils.fillNormal(vertexData, pos);
    }

    public static float[][] unpackQuadPosition(int[] vertexData) {
        float[][] pos = new float[4][3];
        int step = vertexData.length / 4;
        for (int i = 0; i < 4; ++i) {
            int offset = i * step;
            pos[i][0] = Float.intBitsToFloat(vertexData[offset]);
            pos[i][1] = Float.intBitsToFloat(vertexData[offset + 1]);
            pos[i][2] = Float.intBitsToFloat(vertexData[offset + 2]);
        }
        return pos;
    }

    public static void packQuadPositions(int[] vertexData, float[][] pos) {
        int step = vertexData.length / 4;
        for (int i = 0; i < 4; ++i) {
            int offset = i * step;
            vertexData[offset] = Float.floatToIntBits(pos[i][0]);
            vertexData[offset + 1] = Float.floatToIntBits(pos[i][1]);
            vertexData[offset + 2] = Float.floatToIntBits(pos[i][2]);
        }
    }

    public static void fillNormal(int[] vertexData, float[][] pos) {
        Vector3f v1 = new Vector3f(pos[3][0], pos[3][1], pos[3][2]);
        Vector3f t1 = new Vector3f(pos[1][0], pos[1][1], pos[1][2]);
        Vector3f v2 = new Vector3f(pos[2][0], pos[2][1], pos[2][2]);
        Vector3f t2 = new Vector3f(pos[0][0], pos[0][1], pos[0][2]);
        v1.sub((Vector3fc)t1);
        v2.sub((Vector3fc)t2);
        v2.cross((Vector3fc)v1);
        v2.normalize();
        int x = (byte)Math.round(v2.x() * 127.0f) & 0xFF;
        int y = (byte)Math.round(v2.y() * 127.0f) & 0xFF;
        int z = (byte)Math.round(v2.z() * 127.0f) & 0xFF;
        int normal = x | y << 8 | z << 16;
        int step = vertexData.length / 4;
        for (int vert = 0; vert < 4; ++vert) {
            vertexData[vert * step + 7] = normal;
        }
    }
}

