/*
 * Decompiled with CFR 0.152.
 */
package fuzs.diagonalblocks.handler;

import com.google.common.collect.BiMap;
import fuzs.diagonalblocks.api.v2.DiagonalBlockType;
import fuzs.puzzleslib.api.block.v1.BlockConversionHelper;
import fuzs.puzzleslib.api.event.v1.RegistryEntryAddedCallback;
import fuzs.puzzleslib.api.init.v3.registry.RegistryHelper;
import java.util.Map;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_7923;

public class DiagonalBlockHandler {
    public static RegistryEntryAddedCallback<class_2248> onBlockAdded(DiagonalBlockType type) {
        return (registry, id, entry, registrar) -> {
            if (type.isTarget(id, (class_2248)entry)) {
                class_2960 resourceLocation = type.id(id.method_12836() + "/" + id.method_12832());
                registrar.accept(resourceLocation, () -> type.makeDiagonalBlock(id, (class_2248)entry));
            }
        };
    }

    public static void onTagsUpdated(class_5455 registryAccess, boolean client) {
        for (Map.Entry entry : class_7923.field_41178.method_29722()) {
            Object v = entry.getValue();
            if (!(v instanceof class_1747)) continue;
            class_1747 blockItem = (class_1747)v;
            class_2248 block = blockItem.method_7711();
            DiagonalBlockHandler.setItemForBlock(((class_5321)entry.getKey()).method_29177(), blockItem, block);
            DiagonalBlockHandler.setBlockForItem(blockItem, block);
        }
        DiagonalBlockHandler.copyBoundTags();
    }

    private static void setItemForBlock(class_2960 resourceLocation, class_1747 blockItem, class_2248 block) {
        for (DiagonalBlockType type : DiagonalBlockType.TYPES) {
            if (!type.isTarget(resourceLocation, block)) continue;
            BlockConversionHelper.setItemForBlock((class_2248)((class_2248)type.getBlockConversions().get((Object)block)), (class_1792)blockItem);
            break;
        }
    }

    private static void setBlockForItem(class_1747 blockItem, class_2248 block) {
        for (DiagonalBlockType type : DiagonalBlockType.TYPES) {
            class_2248 baseBlock;
            BiMap<class_2248, class_2248> conversions = type.getBlockConversions();
            class_2248 diagonalBlock = (class_2248)conversions.get((Object)block);
            if (diagonalBlock != null) {
                baseBlock = block;
            } else {
                baseBlock = (class_2248)conversions.inverse().get((Object)block);
                if (baseBlock == null) continue;
                diagonalBlock = block;
            }
            if (RegistryHelper.is(type.getBlacklistTagKey(), (Object)baseBlock)) {
                BlockConversionHelper.setBlockForItem((class_1747)blockItem, (class_2248)baseBlock);
                break;
            }
            BlockConversionHelper.setBlockForItem((class_1747)blockItem, (class_2248)diagonalBlock);
            break;
        }
    }

    private static void copyBoundTags() {
        for (DiagonalBlockType type : DiagonalBlockType.TYPES) {
            type.getBlockConversions().forEach(BlockConversionHelper::copyBoundTags);
        }
    }
}

