/*
 * Decompiled with CFR 0.152.
 */
package net.bettercombat;

import com.mojang.logging.LogUtils;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.serializer.ConfigSerializer;
import me.shedaniel.autoconfig.serializer.JanksonConfigSerializer;
import me.shedaniel.autoconfig.serializer.PartitioningSerializer;
import net.bettercombat.compatibility.CompatibilityFlags;
import net.bettercombat.config.FallbackConfig;
import net.bettercombat.config.ServerConfig;
import net.bettercombat.config.ServerConfigWrapper;
import net.bettercombat.logic.WeaponAttributesFallback;
import net.bettercombat.logic.WeaponRegistry;
import net.minecraft.server.MinecraftServer;
import net.tinyconfig.ConfigManager;
import org.slf4j.Logger;

public class BetterCombatMod {
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final String ID = "bettercombat";
    public static ServerConfig config;
    private static FallbackConfig fallbackDefault;
    public static ConfigManager<FallbackConfig> fallbackConfig;

    public static void init() {
        AutoConfig.register(ServerConfigWrapper.class, (ConfigSerializer.Factory)PartitioningSerializer.wrap(JanksonConfigSerializer::new));
        config = ((ServerConfigWrapper)AutoConfig.getConfigHolder(ServerConfigWrapper.class).getConfig()).server;
        BetterCombatMod.loadFallbackConfig();
        CompatibilityFlags.initialize();
    }

    private static void loadFallbackConfig() {
        fallbackConfig.load();
        if (BetterCombatMod.fallbackConfig.value == null) {
            BetterCombatMod.fallbackConfig.value = FallbackConfig.createDefault();
        }
        if (((FallbackConfig)BetterCombatMod.fallbackConfig.value).schema_version < BetterCombatMod.fallbackDefault.schema_version) {
            BetterCombatMod.fallbackConfig.value = FallbackConfig.migrate((FallbackConfig)BetterCombatMod.fallbackConfig.value, FallbackConfig.createDefault());
        }
        fallbackConfig.save();
    }

    public static void loadWeaponAttributes(MinecraftServer server) {
        WeaponRegistry.loadAttributes(server.method_34864());
        if (BetterCombatMod.config.fallback_compatibility_enabled) {
            WeaponAttributesFallback.initialize();
        }
        WeaponRegistry.encodeRegistry();
    }

    static {
        fallbackDefault = FallbackConfig.createDefault();
        fallbackConfig = new ConfigManager<FallbackConfig>("fallback_compatibility", fallbackDefault).builder().setDirectory(ID).sanitize(true).build();
    }
}

