/*
 * Decompiled with CFR 0.152.
 */
package net.bettercombat.logic;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.mojang.logging.LogUtils;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.bettercombat.BetterCombatMod;
import net.bettercombat.Platform;
import net.bettercombat.api.AttributesContainer;
import net.bettercombat.api.WeaponAttributes;
import net.bettercombat.api.WeaponAttributesHelper;
import net.bettercombat.network.Packets;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_7923;
import org.slf4j.Logger;

public class WeaponRegistry {
    static final Logger LOGGER = LogUtils.getLogger();
    static Map<class_2960, WeaponAttributes> registrations = new HashMap<class_2960, WeaponAttributes>();
    static Map<class_2960, AttributesContainer> containers = new HashMap<class_2960, AttributesContainer>();
    private static Packets.WeaponRegistrySync encodedRegistrations = new Packets.WeaponRegistrySync(List.of());

    public static void register(class_2960 itemId, WeaponAttributes attributes) {
        registrations.put(itemId, attributes);
    }

    static WeaponAttributes getAttributes(class_2960 itemId) {
        return registrations.get(itemId);
    }

    public static WeaponAttributes getAttributes(class_1799 itemStack) {
        WeaponAttributes attributes;
        if (itemStack == null) {
            return null;
        }
        if (itemStack.method_7985() && (attributes = WeaponAttributesHelper.readFromNBT(itemStack)) != null) {
            return attributes;
        }
        class_1792 item = itemStack.method_7909();
        class_2960 id = class_7923.field_41178.method_10221((Object)item);
        WeaponAttributes attributes2 = WeaponRegistry.getAttributes(id);
        return attributes2;
    }

    public static void loadAttributes(class_3300 resourceManager) {
        WeaponRegistry.loadContainers(resourceManager);
        containers.forEach((itemId, container) -> {
            if (!class_7923.field_41178.method_10250(itemId)) {
                return;
            }
            WeaponRegistry.resolveAndRegisterAttributes(itemId, container);
        });
    }

    private static void loadContainers(class_3300 resourceManager) {
        Gson gson = new Gson();
        HashMap<class_2960, AttributesContainer> containers = new HashMap<class_2960, AttributesContainer>();
        for (Map.Entry entry : resourceManager.method_14488("weapon_attributes", fileName -> fileName.method_12832().endsWith(".json")).entrySet()) {
            class_2960 identifier = (class_2960)entry.getKey();
            class_3298 resource = (class_3298)entry.getValue();
            try {
                JsonReader reader = new JsonReader((Reader)new InputStreamReader(resource.method_14482()));
                AttributesContainer container = WeaponAttributesHelper.decode(reader);
                String id = identifier.toString().replace("weapon_attributes/", "");
                id = id.substring(0, id.lastIndexOf(46));
                containers.put(new class_2960(id), container);
            }
            catch (Exception e) {
                System.err.println("Failed to parse: " + identifier);
                e.printStackTrace();
            }
        }
        WeaponRegistry.containers = containers;
    }

    public static WeaponAttributes resolveAttributes(class_2960 itemId, AttributesContainer container) {
        try {
            ArrayList<WeaponAttributes> resolutionChain = new ArrayList<WeaponAttributes>();
            AttributesContainer current = container;
            while (current != null) {
                resolutionChain.add(0, current.attributes());
                if (current.parent() != null) {
                    current = containers.get(new class_2960(current.parent()));
                    continue;
                }
                current = null;
            }
            WeaponAttributes empty = new WeaponAttributes(0.0, null, null, false, null, null);
            WeaponAttributes resolvedAttributes = resolutionChain.stream().reduce(empty, (a, b) -> {
                if (b == null) {
                    return a;
                }
                return WeaponAttributesHelper.override(a, b);
            });
            WeaponAttributesHelper.validate(resolvedAttributes);
            return resolvedAttributes;
        }
        catch (Exception e) {
            LOGGER.error("Failed to resolve weapon attributes for: " + itemId + ". Reason: " + e.getMessage());
            e.printStackTrace();
            return null;
        }
    }

    public static void resolveAndRegisterAttributes(class_2960 itemId, AttributesContainer container) {
        WeaponAttributes resolvedAttributes = WeaponRegistry.resolveAttributes(itemId, container);
        if (resolvedAttributes != null) {
            WeaponRegistry.register(itemId, resolvedAttributes);
        }
    }

    public static void encodeRegistry() {
        Gson gson = new Gson();
        String json = gson.toJson(registrations);
        if (BetterCombatMod.config.weapon_registry_logging) {
            LOGGER.info("Weapon Attribute registry loaded: " + json);
        }
        ArrayList<String> chunks = new ArrayList<String>();
        int chunkSize = 10000;
        for (int i = 0; i < json.length(); i += chunkSize) {
            chunks.add(json.substring(i, Math.min(json.length(), i + chunkSize)));
        }
        encodedRegistrations = new Packets.WeaponRegistrySync(chunks);
        class_2540 buffer = Platform.createByteBuffer();
        encodedRegistrations.method_53028(buffer);
        LOGGER.info("Encoded Weapon Attribute registry size (with package overhead): " + buffer.readableBytes() + " bytes (in " + chunks.size() + " string chunks with the size of " + chunkSize + ")");
    }

    public static void decodeRegistry(Packets.WeaponRegistrySync syncPacket) {
        String json = "";
        for (String chunk : syncPacket.chunks()) {
            json = json.concat(chunk);
        }
        LOGGER.info("Decoded Weapon Attribute registry in " + syncPacket.chunks().size() + " string chunks");
        if (BetterCombatMod.config.weapon_registry_logging) {
            LOGGER.info("Weapon Attribute registry received: " + json);
        }
        Gson gson = new Gson();
        Type mapType = new TypeToken<Map<String, WeaponAttributes>>(){}.getType();
        Map readRegistrations = (Map)gson.fromJson(json, mapType);
        HashMap<class_2960, WeaponAttributes> newRegistrations = new HashMap<class_2960, WeaponAttributes>();
        readRegistrations.forEach((key, value) -> newRegistrations.put(new class_2960(key), (WeaponAttributes)value));
        registrations = newRegistrations;
    }

    public static Packets.WeaponRegistrySync getEncodedRegistry() {
        return encodedRegistrations;
    }
}

