/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_model_features.models.animation.math.variables.factories;

import org.jetbrains.annotations.Nullable;
import traben.entity_model_features.models.animation.EMFAnimation;
import traben.entity_model_features.models.animation.math.MathValue;
import traben.entity_model_features.models.animation.math.variables.EMFModelOrRenderVariable;
import traben.entity_model_features.models.animation.math.variables.factories.UniqueVariableFactory;
import traben.entity_model_features.utils.EMFUtils;

public class RenderVariableFactory
extends UniqueVariableFactory {
    @Override
    public MathValue.ResultSupplier getSupplierOrNull(String variableKey, EMFAnimation calculationInstance) {
        EMFAnimation renderVariableCalculator = (EMFAnimation)calculationInstance.temp_emfAnimationVariables.get((Object)variableKey);
        if (renderVariableCalculator != null) {
            return renderVariableCalculator::getLastResultOnly;
        }
        EMFModelOrRenderVariable variable = EMFModelOrRenderVariable.getRenderVariable(variableKey);
        if (variable != null && variable.isRenderVariable()) {
            return variable::getValue;
        }
        EMFUtils.logWarn("no render variable found for: [" + variableKey + "]");
        return null;
    }

    @Override
    public boolean createsThisVariable(String variableKey) {
        if (variableKey == null) {
            return false;
        }
        return variableKey.matches("(render)\\.\\w+");
    }

    @Override
    @Nullable
    public String getExplanationTranslationKey() {
        return "entity_model_features.config.variable_explanation.render_variable";
    }

    @Override
    @Nullable
    public String getTitleTranslationKey() {
        return "entity_model_features.config.variable_explanation.render_variable.title";
    }
}

