/*
 * Decompiled with CFR 0.152.
 */
package com.anthonyhilyard.legendarytooltips;

import com.anthonyhilyard.iceberg.events.RenderTickEvents;
import com.anthonyhilyard.iceberg.events.RenderTooltipEvents;
import com.anthonyhilyard.iceberg.util.StringRecomposer;
import com.anthonyhilyard.iceberg.util.Tooltips;
import com.anthonyhilyard.legendarytooltips.config.FrameResourceParser;
import com.anthonyhilyard.legendarytooltips.config.LegacyConfigConverter;
import com.anthonyhilyard.legendarytooltips.config.LegendaryTooltipsConfig;
import com.anthonyhilyard.legendarytooltips.tooltip.ItemModelComponent;
import com.anthonyhilyard.legendarytooltips.tooltip.PaddingComponent;
import com.anthonyhilyard.legendarytooltips.tooltip.TooltipDecor;
import com.anthonyhilyard.prism.item.ItemColors;
import com.anthonyhilyard.prism.text.DynamicColor;
import com.mojang.datafixers.util.Either;
import fuzs.forgeconfigapiport.api.config.v2.ForgeConfigRegistry;
import fuzs.forgeconfigapiport.api.config.v2.ModConfigEvents;
import java.util.List;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.minecraft.class_124;
import net.minecraft.class_1269;
import net.minecraft.class_1799;
import net.minecraft.class_2477;
import net.minecraft.class_2583;
import net.minecraft.class_2588;
import net.minecraft.class_310;
import net.minecraft.class_3264;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_465;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_5251;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_5632;
import net.minecraft.class_5684;
import net.minecraft.class_7417;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;

public class LegendaryTooltips
implements ClientModInitializer {
    public static final int STANDARD = -1;
    public static final int NO_BORDER = -2;
    public static final int NUM_FRAMES = 16;
    private static class_1799 lastTooltipItem = null;

    public void onInitializeClient() {
        LegacyConfigConverter.convert();
        ForgeConfigRegistry.INSTANCE.register("legendarytooltips", ModConfig.Type.COMMON, (IConfigSpec)LegendaryTooltipsConfig.SPEC);
        ItemModelComponent.registerFactory();
        PaddingComponent.registerFactory();
        RenderTooltipEvents.GATHER.register(LegendaryTooltips::onGatherComponentsEvent);
        RenderTooltipEvents.COLOREXT.register(LegendaryTooltips::onTooltipColorEvent);
        RenderTooltipEvents.POSTEXT.register(LegendaryTooltips::onPostTooltipEvent);
        RenderTickEvents.START.register(LegendaryTooltips::onRenderTick);
        ModConfigEvents.reloading((String)"legendarytooltips").register(LegendaryTooltipsConfig::onReload);
        ResourceManagerHelper.get((class_3264)class_3264.field_14188).registerReloadListener((IdentifiableResourceReloadListener)FrameResourceParser.INSTANCE);
    }

    public static LegendaryTooltipsConfig.FrameDefinition getDefinitionColors(class_1799 item, int defaultStartBorder, int defaultEndBorder, int defaultStartBackground, int defaultEndBackground) {
        LegendaryTooltipsConfig.FrameDefinition result = LegendaryTooltipsConfig.INSTANCE.getFrameDefinition(item);
        switch (result.index()) {
            case -2: {
                result = new LegendaryTooltipsConfig.FrameDefinition(result.resource(), result.index(), () -> defaultStartBorder, () -> defaultEndBorder, () -> defaultStartBackground, () -> defaultEndBackground, LegendaryTooltipsConfig.FrameSource.NONE, 0);
                break;
            }
            case -1: {
                if (!((Boolean)LegendaryTooltipsConfig.INSTANCE.bordersMatchRarity.get()).booleanValue()) break;
                DynamicColor rarityColor = DynamicColor.fromRgb((int)ItemColors.getColorForItem((class_1799)item, (class_5251)class_5251.method_27718((class_124)class_124.field_1068)).method_27716());
                int hue = rarityColor.hue();
                boolean addHue = false;
                if (hue >= 62 && hue <= 240) {
                    addHue = true;
                }
                int startHue = addHue ? hue - 4 : hue + 4;
                int endHue = addHue ? hue + 18 : hue - 18;
                int startBGHue = addHue ? hue - 3 : hue + 3;
                int endBGHue = addHue ? hue + 13 : hue - 13;
                startHue = (startHue + 360) % 360;
                endHue = (endHue + 360) % 360;
                startBGHue = (startBGHue + 360) % 360;
                endBGHue = (endBGHue + 360) % 360;
                DynamicColor startColor = DynamicColor.fromAHSV((int)255, (int)startHue, (int)rarityColor.saturation(), (int)rarityColor.value());
                DynamicColor endColor = DynamicColor.fromAHSV((int)255, (int)endHue, (int)rarityColor.saturation(), (int)((int)((float)rarityColor.value() * 0.95f)));
                DynamicColor startBGColor = DynamicColor.fromAHSV((int)228, (int)startBGHue, (int)((int)((float)rarityColor.saturation() * 0.9f)), (int)14);
                DynamicColor endBGColor = DynamicColor.fromAHSV((int)253, (int)endBGHue, (int)((int)((float)rarityColor.saturation() * 0.8f)), (int)18);
                result = new LegendaryTooltipsConfig.FrameDefinition(result.resource(), result.index(), () -> startColor.method_27716(), () -> endColor.method_27716(), () -> startBGColor.method_27716(), () -> endBGColor.method_27716(), LegendaryTooltipsConfig.FrameSource.NONE, 0);
            }
        }
        if (result.startBorder() == null) {
            result = new LegendaryTooltipsConfig.FrameDefinition(result.resource(), result.index(), () -> defaultStartBorder, result.endBorder(), result.startBackground(), result.endBackground(), LegendaryTooltipsConfig.FrameSource.NONE, 0);
        }
        if (result.endBorder() == null) {
            result = new LegendaryTooltipsConfig.FrameDefinition(result.resource(), result.index(), result.startBorder(), () -> defaultEndBorder, result.startBackground(), result.endBackground(), LegendaryTooltipsConfig.FrameSource.NONE, 0);
        }
        if (result.startBackground() == null) {
            result = new LegendaryTooltipsConfig.FrameDefinition(result.resource(), result.index(), result.startBorder(), result.endBorder(), () -> defaultStartBackground, result.endBackground(), LegendaryTooltipsConfig.FrameSource.NONE, 0);
        }
        if (result.endBackground() == null) {
            result = new LegendaryTooltipsConfig.FrameDefinition(result.resource(), result.index(), result.startBorder(), result.endBorder(), result.startBackground(), () -> defaultEndBackground, LegendaryTooltipsConfig.FrameSource.NONE, 0);
        }
        return result;
    }

    public static RenderTooltipEvents.GatherResult onGatherComponentsEvent(class_1799 itemStack, int screenWidth, int screenHeight, List<Either<class_5348, class_5632>> tooltipElements, int maxWidth, int index) {
        if (((Boolean)LegendaryTooltipsConfig.INSTANCE.compactTooltips.get()).booleanValue()) {
            for (int i = 0; i < tooltipElements.size(); ++i) {
                class_2588 contents;
                class_5250 component;
                class_7417 class_74172;
                class_5348 text;
                if (!tooltipElements.get(i).left().isPresent() || !((text = (class_5348)tooltipElements.get(i).left().get()) instanceof class_5250) || !((class_74172 = (component = (class_5250)text).method_10851()) instanceof class_2588) || !(contents = (class_2588)class_74172).method_11022().startsWith("item.modifiers.")) continue;
                tooltipElements.remove(i);
                if ((tooltipElements.size() <= i - 1 || i <= 0 || !tooltipElements.get(i - 1).right().isPresent() || tooltipElements.get(i - 1).right().get() != class_5244.field_39003) && (!tooltipElements.get(i - 1).left().isPresent() || !((class_5348)tooltipElements.get(i - 1).left().get()).getString().isEmpty())) break;
                tooltipElements.remove(i - 1);
                break;
            }
        }
        if (LegendaryTooltipsConfig.showModelForItem(itemStack) && !tooltipElements.isEmpty() && tooltipElements.get(0).left().isPresent()) {
            class_5348 title = (class_5348)tooltipElements.get(0).left().get();
            class_5481 paddedTitle = class_5481.method_30755(List.of(class_5481.method_30747((String)"      ", (class_2583)class_2583.field_24360), class_2477.method_10517().method_30934(title), class_5481.method_30747((String)" ", (class_2583)class_2583.field_24360)));
            List recomposedTitle = StringRecomposer.recompose(List.of(class_5684.method_32662((class_5481)paddedTitle)));
            if (!recomposedTitle.isEmpty()) {
                tooltipElements.set(0, (Either<class_5348, class_5632>)Either.left((Object)((class_5348)recomposedTitle.get(0))));
                tooltipElements.add(0, (Either<class_5348, class_5632>)Either.right((Object)new ItemModelComponent(itemStack)));
                if (tooltipElements.stream().filter(x -> !x.right().isPresent() || !(x.right().get() instanceof Tooltips.TitleBreakComponent)).count() == 2L) {
                    tooltipElements.add(2, (Either<class_5348, class_5632>)Either.right((Object)new PaddingComponent(6)));
                } else {
                    tooltipElements.add(2, (Either<class_5348, class_5632>)Either.left((Object)class_5348.method_29430((String)" ")));
                }
            }
        }
        return new RenderTooltipEvents.GatherResult(class_1269.field_5811, maxWidth, tooltipElements);
    }

    public static void onRenderTick(float partialTick) {
        class_437 class_4372;
        class_310 mc = class_310.method_1551();
        float deltaTime = mc.method_1534() / 50.0f;
        TooltipDecor.updateTimer(deltaTime);
        ItemModelComponent.updateTimer(deltaTime);
        if (mc.field_1755 != null && (class_4372 = mc.field_1755) instanceof class_465) {
            class_1799 item;
            class_465 containerScreen = (class_465)class_4372;
            if (containerScreen.field_2787 != null && containerScreen.field_2787.method_7681() && lastTooltipItem != (item = containerScreen.field_2787.method_7677())) {
                TooltipDecor.resetTimer();
                lastTooltipItem = item;
            }
        }
    }

    public static RenderTooltipEvents.ColorExtResult onTooltipColorEvent(class_1799 stack, class_332 graphics, int x, int y, class_327 font, int backgroundStart, int backgroundEnd, int borderStart, int borderEnd, List<class_5684> components, boolean comparison, int index) {
        LegendaryTooltipsConfig.FrameDefinition frameDefinition = LegendaryTooltips.getDefinitionColors(stack, borderStart, borderEnd, backgroundStart, backgroundEnd);
        TooltipDecor.setCurrentTooltipBorderStart(frameDefinition.startBorder().get());
        TooltipDecor.setCurrentTooltipBorderEnd(frameDefinition.endBorder().get());
        TooltipDecor.setCurrentTooltipBackgroundStart(frameDefinition.startBackground().get());
        TooltipDecor.setCurrentTooltipBackgroundEnd(frameDefinition.endBackground().get());
        RenderTooltipEvents.ColorExtResult result = comparison ? new RenderTooltipEvents.ColorExtResult(frameDefinition.startBackground().get().intValue(), frameDefinition.endBackground().get().intValue(), 0, 0) : new RenderTooltipEvents.ColorExtResult(frameDefinition.startBackground().get().intValue(), frameDefinition.endBackground().get().intValue(), frameDefinition.startBorder().get().intValue(), frameDefinition.endBorder().get().intValue());
        return result;
    }

    public static void onPostTooltipEvent(class_1799 itemStack, class_332 graphics, int x, int y, class_327 font, int width, int height, List<class_5684> components, boolean comparison, int index) {
        if (LegendaryTooltipsConfig.INSTANCE.getFrameDefinition(itemStack).index() == -2) {
            return;
        }
        class_4587 poseStack = graphics.method_51448();
        if (((Boolean)LegendaryTooltipsConfig.INSTANCE.tooltipShadow.get()).booleanValue()) {
            if (comparison) {
                TooltipDecor.drawShadow(poseStack, x, y - 11, width, height + 11);
            } else {
                TooltipDecor.drawShadow(poseStack, x, y, width, height);
            }
        }
        if (comparison) {
            TooltipDecor.drawBorder(poseStack, x, y - 11, width, height + 11, itemStack, components, font, LegendaryTooltipsConfig.INSTANCE.getFrameDefinition(itemStack), comparison, index);
        } else {
            TooltipDecor.drawBorder(poseStack, x, y, width, height, itemStack, components, font, LegendaryTooltipsConfig.INSTANCE.getFrameDefinition(itemStack), comparison, index);
        }
    }
}

