/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.lavendermd.feature;

import io.wispforest.lavendermd.Lexer;
import io.wispforest.lavendermd.MarkdownFeature;
import io.wispforest.lavendermd.Parser;
import io.wispforest.lavendermd.compiler.MarkdownCompiler;
import net.minecraft.class_124;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import org.jetbrains.annotations.NotNull;

public class LinkFeature
implements MarkdownFeature {
    @Override
    public String name() {
        return "links";
    }

    @Override
    public boolean supportsCompiler(MarkdownCompiler<?> compiler) {
        return true;
    }

    @Override
    public void registerTokens(MarkdownFeature.TokenRegistrar registrar) {
        registrar.registerToken(Lexer.Token.lexFromChar(OpenLinkToken::new), '[');
        registrar.registerToken((nibbler, tokens) -> {
            nibbler.skip();
            if (!nibbler.tryConsume('(')) {
                return false;
            }
            String link = nibbler.consumeUntil(')');
            if (link == null) {
                return false;
            }
            tokens.add(new CloseLinkToken(link));
            return true;
        }, ']');
    }

    @Override
    public void registerNodes(MarkdownFeature.NodeRegistrar registrar) {
        registrar.registerNode((parser, left, tokens) -> {
            int pointer = tokens.pointer();
            Parser.Node content = parser.parseUntil(tokens, CloseLinkToken.class);
            Object patt1426$temp = tokens.peek();
            if (patt1426$temp instanceof CloseLinkToken) {
                CloseLinkToken right = (CloseLinkToken)patt1426$temp;
                tokens.nibble();
                return new Parser.FormattingNode(style -> style.method_10958(new class_2558(class_2558.class_2559.field_11749, right.link)).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43470((String)right.link))).method_10977(class_124.field_1078)).addChild(content);
            }
            tokens.setPointer(pointer);
            return new Parser.TextNode(left.content());
        }, (token, tokens) -> {
            OpenLinkToken link;
            return token instanceof OpenLinkToken ? (link = (OpenLinkToken)token) : null;
        });
    }

    private static final class OpenLinkToken
    extends Lexer.Token {
        public OpenLinkToken() {
            super("[");
        }
    }

    private static final class CloseLinkToken
    extends Lexer.Token {
        @NotNull
        public final String link;

        public CloseLinkToken(@NotNull String link) {
            super("](" + link + ")");
            this.link = link;
        }
    }
}

