/*
 * Decompiled with CFR 0.152.
 */
package dev.lambdaurora.spruceui.widget.text;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import dev.lambdaurora.spruceui.Position;
import dev.lambdaurora.spruceui.border.Border;
import dev.lambdaurora.spruceui.navigation.NavigationDirection;
import dev.lambdaurora.spruceui.util.MultilineText;
import dev.lambdaurora.spruceui.widget.text.AbstractSpruceTextInputWidget;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_155;
import net.minecraft.class_2561;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_437;
import net.minecraft.class_757;
import org.jetbrains.annotations.Nullable;

public class SpruceTextAreaWidget
extends AbstractSpruceTextInputWidget {
    private final class_327 textRenderer;
    private final MultilineText lines;
    private final Cursor cursor = new Cursor(true);
    private final Selection selection = new Selection();
    private int firstLine = 0;
    private int displayedLines;

    public SpruceTextAreaWidget(Position position, int width, int height, class_2561 title) {
        super(position, width, height, title);
        this.textRenderer = this.client.field_1772;
        int n = this.getInnerHeight();
        Objects.requireNonNull(this.textRenderer);
        this.displayedLines = n / 9;
        this.lines = new MultilineText(this.getInnerWidth());
        this.cursor.toStart();
        this.sanitize();
    }

    public List<String> getLines() {
        return this.lines.getLines();
    }

    public void setLines(List<String> lines) {
        this.lines.setLines(lines);
        this.selection.active = false;
        this.setCursorToEnd();
    }

    @Override
    public String getText() {
        return this.lines.getText();
    }

    @Override
    public void setText(@Nullable String text) {
        this.lines.clear();
        if (text != null) {
            this.lines.setText(text);
        }
    }

    public void clear() {
        this.lines.clear();
        this.sanitize();
    }

    public boolean isEditable() {
        return this.isActive();
    }

    public void setEditable(boolean editable) {
        this.setActive(editable);
    }

    public void setDisplayedLines(int lines) {
        if (lines <= 0) {
            lines = 1;
        }
        this.displayedLines = lines;
        this.cursor.adjustFirstLine();
    }

    @Override
    public void setBorder(Border border) {
        super.setBorder(border);
        this.lines.setWidth(this.getInnerWidth());
        this.sanitize();
    }

    @Override
    public void setCursorToStart() {
        this.cursor.toStart();
    }

    @Override
    public void setCursorToEnd() {
        this.cursor.toEnd();
    }

    private void insertCharacter(char character) {
        String line;
        if (this.lines.isEmpty()) {
            this.lines.add(String.valueOf(character));
            this.setCursorToStart();
            return;
        }
        this.selection.erase();
        if (character == '\n' && this.cursor.row == this.lines.size() - 1 && (line = this.lines.get(this.cursor.row)) != null && this.cursor.column >= line.length() - 1) {
            int currentRow = this.cursor.row;
            if (!line.endsWith("\n")) {
                this.lines.replaceRow(currentRow, s -> s + "\n");
            }
            this.lines.add(currentRow + 1, "");
            this.cursor.moveDown();
            return;
        }
        String text = this.getText();
        int cursorPosition = this.cursor.getPosition();
        int oldSize = this.lines.size();
        String newText = cursorPosition >= text.length() ? text + character : text.substring(0, cursorPosition) + character + text.substring(cursorPosition);
        this.lines.clear();
        this.lines.add(newText);
        if (character == '\n') {
            this.cursor.moveRight();
        } else {
            this.cursor.moveRight();
            if (oldSize + 1 == this.lines.size()) {
                this.cursor.moveRight();
            }
        }
    }

    private void eraseCharacter() {
        if (this.selection.erase()) {
            this.sanitize();
            return;
        }
        String line = this.lines.get(this.cursor.row);
        if ((line.isEmpty() || line.equals("\n")) && this.lines.size() != 1) {
            this.lines.remove(this.cursor.row);
            this.cursor.moveUp();
            this.cursor.toRowEnd();
            return;
        }
        if (this.cursor.column == 0 && this.cursor.row == 0) {
            return;
        }
        String text = this.getText();
        int cursorPosition = this.cursor.getPosition();
        this.cursor.moveLeft();
        this.lines.clear();
        this.lines.add(text.substring(0, cursorPosition - 1) + text.substring(cursorPosition));
        this.sanitize();
    }

    private void removeCharacterForward() {
        if (this.selection.erase()) {
            this.sanitize();
            return;
        }
        String line = this.lines.get(this.cursor.row);
        if (line.isEmpty()) {
            int row = this.cursor.row;
            if (row >= this.lines.size() - 1) {
                return;
            }
            this.lines.remove(row);
            this.sanitize();
            return;
        }
        if (this.cursor.column >= line.length() && this.cursor.row == this.lines.size() - 1) {
            return;
        }
        String text = this.getText();
        int cursorPosition = this.cursor.getPosition();
        String newText = text.substring(0, cursorPosition) + text.substring(cursorPosition + 1);
        this.lines.clear();
        this.lines.add(newText);
        this.sanitize();
    }

    public void write(String text) {
        if (text.isEmpty()) {
            return;
        }
        if (this.lines.isEmpty()) {
            this.lines.add(text);
            this.cursor.toEnd();
            return;
        }
        this.selection.erase();
        int oldSize = this.lines.size();
        String whole = this.getText();
        int position = this.cursor.getPosition();
        String newText = position >= whole.length() ? whole + text : whole.substring(0, position) + text + whole.substring(position);
        this.lines.clear();
        this.lines.setLines(Arrays.asList(newText.split("\n")));
        for (int i = 0; i < text.length(); ++i) {
            if (text.charAt(i) == '\n') {
                this.cursor.moveRight();
            }
            this.cursor.moveRight();
        }
        if (oldSize < this.lines.size()) {
            this.cursor.moveRight();
        }
    }

    protected boolean doesLineOccupyFullSpace(String cursorLine) {
        return this.textRenderer.method_1727(cursorLine) >= this.getInnerWidth();
    }

    @Override
    protected void sanitize() {
        if (this.lines.isEmpty()) {
            this.lines.add("");
        }
        this.cursor.sanitize();
    }

    @Override
    public boolean onNavigation(NavigationDirection direction, boolean tab) {
        if (this.requiresCursor()) {
            return false;
        }
        if (!tab) {
            boolean result;
            this.method_25365(true);
            switch (direction) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case RIGHT: {
                    boolean bl = this.onSelectionUpdate(this.cursor::moveRight);
                    break;
                }
                case LEFT: {
                    boolean bl = this.onSelectionUpdate(this.cursor::moveLeft);
                    break;
                }
                case UP: {
                    boolean bl = this.onSelectionUpdate(this.cursor::moveUp);
                    break;
                }
                case DOWN: {
                    boolean bl = result = this.onSelectionUpdate(this.cursor::moveDown);
                }
            }
            if (result) {
                return true;
            }
        }
        return super.onNavigation(direction, tab);
    }

    @Override
    protected boolean onCharTyped(char chr, int keyCode) {
        if (!this.isEditorActive() || !class_155.method_643((char)chr)) {
            return false;
        }
        if (this.isEditable()) {
            this.insertCharacter(chr);
            this.selection.cancel();
        }
        return true;
    }

    @Override
    protected boolean onKeyPress(int keyCode, int scanCode, int modifiers) {
        if (!this.isEditorActive()) {
            return false;
        }
        if (class_437.method_25439((int)keyCode)) {
            this.selection.selectAll();
            return true;
        }
        if (class_437.method_25437((int)keyCode)) {
            this.write(class_310.method_1551().field_1774.method_1460());
            return true;
        }
        if (class_437.method_25438((int)keyCode) || class_437.method_25436((int)keyCode)) {
            String selected = this.selection.getSelectedText();
            if (!selected.isEmpty()) {
                class_310.method_1551().field_1774.method_1455(selected);
            }
            if (class_437.method_25436((int)keyCode) && this.isEditable()) {
                this.selection.erase();
                this.sanitize();
            }
            return true;
        }
        switch (keyCode) {
            case 262: {
                return this.onSelectionUpdate(this.cursor::moveRight);
            }
            case 263: {
                return this.onSelectionUpdate(this.cursor::moveLeft);
            }
            case 265: {
                return this.onSelectionUpdate(this.cursor::moveUp);
            }
            case 264: {
                return this.onSelectionUpdate(this.cursor::moveDown);
            }
            case 269: {
                return this.onSelectionUpdate(class_437.method_25441() ? this.cursor::toEnd : this.cursor::toRowEnd);
            }
            case 268: {
                return this.onSelectionUpdate(class_437.method_25441() ? this.cursor::toStart : this.cursor::toLineStart);
            }
            case 266: {
                return this.onSelectionUpdate(() -> this.cursor.moveVertical(-this.cursor.row));
            }
            case 267: {
                return this.onSelectionUpdate(() -> this.cursor.moveVertical(this.lines.size() - this.cursor.row));
            }
            case 257: 
            case 335: {
                if (this.isEditable()) {
                    this.insertCharacter('\n');
                }
                return true;
            }
            case 259: {
                if (this.isEditable()) {
                    this.eraseCharacter();
                }
                return true;
            }
            case 261: {
                if (this.isEditable()) {
                    this.removeCharacterForward();
                }
                return true;
            }
            case 68: {
                if (class_437.method_25441() && this.isEditable() && !this.lines.isEmpty()) {
                    this.lines.remove(this.cursor.row);
                    this.sanitize();
                }
                return true;
            }
        }
        return false;
    }

    private boolean onSelectionUpdate(Runnable action) {
        this.selection.tryStartSelection();
        action.run();
        this.selection.moveToCursor();
        return true;
    }

    @Override
    protected boolean onMouseClick(double mouseX, double mouseY, int button) {
        if (button == 0) {
            int x = class_3532.method_15357((double)mouseX) - this.getX() - 4;
            int y = class_3532.method_15357((double)mouseY) - this.getY() - 4;
            this.method_25365(true);
            int row = this.firstLine + y / 9;
            if (row >= this.lines.size()) {
                this.cursor.toEnd();
                return true;
            }
            if (row < 0) {
                this.cursor.toStart();
                return true;
            }
            this.onSelectionUpdate(() -> {
                this.cursor.row = row;
                this.cursor.lastColumn = this.cursor.column = this.textRenderer.method_27523(this.lines.get(row), x).length();
            });
            return true;
        }
        return false;
    }

    @Override
    protected boolean onMouseScroll(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (!this.isEditorActive()) {
            return false;
        }
        if (scrollY > 0.0) {
            this.cursor.moveUp();
        } else {
            this.cursor.moveDown();
        }
        return true;
    }

    @Override
    protected void renderWidget(class_332 graphics, int mouseX, int mouseY, float delta) {
        super.renderWidget(graphics, mouseX, mouseY, delta);
        this.drawText(graphics);
        this.drawCursor(graphics);
    }

    protected void drawText(class_332 graphics) {
        int length = Math.min(this.lines.size(), this.displayedLines);
        int textColor = this.getTextColor();
        int textX = this.getX() + 4;
        int lineY = this.getY() + 4;
        for (int row = this.firstLine; row < this.firstLine + length; ++row) {
            String line = this.lines.get(row);
            if (line == null) continue;
            if (line.endsWith("\n")) {
                line = line.substring(0, line.length() - 1);
            }
            graphics.method_27535(this.textRenderer, (class_2561)class_2561.method_43470((String)line), textX, lineY, textColor);
            this.drawSelection(graphics, line, lineY, row);
            Objects.requireNonNull(this.textRenderer);
            lineY += 9;
        }
    }

    protected void drawSelection(class_332 graphics, String line, int lineY, int row) {
        if (!this.method_25370()) {
            return;
        }
        if (!this.selection.isRowSelected(row)) {
            return;
        }
        int startIndex = this.selection.getStart().row != row ? 0 : this.selection.getStart().column;
        int endIndex = this.selection.getEnd().row != row ? line.length() : this.selection.getEnd().column;
        if (endIndex >= line.length()) {
            endIndex = line.length();
        }
        if (startIndex >= line.length() || startIndex == endIndex) {
            return;
        }
        int x = this.getX() + 4 + this.textRenderer.method_1727(line.substring(0, startIndex));
        String selected = line.substring(startIndex, endIndex);
        int x2 = x + this.textRenderer.method_1727(selected);
        Objects.requireNonNull(this.textRenderer);
        int y2 = lineY + 9;
        class_289 tessellator = class_289.method_1348();
        class_287 buffer = tessellator.method_1349();
        RenderSystem.enableColorLogicOp();
        RenderSystem.logicOp((GlStateManager.class_1030)GlStateManager.class_1030.field_5110);
        RenderSystem.setShader(class_757::method_34539);
        RenderSystem.setShaderColor((float)0.0f, (float)0.0f, (float)1.0f, (float)1.0f);
        buffer.method_1328(class_293.class_5596.field_27382, class_290.field_1592);
        buffer.method_22912((double)x, (double)y2, 0.0).method_1344();
        buffer.method_22912((double)x2, (double)y2, 0.0).method_1344();
        buffer.method_22912((double)x2, (double)lineY, 0.0).method_1344();
        buffer.method_22912((double)x, (double)lineY, 0.0).method_1344();
        tessellator.method_1350();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableColorLogicOp();
    }

    protected void drawCursor(class_332 graphics) {
        if (!this.method_25370()) {
            return;
        }
        if (this.lines.isEmpty()) {
            graphics.method_27535(this.textRenderer, (class_2561)class_2561.method_43470((String)"_"), this.getX(), this.getY() + 4, -2039584);
            return;
        }
        this.cursor.sanitize();
        int actualRow = this.cursor.row - this.firstLine;
        String cursorLine = this.lines.get(this.cursor.row);
        int cursorX = this.getX() + 4 + this.textRenderer.method_1727(cursorLine.substring(0, this.cursor.column));
        int n = this.getY() + 4;
        Objects.requireNonNull(this.textRenderer);
        int cursorY = n + actualRow * 9;
        if (this.cursor.row < this.lines.size() - 1 || this.cursor.column < cursorLine.length() || this.doesLineOccupyFullSpace(cursorLine)) {
            graphics.method_25294(cursorX - 1, cursorY - 1, cursorX, cursorY + 9, -2039584);
        } else {
            graphics.method_25303(this.textRenderer, "_", cursorX, cursorY, -2039584);
        }
    }

    public class Cursor {
        boolean main;
        int row = 0;
        int column = 0;
        private int lastColumn = 0;

        public Cursor(boolean main) {
            this.main = main;
        }

        public void toLineStart() {
            this.column = 0;
            this.lastColumn = 0;
        }

        public void resetRow() {
            this.row = 0;
        }

        public void moveRight() {
            this.moveHorizontal(1);
        }

        public void moveLeft() {
            this.moveHorizontal(-1);
        }

        public void moveUp() {
            this.moveVertical(-1);
        }

        public void moveDown() {
            this.moveVertical(1);
        }

        public void moveHorizontal(int amount) {
            String line;
            this.column += amount;
            if (this.row >= SpruceTextAreaWidget.this.lines.size()) {
                this.row = SpruceTextAreaWidget.this.lines.size() - 1;
                this.column = SpruceTextAreaWidget.this.lines.get(this.row).length();
            }
            if (this.column < 0) {
                if (this.row == 0) {
                    this.toLineStart();
                } else {
                    --this.row;
                    this.column = SpruceTextAreaWidget.this.lines.get(this.row).length();
                }
            }
            if ((line = SpruceTextAreaWidget.this.lines.get(this.row)).endsWith("\n")) {
                line = line.substring(0, line.length() - 1);
            }
            if (this.column > line.length()) {
                if (amount > 0 && this.row != SpruceTextAreaWidget.this.lines.size() - 1) {
                    this.column = 0;
                    ++this.row;
                } else {
                    this.column = line.length();
                }
            }
            this.lastColumn = this.column;
            this.adjustFirstLine();
        }

        public void moveVertical(int amount) {
            this.row += amount;
            this.column = this.lastColumn;
            this.sanitize();
            this.adjustFirstLine();
        }

        public void toStart() {
            this.resetRow();
            this.toLineStart();
            this.adjustFirstLine();
        }

        public void toEnd() {
            this.row = Math.max(0, SpruceTextAreaWidget.this.lines.size() - 1);
            String line = SpruceTextAreaWidget.this.lines.get(this.row);
            if (line == null) {
                this.column = 0;
                this.lastColumn = 0;
            } else {
                this.lastColumn = line.endsWith("\n") ? (this.column = line.length() - 1) : (this.column = line.length());
            }
            this.adjustFirstLine();
        }

        public void toRowEnd() {
            String line = SpruceTextAreaWidget.this.lines.get(this.row);
            if (line == null) {
                this.column = 0;
                this.lastColumn = 0;
            } else {
                this.lastColumn = line.endsWith("\n") ? (this.column = line.length() - 1) : (this.column = line.length());
            }
        }

        public void copy(Cursor cursor) {
            this.row = cursor.row;
            this.lastColumn = this.column = cursor.column;
        }

        public void sanitize() {
            String line;
            if (SpruceTextAreaWidget.this.lines.size() <= this.row) {
                this.row = SpruceTextAreaWidget.this.lines.size() - 1;
            }
            if (this.row < 0) {
                this.resetRow();
            }
            if ((line = SpruceTextAreaWidget.this.lines.get(this.row)).endsWith("\n")) {
                line = line.substring(0, line.length() - 1);
            }
            if (this.column > line.length()) {
                this.column = line.length();
            }
            this.adjustFirstLine();
        }

        public boolean isSame(Cursor other) {
            return this.row == other.row && this.column == other.column;
        }

        public int getPosition() {
            int i;
            int position = 0;
            for (i = 0; i < this.row; ++i) {
                position += SpruceTextAreaWidget.this.lines.get(i).length();
            }
            for (i = 0; i < this.column; ++i) {
                ++position;
            }
            return position;
        }

        private void adjustFirstLine() {
            int endLine;
            if (!this.main) {
                return;
            }
            if (SpruceTextAreaWidget.this.firstLine > this.row) {
                SpruceTextAreaWidget.this.firstLine = this.row;
            }
            if (SpruceTextAreaWidget.this.firstLine == SpruceTextAreaWidget.this.lines.size()) {
                --SpruceTextAreaWidget.this.firstLine;
            }
            if ((endLine = SpruceTextAreaWidget.this.firstLine + SpruceTextAreaWidget.this.displayedLines - 1) >= SpruceTextAreaWidget.this.lines.size()) {
                SpruceTextAreaWidget.this.firstLine = SpruceTextAreaWidget.this.lines.size() - SpruceTextAreaWidget.this.displayedLines - 1;
            }
            if (this.row >= SpruceTextAreaWidget.this.firstLine + SpruceTextAreaWidget.this.displayedLines) {
                SpruceTextAreaWidget.this.firstLine = this.row - SpruceTextAreaWidget.this.displayedLines + 1;
            }
            if (SpruceTextAreaWidget.this.firstLine < 0) {
                SpruceTextAreaWidget.this.firstLine = 0;
            }
        }

        public String toString() {
            return "SpruceTextAreaWidget$Cursor{main=" + this.main + ", row=" + this.row + ", column=" + this.column + ", lastColumn=" + this.lastColumn + "}";
        }
    }

    public class Selection {
        private final Cursor anchor;
        private final Cursor follower;
        private boolean active;

        public Selection() {
            this.anchor = new Cursor(false);
            this.follower = new Cursor(false);
            this.active = false;
        }

        public void selectAll() {
            this.anchor.toStart();
            SpruceTextAreaWidget.this.cursor.toEnd();
            this.follower.copy(SpruceTextAreaWidget.this.cursor);
            this.active = true;
        }

        public void cancel() {
            this.anchor.toStart();
            this.follower.toStart();
            this.active = false;
        }

        public void tryStartSelection() {
            if (!this.active && class_437.method_25442()) {
                this.startSelection();
            }
        }

        public void startSelection() {
            this.anchor.copy(SpruceTextAreaWidget.this.cursor);
            this.follower.copy(SpruceTextAreaWidget.this.cursor);
            this.active = true;
        }

        public boolean isRowSelected(int row) {
            return this.active && this.getStart().row <= row && row <= this.getEnd().row;
        }

        public void moveToCursor() {
            if (!this.active) {
                return;
            }
            if (class_437.method_25442()) {
                this.follower.copy(SpruceTextAreaWidget.this.cursor);
            } else {
                this.cancel();
            }
        }

        public boolean erase() {
            Cursor end;
            if (!this.active) {
                return false;
            }
            Cursor start = this.getStart();
            if (start.isSame(end = this.getEnd())) {
                this.cancel();
                return false;
            }
            if (start.row == 0 && start.column == 0 && end.row == SpruceTextAreaWidget.this.lines.size() - 1 && end.column >= SpruceTextAreaWidget.this.lines.get(SpruceTextAreaWidget.this.lines.size() - 1).length()) {
                SpruceTextAreaWidget.this.lines.clear();
                SpruceTextAreaWidget.this.lines.add("");
                this.cancel();
                return true;
            }
            if (start.row == end.row) {
                String line = SpruceTextAreaWidget.this.lines.get(start.row);
                if (start.column == 0 && end.column >= line.length()) {
                    SpruceTextAreaWidget.this.lines.remove(start.row);
                } else {
                    SpruceTextAreaWidget.this.lines.replaceRow(start.row, line.substring(0, start.column) + line.substring(end.column));
                }
                SpruceTextAreaWidget.this.cursor.copy(start);
                this.cancel();
                return true;
            }
            String text = SpruceTextAreaWidget.this.getText();
            String newText = text.substring(0, start.getPosition()) + text.substring(end.getPosition());
            SpruceTextAreaWidget.this.lines.clear();
            SpruceTextAreaWidget.this.lines.add(newText);
            SpruceTextAreaWidget.this.cursor.copy(start);
            this.cancel();
            return true;
        }

        public String getSelectedText() {
            Cursor end;
            if (!this.active) {
                return "";
            }
            Cursor start = this.getStart();
            if (start.isSame(end = this.getEnd())) {
                return "";
            }
            if (start.row == end.row) {
                return SpruceTextAreaWidget.this.lines.get(start.row).substring(start.column, end.column);
            }
            return SpruceTextAreaWidget.this.getText().substring(start.getPosition(), end.getPosition());
        }

        public Cursor getStart() {
            return this.isInverted() ? this.follower : this.anchor;
        }

        public Cursor getEnd() {
            return this.isInverted() ? this.anchor : this.follower;
        }

        private boolean isInverted() {
            return this.anchor.row > this.follower.row || this.anchor.row == this.follower.row && this.anchor.column > this.follower.column;
        }
    }
}

