/*
 * Decompiled with CFR 0.152.
 */
package dev.kir.cubeswithoutborders.client.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.mojang.blaze3d.systems.RenderSystem;
import dev.kir.cubeswithoutborders.client.option.FullscreenMode;
import dev.kir.cubeswithoutborders.client.option.FullscreenOptions;
import dev.kir.cubeswithoutborders.client.util.FullscreenWindowState;
import dev.kir.cubeswithoutborders.client.util.MonitorInfo;
import dev.kir.cubeswithoutborders.client.util.MonitorInfoContainer;
import dev.kir.cubeswithoutborders.client.util.MonitorLookup;
import dev.kir.cubeswithoutborders.client.util.WindowUtil;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1041;
import net.minecraft.class_310;
import net.minecraft.class_313;
import net.minecraft.class_315;
import net.minecraft.class_319;
import net.minecraft.class_323;
import net.minecraft.class_3678;
import net.minecraft.class_543;
import org.lwjgl.glfw.GLFW;
import org.slf4j.Logger;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Environment(value=EnvType.CLIENT)
@Mixin(value={class_1041.class})
abstract class WindowMixin
implements FullscreenWindowState {
    @Shadow
    @Final
    private static Logger field_5178;
    @Shadow
    @Final
    private long field_5187;
    @Shadow
    private int field_5183;
    @Shadow
    private int field_5198;
    @Shadow
    private int field_5175;
    @Shadow
    private int field_5185;
    @Shadow
    private int field_5182;
    @Shadow
    private int field_5197;
    @Shadow
    private int field_5174;
    @Shadow
    private int field_5184;
    @Shadow
    private boolean field_5191;
    private boolean borderless;
    private boolean prefersBorderless;
    private boolean currentBorderless;
    @Shadow
    @Final
    private class_323 field_5195;
    @Shadow
    private Optional<class_319> field_5193;

    WindowMixin() {
    }

    @Shadow
    protected abstract void method_4479();

    @Override
    public FullscreenMode getFullscreenMode() {
        return FullscreenMode.get(this.field_5191, this.borderless);
    }

    @Override
    public void setFullscreenMode(FullscreenMode mode) {
        this.borderless = mode == FullscreenMode.BORDERLESS;
        this.field_5191 = mode == FullscreenMode.ON;
        this.prefersBorderless = this.prefersBorderless & !this.field_5191 | this.borderless;
    }

    @Override
    public FullscreenMode getPreferredFullscreenMode() {
        return this.prefersBorderless ? FullscreenMode.BORDERLESS : FullscreenMode.ON;
    }

    @Override
    public void setPreferredFullscreenMode(FullscreenMode mode) {
        this.prefersBorderless = mode == FullscreenMode.BORDERLESS;
    }

    @WrapOperation(method={"<init>"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/util/MonitorTracker;getMonitor(J)Lnet/minecraft/client/util/Monitor;", ordinal=0)})
    private class_313 getMonitor(class_323 monitorTracker, long pointer, Operation<class_313> getMonitor, class_3678 _arg0, class_323 _arg1, class_543 settings) {
        class_313 defaultMonitor = (class_313)getMonitor.call(new Object[]{monitorTracker, pointer});
        MonitorInfo monitorInfo = ((MonitorInfoContainer)settings).getMonitorInfo();
        return MonitorLookup.findMonitor(monitorTracker, monitorInfo).orElse(defaultMonitor);
    }

    @WrapOperation(method={"<init>"}, at={@At(value="INVOKE", target="Lorg/lwjgl/glfw/GLFW;glfwCreateWindow(IILjava/lang/CharSequence;JJ)J", ordinal=0)})
    private long createWindow(int width, int height, CharSequence title, long monitorHandle, long share, Operation<Long> createWindow, class_3678 eventHandler, class_323 monitorTracker, class_543 settings) {
        class_313 monitor;
        class_313 class_3132 = monitor = monitorHandle == 0L ? null : monitorTracker.method_1680(monitorHandle);
        if (monitor != null) {
            boolean isBorderless = ((FullscreenWindowState)settings).getFullscreenMode() == FullscreenMode.BORDERLESS;
            class_319 videoMode = monitor.method_1614(isBorderless ? Optional.empty() : this.field_5193);
            this.field_5182 = width = videoMode.method_1668();
            this.field_5197 = height = videoMode.method_1669();
        }
        return (Long)createWindow.call(new Object[]{width, height, title, monitorHandle, share});
    }

    @Inject(method={"setWindowedSize"}, at={@At(value="HEAD")})
    private void setWindowedSize(CallbackInfo ci) {
        this.borderless = false;
    }

    @Inject(method={"toggleFullscreen"}, at={@At(value="RETURN")})
    private void toggleFullscreen(CallbackInfo ci) {
        this.borderless = this.borderless && !this.field_5191;
    }

    @Inject(method={"swapBuffers"}, at={@At(value="RETURN")})
    private void swapBuffers(CallbackInfo ci) {
        if (this.currentBorderless != this.borderless) {
            this.method_4479();
        }
    }

    @Inject(method={"updateWindowRegion"}, at={@At(value="HEAD")}, cancellable=true)
    private void updateBorderlessWindowRegion(CallbackInfo ci) {
        boolean isInWindowedMode;
        if (!this.borderless || this.currentBorderless) {
            return;
        }
        RenderSystem.assertInInitPhase();
        class_313 monitor = this.field_5195.method_1681((class_1041)this);
        if (monitor == null) {
            field_5178.warn("Failed to find suitable monitor for fullscreen mode");
            this.borderless = false;
            ci.cancel();
            return;
        }
        class_319 videoMode = monitor.method_1617();
        boolean bl = isInWindowedMode = GLFW.glfwGetWindowMonitor((long)this.field_5187) == 0L;
        if (isInWindowedMode) {
            this.field_5175 = this.field_5183;
            this.field_5185 = this.field_5198;
            this.field_5174 = this.field_5182;
            this.field_5184 = this.field_5197;
        }
        long monitorHandle = monitor.method_1622();
        this.field_5183 = monitor.method_1616();
        this.field_5198 = monitor.method_1618();
        this.field_5182 = videoMode.method_1668();
        this.field_5197 = videoMode.method_1669();
        int refreshRate = videoMode.method_1671();
        GLFW.glfwSetWindowMonitor((long)this.field_5187, (long)monitorHandle, (int)this.field_5183, (int)this.field_5198, (int)this.field_5182, (int)this.field_5197, (int)refreshRate);
        WindowUtil.disableExclusiveFullscreen((class_1041)this);
        this.currentBorderless = true;
        ci.cancel();
    }

    @Inject(method={"updateWindowRegion"}, at={@At(value="INVOKE", target="Lorg/lwjgl/glfw/GLFW;glfwSetWindowMonitor(JJIIIII)V", ordinal=0, shift=At.Shift.AFTER)})
    private void restoreExclusiveFullscreen(CallbackInfo ci) {
        WindowUtil.enableExclusiveFullscreen((class_1041)this);
    }

    @Inject(method={"updateWindowRegion"}, at={@At(value="RETURN")})
    private void updateBorderlessStatus(CallbackInfo ci) {
        this.currentBorderless = this.borderless;
    }

    @Inject(method={"close"}, at={@At(value="HEAD")})
    private void saveSelectedMonitor(CallbackInfo ci) {
        class_313 monitor = this.field_5195.method_1681((class_1041)this);
        if (monitor == null) {
            return;
        }
        MonitorInfo monitorInfo = MonitorInfo.of(monitor);
        class_315 options = class_310.method_1551().field_1690;
        ((FullscreenOptions)options).getFullscreenMonitor().method_41748((Object)monitorInfo);
        options.method_1640();
    }
}

