/*
 * Decompiled with CFR 0.152.
 */
package dev.kir.cubeswithoutborders.client.util;

import dev.kir.cubeswithoutborders.client.util.SystemUtil;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1041;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWNativeWin32;
import org.lwjgl.system.windows.User32;

@Environment(value=EnvType.CLIENT)
public final class WindowUtil {
    public static boolean enableExclusiveFullscreen(class_1041 window) {
        GLFW.glfwSetWindowAttrib((long)window.method_4490(), (int)131078, (int)1);
        if (SystemUtil.isWindows()) {
            return WindowUtil.enableExclusiveFullscreen_Windows(window);
        }
        return true;
    }

    public static boolean disableExclusiveFullscreen(class_1041 window) {
        GLFW.glfwSetWindowAttrib((long)window.method_4490(), (int)131078, (int)0);
        if (SystemUtil.isWindows()) {
            return WindowUtil.disableExclusiveFullscreen_Windows(window);
        }
        return true;
    }

    private static boolean enableExclusiveFullscreen_Windows(class_1041 window) {
        long hWndInsertAfter = -1L;
        long style = -1777729536L;
        long exStyle = 262160L;
        return WindowUtil.setWindowStyle_Windows(window, hWndInsertAfter, style, exStyle);
    }

    private static boolean disableExclusiveFullscreen_Windows(class_1041 window) {
        long hWndInsertAfter = -2L;
        long style = 369229824L;
        long exStyle = 34340880L;
        return WindowUtil.setWindowStyle_Windows(window, hWndInsertAfter, style, exStyle);
    }

    private static boolean setWindowStyle_Windows(class_1041 window, long hWndInsertAfter, long style, long exStyle) {
        long hWnd = GLFWNativeWin32.glfwGetWin32Window((long)window.method_4490());
        if (hWnd == 0L) {
            return false;
        }
        int x = window.method_4499();
        int y = window.method_4477();
        int width = window.method_4480();
        int height = window.method_4507();
        int flags = 1027;
        User32.SetWindowPos((long)hWnd, (long)hWndInsertAfter, (int)x, (int)y, (int)width, (int)height, (int)flags);
        User32.SetWindowLongPtr((long)hWnd, (int)-16, (long)style);
        User32.SetWindowLongPtr((long)hWnd, (int)-20, (long)exStyle);
        return true;
    }

    private WindowUtil() {
    }
}

