/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.minecraft.common.block.upgradestation;

import com.mojang.blaze3d.systems.RenderSystem;
import com.sigmundgranaas.forgero.core.state.Slot;
import com.sigmundgranaas.forgero.minecraft.common.block.upgradestation.UpgradeStationScreenHandler;
import com.sigmundgranaas.forgero.minecraft.common.tooltip.v2.TooltipConfiguration;
import com.sigmundgranaas.forgero.minecraft.common.tooltip.v2.section.SlotSectionWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1713;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_465;
import net.minecraft.class_5321;
import net.minecraft.class_5348;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_757;
import net.minecraft.class_7923;

public class UpgradeStationScreen
extends class_465<UpgradeStationScreenHandler> {
    private static final class_2960 TEXTURE = new class_2960("forgero", "textures/gui/container/upgrade_table_ui.png");
    private final int backgroundHeight = 220;
    private final int backgroundWidth = 176;
    private int tickCounter;

    public UpgradeStationScreen(UpgradeStationScreenHandler handler, class_1661 inventory, class_2561 title) {
        super((class_1703)handler, inventory, (class_2561)class_2561.method_43471((String)"block.forgero.upgrade_station"));
        this.field_2779 = this.backgroundHeight;
        this.field_2792 = this.backgroundWidth;
    }

    public void renderCustomTooltip(class_332 context, List<class_2561> lines, int mouseX, int mouseY) {
        for (UpgradeStationScreenHandler.PositionedSlot slot : ((UpgradeStationScreenHandler)this.field_2797).slotPool.stream().filter(Objects::nonNull).map(UpgradeStationScreenHandler.PositionedSlot.class::cast).toList()) {
            if (!this.method_2378(slot.xPosition, slot.yPosition, 16, 16, mouseX, mouseY) || slot.method_7681() || slot.slot == null) continue;
            lines.addAll(new SlotSectionWriter.SlotWriter(slot.slot, TooltipConfiguration.builder().build()).entries());
            context.method_51434(this.field_22793, lines, mouseX, mouseY);
            this.renderCycledSlot(slot, lines, mouseX, mouseY, context);
        }
        if (this.method_2378(((UpgradeStationScreenHandler)this.field_2797).compositeSlot.x, ((UpgradeStationScreenHandler)this.field_2797).compositeSlot.y, 16, 16, mouseX, mouseY) && !((UpgradeStationScreenHandler)this.field_2797).compositeSlot.method_7681()) {
            lines.add((class_2561)class_2561.method_43470((String)"Place you Forgero tool or weapon here"));
            context.method_51434(this.field_22793, lines, mouseX, mouseY);
            this.renderCycledTag(new class_2960("forgero:holdable"), mouseX, mouseY, context);
        }
    }

    public void renderCycledSlot(UpgradeStationScreenHandler.PositionedSlot slot, List<class_2561> tooltip, int mouseX, int mouseY, class_332 context) {
        if (slot.getSlot() != null) {
            Slot slot1 = slot.getSlot();
            class_2960 id = new class_2960("forgero", slot1.typeName().toLowerCase(Locale.ENGLISH));
            this.renderCycledTag(id, mouseX, mouseY, context);
        }
    }

    public void renderCycledTag(class_2960 id, int mouseX, int mouseY, class_332 context) {
        class_6862 key = class_6862.method_40092((class_5321)class_7923.field_41178.method_30517(), (class_2960)id);
        ArrayList entries = new ArrayList();
        class_7923.field_41178.method_40286(key).forEach(entries::add);
        List<class_1792> acceptedItems = entries.stream().map(class_6880::comp_349).toList();
        try {
            class_1792 itemToShow = acceptedItems.get(this.tickCounter / 40 % acceptedItems.size());
            context.method_51427(itemToShow.method_7854(), mouseX, mouseY);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void drawDynamicSlot(class_332 context, class_1735 slot) {
        int x = slot.field_7873 - 1;
        int y = slot.field_7872 - 1;
        int centerX = (this.field_22789 - this.backgroundWidth) / 2;
        int centerY = (this.field_22790 - this.backgroundHeight) / 2;
        context.method_25302(TEXTURE, centerX + x, centerY + y, 194, 55, 18, 18);
    }

    public void method_25394(class_332 matrices, int mouseX, int mouseY, float delta) {
        super.method_25394(matrices, mouseX, mouseY, delta);
        ++this.tickCounter;
        this.method_2380(matrices, mouseX, mouseY);
        if (((UpgradeStationScreenHandler)this.field_2797).compositeSlot.method_7681()) {
            this.renderCustomTooltip(matrices, new ArrayList<class_2561>(), mouseX, mouseY);
        }
    }

    private void renderVerticalHalfway(class_332 context, int startX, int startY, int endX, int endY, int thickness, int color, float opacity) {
        int halfWayY = startY + (endY - startY) / 2;
        this.renderLineBetweenSlots(context, startX + this.field_2776, startY + this.field_2800, startX + this.field_2776, halfWayY + this.field_2800, thickness, color, opacity);
    }

    private void renderHorizontalToChild(class_332 context, int startX, int startY, int endX, int endY, int thickness, int color, float opacity) {
        int halfWayY = startY + (endY - startY) / 2;
        this.renderLineBetweenSlots(context, startX + this.field_2776, halfWayY + this.field_2800, endX + this.field_2776, halfWayY + this.field_2800, thickness, color, opacity);
    }

    protected void method_2383(class_1735 slot, int slotId, int button, class_1713 actionType) {
        super.method_2383(slot, slotId, button, actionType);
    }

    private void renderVerticalToChild(class_332 context, int startX, int startY, int endX, int endY, int thickness, int color, float opacity) {
        int halfWayY = startY + (endY - startY) / 2;
        this.renderLineBetweenSlots(context, endX + this.field_2776, halfWayY + this.field_2800, endX + this.field_2776, endY + this.field_2800, thickness, color, opacity);
    }

    public void renderLinesBetweenSlots(class_332 context) {
        for (class_1735 class_17352 : ((UpgradeStationScreenHandler)this.field_2797).slotPool) {
            if (!(class_17352 instanceof UpgradeStationScreenHandler.PositionedSlot)) continue;
            UpgradeStationScreenHandler.PositionedSlot positionedSlot = (UpgradeStationScreenHandler.PositionedSlot)class_17352;
            if (!class_17352.method_7682() || positionedSlot.parent == null || !positionedSlot.parent.method_7682()) continue;
            class_1735 parent = positionedSlot.parent;
            int parentCenterX = parent.field_7873 + 8;
            int parentCenterY = parent.field_7872 + 8;
            if (parent instanceof UpgradeStationScreenHandler.PositionedSlot) {
                UpgradeStationScreenHandler.PositionedSlot positionedSlot1 = (UpgradeStationScreenHandler.PositionedSlot)parent;
                parentCenterX = positionedSlot1.xPosition + 8;
                parentCenterY = positionedSlot1.yPosition + 8;
            }
            int childCenterX = positionedSlot.xPosition + 8;
            int childCenterY = positionedSlot.yPosition + 8;
            int thickness = 2;
            int color = 0xFFFFFF;
            float opacity = 0.5f;
            this.renderVerticalHalfway(context, parentCenterX, parentCenterY, childCenterX, childCenterY, thickness, color, opacity);
            this.renderHorizontalToChild(context, parentCenterX, parentCenterY, childCenterX, childCenterY, thickness, color, opacity);
            this.renderVerticalToChild(context, parentCenterX, parentCenterY, childCenterX, childCenterY, thickness, color, opacity);
        }
    }

    private void renderLineBetweenSlots(class_332 context, int startLineX, int startLineY, int endLineX, int endLineY, int thickness, int color, float opacity) {
        float deltaX = endLineX - startLineX;
        float deltaY = endLineY - startLineY;
        double lineLength = Math.sqrt(deltaX * deltaX + deltaY * deltaY);
        int rgbaColor = color & 0xFFFFFF | (int)(255.0f * opacity) << 24;
        for (int t = 0; t < thickness; ++t) {
            int i = 0;
            while ((double)i < lineLength) {
                float ratio = (float)((double)i / lineLength);
                int currentLineX = (int)((float)startLineX + ratio * deltaX);
                int currentLineY = (int)((float)startLineY + ratio * deltaY);
                context.method_25294(currentLineX + t, currentLineY, currentLineX + t + 1, currentLineY + 1, rgbaColor);
                ++i;
            }
        }
    }

    protected void method_25426() {
        super.method_25426();
        this.field_25267 = (176 - this.field_22793.method_27525((class_5348)this.field_22785)) / 2;
        this.field_25268 = 5;
        this.field_25270 = 127;
    }

    protected void method_2389(class_332 context, float delta, int mouseX, int mouseY) {
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int centerX = (this.field_22789 - this.backgroundWidth) / 2;
        int centerY = (this.field_22790 - this.backgroundHeight) / 2;
        context.method_25302(TEXTURE, centerX, centerY, 0, 0, 176, 220);
        if (((UpgradeStationScreenHandler)this.field_2797).compositeSlot.method_7681()) {
            this.renderLinesBetweenSlots(context);
            for (class_1735 class_17352 : ((UpgradeStationScreenHandler)this.field_2797).slotPool) {
                if (!(class_17352 instanceof UpgradeStationScreenHandler.PositionedSlot)) continue;
                UpgradeStationScreenHandler.PositionedSlot positioned = (UpgradeStationScreenHandler.PositionedSlot)class_17352;
                if (!class_17352.method_7682() || positioned.slot == null) continue;
                this.drawDynamicSlot(context, class_17352);
            }
        }
        this.drawDynamicSlot(context, ((UpgradeStationScreenHandler)this.field_2797).compositeSlot);
    }
}

