/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.minecraft.common.block.upgradestation;

import com.sigmundgranaas.forgero.core.property.Property;
import com.sigmundgranaas.forgero.core.property.attribute.Category;
import com.sigmundgranaas.forgero.core.state.Composite;
import com.sigmundgranaas.forgero.core.state.Slot;
import com.sigmundgranaas.forgero.core.state.State;
import com.sigmundgranaas.forgero.core.state.composite.ConstructedState;
import com.sigmundgranaas.forgero.core.state.upgrade.slot.SlotContainer;
import com.sigmundgranaas.forgero.core.type.Type;
import com.sigmundgranaas.forgero.core.util.match.MatchContext;
import com.sigmundgranaas.forgero.core.util.match.Matchable;
import com.sigmundgranaas.forgero.minecraft.common.item.nbt.v2.NbtConstants;
import com.sigmundgranaas.forgero.minecraft.common.service.StateService;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.class_1263;
import net.minecraft.class_1265;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_3222;
import net.minecraft.class_3914;
import net.minecraft.class_3917;
import net.minecraft.class_7701;
import org.jetbrains.annotations.NotNull;

public class UpgradeStationScreenHandler
extends class_1703 {
    private static final int SLOT_SIZE = 18;
    public final int verticalSpacing = 25;
    public final int compositeSlotY = 20;
    protected final CompositeSlot compositeSlot;
    protected final List<PositionedSlot> slotPool;
    private final class_1277 compositeInventory;
    private final class_3914 context;
    private final StateService service;
    private final int maxSlots = 100;
    private class_1657 entity;
    private boolean isBuildingTree = false;
    private int activeSlots;
    public static class_3917<UpgradeStationScreenHandler> UPGRADE_STATION_SCREEN_HANDLER = new class_3917(UpgradeStationScreenHandler::new, class_7701.field_40182);

    public UpgradeStationScreenHandler(int syncId, class_1661 playerInventory) {
        this(syncId, playerInventory, class_3914.field_17304);
        this.entity = playerInventory.field_7546;
    }

    public UpgradeStationScreenHandler(int syncId, class_1661 playerInventory, class_3914 context) {
        super(UPGRADE_STATION_SCREEN_HANDLER, syncId);
        int j;
        int i;
        this.context = context;
        this.compositeInventory = new class_1277(1);
        this.entity = playerInventory.field_7546;
        this.compositeInventory.method_5489(this::onCompositeSlotChanged);
        this.compositeInventory.method_5435(playerInventory.field_7546);
        this.compositeSlot = new CompositeSlot((class_1263)this.compositeInventory, 0, 80, 20, null);
        this.service = StateService.INSTANCE.uncached();
        this.method_7621(this.compositeSlot);
        this.slotPool = new ArrayList<PositionedSlot>(100);
        this.activeSlots = 0;
        for (i = 0; i < 9; ++i) {
            this.method_7621(new class_1735((class_1263)playerInventory, this.field_7761.size() - 1, 8 + i * 18, 196));
        }
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 9; ++j) {
                this.method_7621(new class_1735((class_1263)playerInventory, this.field_7761.size() - 1, 8 + j * 18, 138 + i * 18));
            }
        }
        for (j = 0; j < 100; ++j) {
            class_1277 inventory = new class_1277(1);
            PositionedSlot slot = new PositionedSlot((class_1263)inventory, 0, 0, 0, null, null, null);
            this.slotPool.add(slot);
            this.method_7621(slot);
        }
    }

    public void onCompositeSlotChanged(class_1263 compositeInventory) {
        if (!this.isBuildingTree) {
            State state;
            this.isBuildingTree = true;
            Optional<State> component = this.service.convert(compositeInventory.method_5438(0).method_7972());
            if (component.isPresent() && (state = component.get()) instanceof Composite) {
                Composite composite = (Composite)state;
                Composite newState = (Composite)composite.copy();
                this.compositeSlot.state = newState;
                this.clearSlotsAndRebuildTree((State)newState);
            } else {
                for (int i = 0; i < this.maxSlots; ++i) {
                    this.slotPool.get(i).clear();
                }
                this.compositeSlot.state = null;
                this.compositeSlot.field_7871.method_5448();
            }
            this.method_37420();
            this.method_7623();
            this.isBuildingTree = false;
        }
    }

    private class_1265 createPartSlotFn(PositionedSlot slot) {
        return partInventory -> this.context.method_17393((world, pos) -> {
            if (!world.method_8608() && !this.isBuildingTree && this.compositeSlot.state != null && this.entity instanceof class_3222) {
                this.isBuildingTree = true;
                class_1799 stack = partInventory.method_5438(0).method_7972();
                Optional<State> component = this.service.convert(stack);
                if (component.isPresent()) {
                    slot.slot = slot.container.set(component.get(), slot.slot);
                } else if (slot.container != null) {
                    slot.slot = slot.container.empty(slot.getSlot());
                }
                this.isBuildingTree = false;
                class_1799 newState = this.service.convert(this.compositeSlot.state).get();
                class_2487 nbt = this.compositeSlot.field_7871.method_5438(0).method_7972().method_7948();
                nbt.method_10566(NbtConstants.FORGERO_IDENTIFIER, newState.method_7948().method_10580(NbtConstants.FORGERO_IDENTIFIER));
                newState.method_7980(nbt);
                this.compositeSlot.method_7673(newState);
            }
        });
    }

    private void clearSlotsAndRebuildTree(State state) {
        for (int i = 0; i < this.maxSlots; ++i) {
            this.slotPool.get(i).clear();
        }
        this.activeSlots = 0;
        ToolTree toolTree = new ToolTree(state);
        toolTree.buildTree();
        this.placeSlots(toolTree.getRoot(), 75, 45, 1, this.compositeSlot, this.entity);
    }

    private void placeSlots(TreeNode node, int parentOffsetX, int offsetY, int slotSpacing, class_1735 parent, class_1657 entity) {
        int totalSlots = node.getLeafCount();
        int totalSlotWidth = totalSlots * 18;
        int totalSpacingWidth = (totalSlots - 1) * slotSpacing;
        int totalWidth = totalSlotWidth + totalSpacingWidth;
        int startOffsetX = parentOffsetX - totalWidth / 2;
        int currentWidth = 0;
        int placedSlots = 0;
        for (TreeNode child : node.getChildren()) {
            int childSlots = child.getLeafCount();
            int childSlotWidth = childSlots * 18;
            int childSpacingWidth = (childSlots - 1) * slotSpacing;
            int childWidth = childSlotWidth + childSpacingWidth;
            int slotOffsetX = startOffsetX + currentWidth + childWidth / 2;
            PositionedSlot slot = this.slotPool.get(this.activeSlots);
            int index = this.field_7761.indexOf((Object)slot);
            class_1277 newInventory = new class_1277(1);
            SlotContainer container = ((Composite)node.state).getSlotContainer();
            PositionedSlot newSlot = new PositionedSlot((class_1263)newInventory, 0, slotOffsetX, offsetY, child.slot, parent, container);
            newSlot.field_7874 = slot.field_7874;
            newInventory.method_5489(this.createPartSlotFn(newSlot));
            this.field_7761.set(index, (Object)newSlot);
            this.slotPool.set(this.activeSlots, newSlot);
            State state = child.getState();
            ++this.activeSlots;
            if (!(state instanceof EmptyState)) {
                if (entity instanceof class_3222) {
                    class_3222 serverPlayerEntity = (class_3222)entity;
                    class_1799 stack = this.service.convert(state).orElse(class_1799.field_8037);
                    newSlot.field_7871.method_5447(0, stack.method_7972());
                }
                this.placeSlots(child, slotOffsetX + 5 * placedSlots, offsetY + 25, slotSpacing, newSlot, entity);
            }
            ++placedSlots;
            currentWidth += childWidth + slotSpacing;
        }
    }

    public void method_7595(class_1657 player) {
        super.method_7595(player);
        this.context.method_17393((world, pos) -> this.method_7607(player, (class_1263)this.compositeInventory));
    }

    public boolean method_7597(class_1657 player) {
        return true;
    }

    public class_1799 method_7601(class_1657 player, int invSlot) {
        class_1735 slot;
        class_1799 newStack = class_1799.field_8037;
        if (this.field_7761.size() > invSlot && (slot = (class_1735)this.field_7761.get(invSlot)).method_7681()) {
            class_1799 originalStack = slot.method_7677();
            newStack = originalStack.method_7972();
            if (invSlot < this.compositeInventory.method_5439() ? !this.method_7616(originalStack, this.compositeInventory.method_5439(), this.field_7761.size(), true) : !this.method_7616(originalStack, 0, this.compositeInventory.method_5439(), false)) {
                return class_1799.field_8037;
            }
            if (originalStack.method_7960()) {
                slot.method_7673(class_1799.field_8037);
            } else {
                slot.method_7670(originalStack, newStack);
            }
        }
        return newStack;
    }

    public static class CompositeSlot
    extends class_1735 {
        public int x;
        public int y;
        @Nullable
        protected State state;

        public CompositeSlot(class_1263 inventory, int index, int x, int y, @Nullable State state) {
            super(inventory, index, x, y);
            this.state = state;
        }

        public int method_7675() {
            return 1;
        }

        public boolean method_7680(class_1799 stack) {
            return StateService.INSTANCE.convert(stack).isPresent() && StateService.INSTANCE.convert(stack).get() instanceof Composite;
        }
    }

    public static class PositionedSlot
    extends class_1735 {
        public int xPosition;
        public int yPosition;
        @Nullable
        public Slot slot;
        @Nullable
        public class_1735 parent;
        private SlotContainer container;

        public PositionedSlot(class_1263 inventory, int index, int xPosition, int yPosition, @Nullable Slot slot, @Nullable class_1735 parent, SlotContainer container) {
            super(inventory, index, xPosition, yPosition);
            this.xPosition = xPosition;
            this.yPosition = yPosition;
            this.slot = slot;
            this.field_7874 = index;
            this.parent = parent;
            this.container = container;
        }

        @Nullable
        public Slot getSlot() {
            return this.slot;
        }

        public int method_7675() {
            return 1;
        }

        public boolean method_7674(class_1657 playerEntity) {
            return this.slot != null;
        }

        public boolean method_7680(class_1799 stack) {
            Optional<State> stateOpt = StateService.INSTANCE.convert(stack);
            return this.slot != null && stateOpt.isPresent() && this.slot.empty().test((Matchable)stateOpt.get(), MatchContext.of());
        }

        public void clear() {
            this.xPosition = 0;
            this.yPosition = 0;
            this.slot = null;
            this.parent = null;
            this.container = null;
            this.field_7871.method_5447(0, class_1799.field_8037);
        }

        public boolean method_7682() {
            return this.slot != null || this.container != null || this.parent != null;
        }
    }

    public static class ToolTree {
        private final TreeNode root;

        public ToolTree(State rootState) {
            this.root = new TreeNode(rootState, null);
        }

        public TreeNode getRoot() {
            return this.root;
        }

        public void buildTree() {
            this.buildTreeHelper(this.root);
        }

        private void buildTreeHelper(TreeNode node) {
            State state = node.getState();
            if (state instanceof ConstructedState) {
                ConstructedState construct = (ConstructedState)state;
                for (State constructed : construct.parts()) {
                    if (!(constructed instanceof Composite)) continue;
                    TreeNode childNode = new TreeNode(constructed, null);
                    node.addChild(childNode);
                    this.buildTreeHelper(childNode);
                }
            }
            if (state instanceof Composite) {
                Composite composite = (Composite)state;
                for (Slot upgradeSlot : composite.slots()) {
                    if (upgradeSlot.category().contains(Category.UNDEFINED)) continue;
                    EmptyState childState = upgradeSlot.filled() ? (State)upgradeSlot.get().get() : new EmptyState();
                    TreeNode childNode = new TreeNode(childState, upgradeSlot);
                    node.addChild(childNode);
                    this.buildTreeHelper(childNode);
                }
            }
        }
    }

    public static class TreeNode {
        private final State state;
        private final List<TreeNode> children;
        @Nullable
        private final Slot slot;
        private TreeNode parent;

        public TreeNode(State state, @Nullable Slot slot) {
            this.state = state;
            this.children = new ArrayList<TreeNode>();
            this.slot = slot;
        }

        public int getLeafCount() {
            if (this.children.isEmpty()) {
                return 1;
            }
            return this.children.stream().mapToInt(TreeNode::getLeafCount).sum();
        }

        public void addChild(TreeNode child) {
            child.parent = this;
            this.children.add(child);
        }

        public State getState() {
            return this.state;
        }

        public List<TreeNode> getChildren() {
            return this.children;
        }

        public TreeNode getParent() {
            return this.parent;
        }
    }

    public static class EmptyState
    implements State {
        public String name() {
            return "empty";
        }

        public String nameSpace() {
            return "forgero";
        }

        public Type type() {
            return Type.of((String)"EMPTY");
        }

        public State strip() {
            return this;
        }

        @NotNull
        public List<Property> getRootProperties(Matchable target, MatchContext context) {
            return this.getRootProperties();
        }
    }
}

