/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.minecraft.common.client.impl.model;

import com.sigmundgranaas.forgero.minecraft.common.client.api.model.ContextAwareBakedModel;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_638;

public class RenderContextManager {
    private static final ThreadLocal<ContextAwareBakedModel.RenderContext> currentContext = new ThreadLocal();
    private static final Set<class_1792> blacklistedItems = new HashSet<class_1792>();
    private static final Set<class_1792> accessedItems = new HashSet<class_1792>();

    public static void setContext(class_1799 stack, class_638 world, class_1309 entity, int seed) {
        if (!blacklistedItems.contains(stack.method_7909())) {
            currentContext.set(new ContextAwareBakedModel.RenderContext(stack, world, entity, seed));
        }
    }

    public static Optional<ContextAwareBakedModel.RenderContext> getCurrentContext() {
        ContextAwareBakedModel.RenderContext context = currentContext.get();
        if (context != null) {
            accessedItems.add(context.stack().method_7909());
        }
        return Optional.ofNullable(context);
    }

    public static void clearContext() {
        ContextAwareBakedModel.RenderContext context = currentContext.get();
        if (context == null) {
            return;
        }
        if (!accessedItems.contains(context.stack().method_7909())) {
            blacklistedItems.add(context.stack().method_7909());
        }
        accessedItems.remove(context.stack().method_7909());
        currentContext.remove();
    }
}

