/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.minecraft.common.client.model.baked;

import com.sigmundgranaas.forgero.core.state.State;
import com.sigmundgranaas.forgero.core.util.match.MatchContext;
import com.sigmundgranaas.forgero.minecraft.common.client.api.model.ContextAwareBakedModel;
import com.sigmundgranaas.forgero.minecraft.common.client.forgerotool.model.implementation.EmptyBakedModel;
import com.sigmundgranaas.forgero.minecraft.common.client.model.baked.BakedModelResult;
import com.sigmundgranaas.forgero.minecraft.common.client.model.baked.ItemModelWrapper;
import com.sigmundgranaas.forgero.minecraft.common.client.model.baked.strategy.ModelStrategy;
import com.sigmundgranaas.forgero.minecraft.common.match.MinecraftContextKeys;
import com.sigmundgranaas.forgero.minecraft.common.service.StateService;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_2350;
import net.minecraft.class_5819;
import net.minecraft.class_638;
import net.minecraft.class_777;
import net.minecraft.class_806;
import net.minecraft.class_809;
import org.jetbrains.annotations.Nullable;

public class DefaultedDynamicBakedModel
implements ContextAwareBakedModel,
ItemModelWrapper {
    private final ModelStrategy strategy;
    private final StateService service;
    @Nullable
    private class_1087 defaultModel;
    private final class_1799 stack;

    public DefaultedDynamicBakedModel(ModelStrategy strategy, StateService service, class_1799 stack) {
        this.strategy = strategy;
        this.service = service;
        this.stack = stack;
    }

    @Override
    public List<class_777> defaultQuads(@Nullable class_2350 face, class_5819 random) {
        return this.getModel(this.stack, null, null, 0).method_4707(null, face, random);
    }

    @Override
    public List<class_777> getQuadsWithContext(class_1799 stack, @Nullable class_638 world, @Nullable class_1309 entity, int seed, @Nullable class_2350 face, class_5819 random) {
        class_1087 result = this.getModel(stack, world, entity, seed);
        return result.method_4707(null, face, random);
    }

    public class_1087 getModel(class_1799 stack, @Nullable class_638 world, @Nullable class_1309 entity, int seed) {
        class_1799 itemStack = Objects.requireNonNullElse(stack, this.stack);
        Optional<State> state = this.service.convert(stack);
        if (state.isPresent()) {
            MatchContext ctx = MatchContext.of((MatchContext.KeyValuePair[])new MatchContext.KeyValuePair[]{new MatchContext.KeyValuePair(MinecraftContextKeys.ENTITY, (Object)entity), new MatchContext.KeyValuePair(MinecraftContextKeys.WORLD, (Object)world), new MatchContext.KeyValuePair(MinecraftContextKeys.STACK, (Object)itemStack)});
            class_1087 model = this.strategy.getModel(state.get(), ctx).map(BakedModelResult::model).or(() -> Optional.ofNullable(this.defaultModel)).orElse(EmptyBakedModel.EMPTY);
            return model.method_4710().method_3495(model, stack, world, entity, seed);
        }
        return EmptyBakedModel.EMPTY;
    }

    @Override
    public class_1058 getParticleSpriteWithContext(class_1799 stack, class_638 world, class_1309 entity, int seed) {
        return this.getModel(stack, world, entity, seed).method_4711();
    }

    @Override
    public class_809 getTransformationWithContext(class_1799 stack, class_638 world, class_1309 entity, int seed) {
        if (this.defaultModel != null) {
            return this.defaultModel.method_4709();
        }
        class_1087 model = this.getModel(stack, world, entity, seed);
        if (model != EmptyBakedModel.EMPTY && model.method_4709() != class_809.field_4301) {
            this.defaultModel = model;
            return this.defaultModel.method_4709();
        }
        return model.method_4709();
    }

    @Override
    public class_806 getOverridesWithContext(class_1799 stack, class_638 world, class_1309 entity, int seed) {
        if (this.defaultModel != null) {
            return this.defaultModel.method_4710();
        }
        class_1087 model = this.getModel(stack, world, entity, seed);
        if (model != EmptyBakedModel.EMPTY && model.method_4710() != class_806.field_4292) {
            this.defaultModel = model;
            return this.defaultModel.method_4710();
        }
        return model.method_4710();
    }
}

