/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.minecraft.common.client.model.baked.strategy;

import com.sigmundgranaas.forgero.core.model.ModelResult;
import com.sigmundgranaas.forgero.core.state.State;
import com.sigmundgranaas.forgero.core.util.match.MatchContext;
import com.sigmundgranaas.forgero.minecraft.common.client.model.baked.BakedModelResult;
import com.sigmundgranaas.forgero.minecraft.common.client.model.baked.DynamicBakedModel;
import com.sigmundgranaas.forgero.minecraft.common.client.model.baked.strategy.ModelStrategy;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import java.util.function.Function;
import java.util.function.Supplier;

public class AsyncModelStrategy
implements ModelStrategy {
    private final ModelStrategy modelProvider;
    private final Map<Integer, BakedModelResult> currentlyBuilding;
    private final ModelStrategy baseModelProvider;
    private final Executor executor;

    public static Supplier<ModelStrategy> of(ModelStrategy modelProvider) {
        return () -> new AsyncModelStrategy(modelProvider);
    }

    public static Supplier<ModelStrategy> of(ModelStrategy modelProvider, Function<Integer, Optional<BakedModelResult>> optionalGetter) {
        return () -> new AsyncModelStrategy(modelProvider, optionalGetter);
    }

    public AsyncModelStrategy(ModelStrategy modelProvider) {
        this.modelProvider = modelProvider;
        this.currentlyBuilding = new ConcurrentHashMap<Integer, BakedModelResult>();
        this.baseModelProvider = (state, context) -> Optional.of(this.emptyBaseModel());
        this.executor = ForkJoinPool.commonPool();
    }

    public AsyncModelStrategy(ModelStrategy modelProvider, Function<Integer, Optional<BakedModelResult>> optionalGetter) {
        this.modelProvider = modelProvider;
        this.currentlyBuilding = new ConcurrentHashMap<Integer, BakedModelResult>();
        this.baseModelProvider = (state, context) -> (Optional)optionalGetter.apply(state.hashCode());
        this.executor = ForkJoinPool.commonPool();
    }

    public AsyncModelStrategy(ModelStrategy modelProvider, Function<Integer, Optional<BakedModelResult>> optionalGetter, Executor executor) {
        this.modelProvider = modelProvider;
        this.currentlyBuilding = new ConcurrentHashMap<Integer, BakedModelResult>();
        this.baseModelProvider = (state, context) -> (Optional)optionalGetter.apply(state.hashCode());
        this.executor = executor;
    }

    @Override
    public Optional<BakedModelResult> getModel(State state, MatchContext context) {
        int key = state.hashCode();
        if (this.currentlyBuilding.containsKey(key)) {
            return Optional.ofNullable(this.currentlyBuilding.get(key));
        }
        return this.triggerAsyncRebuild(state, context);
    }

    private Optional<BakedModelResult> triggerAsyncRebuild(State state, MatchContext context) {
        int key = state.hashCode();
        BakedModelResult base = this.baseModelProvider.getModel(state, context).orElseGet(this::emptyBaseModel);
        this.currentlyBuilding.put(key, base);
        CompletableFuture.supplyAsync(() -> this.modelProvider.getModel(state, context).get(), this.executor).thenAccept(m -> {
            BakedModelResult builtModel = this.currentlyBuilding.get(key);
            builtModel.result(m.result());
            builtModel.model(m.model());
            this.currentlyBuilding.remove(key);
        });
        return Optional.of(base);
    }

    private BakedModelResult emptyBaseModel() {
        DynamicBakedModel dynamicModel = new DynamicBakedModel();
        ModelResult result = new ModelResult();
        return new BakedModelResult(result, dynamicModel);
    }
}

