/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.minecraft.common.client.model.baked.strategy;

import com.sigmundgranaas.forgero.core.cache.LayeredMatchedOptionCache;
import com.sigmundgranaas.forgero.core.state.State;
import com.sigmundgranaas.forgero.core.util.match.MatchContext;
import com.sigmundgranaas.forgero.core.util.match.Matchable;
import com.sigmundgranaas.forgero.minecraft.common.client.model.baked.BakedModelResult;
import com.sigmundgranaas.forgero.minecraft.common.client.model.baked.strategy.ModelStrategy;
import java.time.Duration;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.function.Supplier;

public class LayeredCachedSingleStateStrategy
implements ModelStrategy {
    private ModelStrategy fallBack = (state, ctx) -> Optional.empty();
    private final LayeredMatchedOptionCache<Integer, Optional<BakedModelResult>> modelCache = new LayeredMatchedOptionCache(Duration.ofMinutes(1L), Integer.valueOf(20));

    @Override
    public Optional<BakedModelResult> getModel(State state, MatchContext context) {
        int stateHash = state.hashCode();
        Supplier<Optional> callback = () -> this.fallBack.getModel(state, context);
        Predicate<Optional> predicate = model -> model.isPresent() && ((BakedModelResult)model.get()).result().isValid((Matchable)state, context);
        return (Optional)this.modelCache.get((Object)stateHash, callback, predicate);
    }

    public Optional<BakedModelResult> getPreviousModel(Integer key) {
        Optional opt = this.modelCache.getPrevious((Object)key);
        return opt.orElseGet(Optional::empty);
    }

    @Override
    public ModelStrategy then(ModelStrategy strategy) {
        this.fallBack = strategy;
        return this;
    }
}

