/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.minecraft.common.client.model.baked.strategy;

import com.sigmundgranaas.forgero.core.model.CompositeModelTemplate;
import com.sigmundgranaas.forgero.core.model.ModelRegistry;
import com.sigmundgranaas.forgero.core.model.ModelResult;
import com.sigmundgranaas.forgero.core.model.ModelTemplate;
import com.sigmundgranaas.forgero.core.model.PaletteTemplateModel;
import com.sigmundgranaas.forgero.core.model.TextureBasedModel;
import com.sigmundgranaas.forgero.core.model.TextureModel;
import com.sigmundgranaas.forgero.core.state.State;
import com.sigmundgranaas.forgero.core.util.match.MatchContext;
import com.sigmundgranaas.forgero.minecraft.common.client.model.baked.BakedModelResult;
import com.sigmundgranaas.forgero.minecraft.common.client.model.baked.strategy.ModelStrategy;
import com.sigmundgranaas.forgero.minecraft.common.client.model.unbaked.Unbaked2DTexturedModel;
import com.sigmundgranaas.forgero.minecraft.common.client.model.unbaked.UnbakedDynamicModel;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_4730;
import net.minecraft.class_7775;

public class StateModelBaker
implements ModelStrategy {
    private final class_7775 baker;
    private final Function<class_4730, class_1058> textureGetter;
    private final ModelRegistry registry;

    public StateModelBaker(class_7775 baker, Function<class_4730, class_1058> textureGetter, ModelRegistry registry) {
        this.baker = baker;
        this.textureGetter = textureGetter;
        this.registry = registry;
    }

    public Optional<BakedModelResult> bake(State state, MatchContext context) {
        return this.registry.find(state, (MatchContext)MatchContext.mutable((MatchContext)context)).flatMap(this::convertModel);
    }

    private Optional<BakedModelResult> convertModel(ModelResult template) {
        Optional unbakedModel = (Optional)template.getTemplate().convert(this::modelConverter);
        if (unbakedModel.isPresent()) {
            return unbakedModel.map(UnbakedDynamicModel::bake).map(baked -> new BakedModelResult(template, (class_1087)baked));
        }
        return Optional.empty();
    }

    private Optional<UnbakedDynamicModel> modelConverter(ModelTemplate input) {
        ArrayList<ModelTemplate> textureList = new ArrayList<ModelTemplate>();
        if (input instanceof CompositeModelTemplate) {
            CompositeModelTemplate model = (CompositeModelTemplate)input;
            model.getModels().forEach(template -> this.textureCollector((ModelTemplate)template, (List<ModelTemplate>)textureList));
            Unbaked2DTexturedModel unbakedModel = new Unbaked2DTexturedModel(this.baker, this.textureGetter, textureList, "dummy");
            return Optional.of(unbakedModel);
        }
        if (input instanceof TextureBasedModel) {
            TextureBasedModel model = (TextureBasedModel)input;
            this.textureCollector((ModelTemplate)model, textureList);
            Unbaked2DTexturedModel unbakedModel = new Unbaked2DTexturedModel(this.baker, this.textureGetter, textureList, model.getTexture());
            return Optional.of(unbakedModel);
        }
        return Optional.empty();
    }

    private void textureCollector(ModelTemplate template, List<ModelTemplate> accumulator) {
        if (template instanceof PaletteTemplateModel) {
            PaletteTemplateModel palette = (PaletteTemplateModel)template;
            this.textureCollector(palette, accumulator);
        } else if (template instanceof CompositeModelTemplate) {
            CompositeModelTemplate composite = (CompositeModelTemplate)template;
            this.textureCollector(composite, accumulator);
        } else if (template instanceof TextureModel) {
            TextureModel textureModel = (TextureModel)template;
            this.textureCollector(textureModel, accumulator);
        }
    }

    private void textureCollector(PaletteTemplateModel template, List<ModelTemplate> accumulator) {
        accumulator.add((ModelTemplate)template);
        template.children().forEach(child -> this.textureCollector((ModelTemplate)child, accumulator));
    }

    private void textureCollector(CompositeModelTemplate template, List<ModelTemplate> accumulator) {
        template.getModels().forEach(model -> this.textureCollector((ModelTemplate)model, accumulator));
    }

    private void textureCollector(TextureModel template, List<ModelTemplate> accumulator) {
        accumulator.add((ModelTemplate)template);
        template.children().forEach(child -> this.textureCollector((ModelTemplate)child, accumulator));
    }

    @Override
    public Optional<BakedModelResult> getModel(State state, MatchContext context) {
        return this.bake(state, context);
    }
}

