/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.minecraft.common.client.model.baked.strategy;

import com.sigmundgranaas.forgero.core.model.Strategy;
import com.sigmundgranaas.forgero.core.state.State;
import com.sigmundgranaas.forgero.core.util.match.MatchContext;
import com.sigmundgranaas.forgero.minecraft.common.client.model.baked.BakedModelResult;
import com.sigmundgranaas.forgero.minecraft.common.client.model.baked.strategy.AsyncModelStrategy;
import com.sigmundgranaas.forgero.minecraft.common.client.model.baked.strategy.DefaultModelStrategy;
import com.sigmundgranaas.forgero.minecraft.common.client.model.baked.strategy.LayeredCachedSingleStateStrategy;
import com.sigmundgranaas.forgero.minecraft.common.client.model.baked.strategy.LazyDefaultModelStrategy;
import com.sigmundgranaas.forgero.minecraft.common.client.model.baked.strategy.ModelStrategy;
import com.sigmundgranaas.forgero.minecraft.common.client.model.baked.strategy.SingleCachedStateStrategy;
import java.util.Optional;
import java.util.function.Function;

public class StrategyFactory {
    private final ModelStrategy baker;
    private final Strategy strategy;

    public StrategyFactory(ModelStrategy baker, Strategy strategy) {
        this.baker = baker;
        this.strategy = strategy;
    }

    public ModelStrategy build(State state) {
        return switch (this.strategy) {
            default -> throw new IncompatibleClassChangeError();
            case Strategy.FULLY_ASYNC -> this.fullyAsync(state);
            case Strategy.PRE_BAKED -> this.PreBaked(state);
            case Strategy.NO_ASYNC -> this.noAsync(state);
            case Strategy.NO_CACHE -> this.baker;
        };
    }

    private ModelStrategy PreBaked(State state) {
        ModelStrategy defaultModel = this.defaultBaked(state);
        LayeredCachedSingleStateStrategy cache = this.layeredCache();
        ModelStrategy asyncBaker = this.backedAsyncStrategy(cache::getPreviousModel);
        return defaultModel.then(this.singleCache().then(cache.then(asyncBaker)));
    }

    private ModelStrategy noAsync(State state) {
        ModelStrategy defaultModel = this.defaultBaked(state);
        LayeredCachedSingleStateStrategy cache = this.layeredCache();
        return defaultModel.then(this.singleCache().then(cache.then(this.baker)));
    }

    private ModelStrategy defaultBaked(State state) {
        return new DefaultModelStrategy(this.baker.getModel(state, MatchContext.of()).orElseThrow(), state.hashCode());
    }

    private ModelStrategy fullyAsync(State state) {
        ModelStrategy lazy = this.lazyDefaultBaker(state);
        LayeredCachedSingleStateStrategy cache = this.layeredCache();
        ModelStrategy asyncBaker = this.backedAsyncStrategy(cache::getPreviousModel);
        return lazy.then(this.singleCache().then(cache.then(asyncBaker)));
    }

    private ModelStrategy lazyDefaultBaker(State state) {
        return new LazyDefaultModelStrategy(state.hashCode(), () -> this.asyncBaker().getModel(state, MatchContext.of()).orElseThrow());
    }

    private ModelStrategy asyncBaker() {
        return new AsyncModelStrategy(this.baker);
    }

    private SingleCachedStateStrategy singleCache() {
        return new SingleCachedStateStrategy();
    }

    private LayeredCachedSingleStateStrategy layeredCache() {
        return new LayeredCachedSingleStateStrategy();
    }

    private ModelStrategy backedAsyncStrategy(Function<Integer, Optional<BakedModelResult>> optionalGetter) {
        return new AsyncModelStrategy(this.baker, optionalGetter);
    }
}

